/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import org.eclipse.bpel.common.ui.palette.GraphicalEditorWithPalette;
import org.eclipse.bpel.common.ui.tray.TrayComposite;
import org.eclipse.bpel.common.ui.tray.TrayKeyHandler;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.ViewportLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.widgets.Composite;

public abstract class GraphicalEditorWithPaletteAndTray
extends GraphicalEditorWithPalette {
    protected TrayComposite trayComposite;
    protected GraphicalViewer trayViewer;

    @Override
    public void dispose() {
        super.dispose();
        this.trayViewer = null;
    }

    public TrayComposite getTrayComposite() {
        return this.trayComposite;
    }

    public GraphicalViewer getTrayViewer() {
        return this.trayViewer;
    }

    public void createPartControl(Composite parent) {
        this.trayComposite = new TrayComposite(parent, 0);
        Composite editorComposite = this.trayComposite.getEditorComposite();
        super.createPartControl(editorComposite);
        this.createTrayViewer((Composite)this.trayComposite);
        this.trayComposite.setTrayControl(this.trayViewer.getControl());
    }

    protected void createTrayViewer(Composite parent) {
        this.trayViewer = new ScrollingGraphicalViewer();
        this.trayViewer.createControl(parent);
        FigureCanvas canvas = (FigureCanvas)this.trayViewer.getControl();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.getViewport().setLayoutManager((LayoutManager)new ViewportLayout(){

            public void layout(IFigure figure) {
                Viewport viewport = (Viewport)figure;
                IFigure contents = viewport.getContents();
                if (contents == null) {
                    return;
                }
                Point p = viewport.getClientArea().getLocation();
                p.translate(viewport.getViewLocation().getNegated());
                Dimension newSize = viewport.getClientArea().getSize();
                contents.setBounds(new Rectangle(p, newSize));
            }
        });
        this.trayViewer.setKeyHandler((KeyHandler)new TrayKeyHandler((EditPartViewer)this.trayViewer));
        this.initializeTrayViewer();
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected abstract void initializeTrayViewer();
}

