/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLDBUtil;

public class DBVersionHelper {
    public static final String DEFAULT_FAMILY = "DB2";
    public static final String DEFAULT_PRODUCT = "DB2_LUW";
    public static final String DEFAULT_VERSION_STRING = "7.1.0";
    public static final String FAMILY_CLOUDSCAPE = "CLOUDSCAPE";
    public static final String FAMILY_DB2 = "DB2";
    public static final String FAMILY_INFORMIX = "INFORMIX";
    public static final String FAMILY_MYSQL = "MYSQL";
    public static final String FAMILY_ORACLE = "ORACLE";
    public static final String FAMILY_SQL_SERVER = "SQL_SERVER";
    public static final String FAMILY_SYBASE = "SYBASE";
    public static final String PRODUCT_CLOUDSCAPE = "CLOUDSCAPE";
    public static final String PRODUCT_DB2_EVERYPLACE = "DB2_EVERYPLACE";
    public static final String PRODUCT_DB2_ISERIES = "DB2_ISERIES";
    public static final String PRODUCT_DB2_LUW = "DB2_LUW";
    public static final String PRODUCT_DB2_ZOS = "DB2_ZOS";
    public static final String PRODUCT_DB2_VMVSE = "DB2_VMVSE";
    public static final String PRODUCT_DERBY = "DERBY";
    public static final String PRODUCT_INFORMIX = "INFORMIX";
    public static final String PRODUCT_MYSQL = "MYSQL";
    public static final String PRODUCT_ORACLE = "ORACLE";
    public static final String PRODUCT_SQL_SERVER = "SQL_SERVER";
    public static final String PRODUCT_SYBASE_ASA = "SYBASE_ASA";
    public static final String PRODUCT_SYBASE_ASE = "SYBASE_ASE";
    public static final String ID_DB2 = "DB2";
    public static final String ID_DB2_PREFIX = "DB2/";
    public static final String ID_DB2_UDB = "DB2 UDB";
    public static final String ID_DB2_UDB_ZSERIES = "DB2 UDB zSeries";
    public static final String ID_AS = "AS";
    public static final String ID_AS400 = "AS400";
    public static final String ID_DB2400_SQL = "DB2/400 SQL";
    public static final String ID_DB2_UDB_AS400 = "DB2 UDB for AS/400";
    public static final String ID_DB2_UDB_ISERIES = "DB2 UDB iSeries";
    public static final String ID_DB2_EVERYPLACE = "";
    public static final String ID_SQLDS = "SQLDS";
    public static final String ID_WORKSTATION = "WORKSTATION";
    public static final String ID_IBM_CLOUDSCAPE = "IBM Cloudscape";
    public static final String ID_APACHE_DERBY = "Apache Derby";
    public static final String ID_DERBY = "Derby";
    public static final String ID_INFORMIX = "<informix placeholder>";
    public static final String ID_MYSQL = "<mySQL placeholder>";
    public static final String ID_ORACLE = "<oracle placeholder>";
    public static final String ID_SQL_SERVER = "<SQL Server placeholder>";
    public static final String ID_SYBASE_ASA = "<Sybase ASA placeholder>";
    public static final String ID_SYBASE_ASE = "<Sybase ASE placeholder>";
    private String fProductFamily = "";
    private String fProduct = "";
    private String fProductIDString = "";
    private String fVersionString = "";
    private int fVersion = 0;
    private int fRelease = 0;
    private int fMod = 0;

    public DBVersionHelper() {
        this.fProductFamily = "DB2";
        this.fProduct = "DB2_LUW";
        this.fProductIDString = ID_DB2_EVERYPLACE;
        this.fVersionString = DEFAULT_VERSION_STRING;
        this.parseVersionString(this.fVersionString);
    }

    public DBVersionHelper(Connection conn) {
        this();
        if (conn != null) {
            try {
                this.fProductIDString = conn.getMetaData().getDatabaseProductName();
                this.fVersionString = conn.getMetaData().getDatabaseProductVersion();
                this.parseProductIDString(this.fProductIDString);
                this.parseVersionString(this.fVersionString);
            }
            catch (SQLException sQLException) {}
        }
    }

    public DBVersionHelper(ISQLEditorConnectionInfo connInfo) {
        this();
        if (connInfo != null) {
            connInfo.getDatabase();
            DatabaseDefinition dbDef = SQLDBUtil.getDatabaseDefinition(connInfo);
            if (dbDef != null) {
                this.fProductIDString = dbDef.getProduct();
                this.fVersionString = dbDef.getVersion();
            }
            this.parseProductIDString(this.fProductIDString);
            this.parseVersionString(this.fVersionString);
        }
    }

    public DBVersionHelper(Database db) {
        this();
        if (db != null) {
            this.fProductIDString = db.getVendor();
            this.fVersionString = db.getVersion();
            this.parseProductIDString(this.fProductIDString);
            this.parseVersionString(this.fVersionString);
        }
    }

    public DBVersionHelper(String versionString) {
        this();
        if (versionString != null) {
            this.fVersionString = versionString;
            this.parseVersionString(versionString);
        }
    }

    public DBVersionHelper(int version, int release, int mod) {
        this();
        this.setVersionReleaseMod(version, release, mod);
    }

    public DBVersionHelper(String productFamily, String product, int version, int release, int mod) {
        if (productFamily != null) {
            this.fProductFamily = productFamily;
        }
        if (product != null) {
            this.fProduct = product;
        }
        this.setVersionReleaseMod(version, release, mod);
    }

    public DBVersionHelper(DBVersionHelper other) {
        if (other != null) {
            this.fProductFamily = other.getProductFamily();
            this.fProduct = other.getProduct();
            this.fProductIDString = other.getProductIDString();
            this.fVersionString = other.getVersionString();
            this.fVersion = other.getVersion();
            this.fRelease = other.getRelease();
            this.fMod = other.getMod();
        }
    }

    public int getMod() {
        return this.fMod;
    }

    public String getProductFamily() {
        return this.fProductFamily;
    }

    public String getProduct() {
        return this.fProduct;
    }

    public String getProductIDString() {
        return this.fProductIDString;
    }

    public int getRelease() {
        return this.fRelease;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public String getVersionString() {
        return this.fVersionString;
    }

    public boolean isCloudscape() {
        boolean isDB = this.fProduct.equals("CLOUDSCAPE") || this.fProduct.equals(PRODUCT_DERBY);
        return isDB;
    }

    public boolean isDB2() {
        boolean isDB = this.fProductFamily.equals("DB2");
        return isDB;
    }

    public boolean isDB2_UDB() {
        boolean isDB = this.isDB2_iSeries() || this.isDB2_LUW() || this.isDB2_zOS();
        return isDB;
    }

    public boolean isDB2_390() {
        boolean isDB = this.isDB2_zOS();
        return isDB;
    }

    public boolean isDB2_400() {
        boolean isDB = this.isDB2_iSeries();
        return isDB;
    }

    public boolean isDB2_Everyplace() {
        boolean isDB = this.fProduct.equals(PRODUCT_DB2_EVERYPLACE);
        return isDB;
    }

    public boolean isDB2_iSeries() {
        boolean isDB = this.fProduct.equals(PRODUCT_DB2_ISERIES);
        return isDB;
    }

    public boolean isDB2_LUW() {
        boolean isDB = this.fProduct.equals("DB2_LUW");
        return isDB;
    }

    public boolean isDB2_VMVSE() {
        boolean isDB = this.fProduct.equals(PRODUCT_DB2_VMVSE);
        return isDB;
    }

    public boolean isDB2_zOS() {
        boolean isDB = this.fProduct.equals(PRODUCT_DB2_ZOS);
        return isDB;
    }

    public boolean isDerby() {
        boolean isDB = this.fProduct.equals(PRODUCT_DERBY) || this.fProduct.equals("CLOUDSCAPE");
        return isDB;
    }

    public boolean isInformix() {
        boolean isDB = this.fProduct.equals("INFORMIX");
        return isDB;
    }

    public boolean isMySQL() {
        boolean isDB = this.fProduct.equals("MYSQL");
        return isDB;
    }

    public boolean isOracle() {
        boolean isDB = this.fProduct.equals("ORACLE");
        return isDB;
    }

    public boolean isSQLServer() {
        boolean isDB = this.fProduct.equals("SQL_SERVER");
        return isDB;
    }

    public boolean isSybase() {
        boolean isDB = this.fProductFamily.equals(FAMILY_SYBASE);
        return isDB;
    }

    public boolean isSybase_ASA() {
        boolean isDB = this.fProduct.equals(PRODUCT_SYBASE_ASA);
        return isDB;
    }

    public boolean isSybase_ASE() {
        boolean isDB = this.fProduct.equals(PRODUCT_SYBASE_ASA);
        return isDB;
    }

    public boolean isAtLeast(int version) {
        boolean dbIsAtLeast = false;
        if (this.fVersion >= version) {
            dbIsAtLeast = true;
        }
        return dbIsAtLeast;
    }

    public boolean isAtLeast(int version, int release) {
        boolean dbIsAtLeast = false;
        if (this.fVersion > version) {
            dbIsAtLeast = true;
        } else if (this.fVersion == version && this.fRelease >= release) {
            dbIsAtLeast = true;
        }
        return dbIsAtLeast;
    }

    public boolean isAtLeast(int version, int release, int mod) {
        boolean dbIsAtLeast = false;
        if (this.fVersion > version) {
            dbIsAtLeast = true;
        } else if (this.fVersion == version) {
            if (this.fRelease > release) {
                dbIsAtLeast = true;
            } else if (this.fRelease == release && this.fMod >= mod) {
                dbIsAtLeast = true;
            }
        }
        return dbIsAtLeast;
    }

    public boolean isAtMost(int version) {
        boolean dbIsAtMost = false;
        if (this.fVersion <= version) {
            dbIsAtMost = true;
        }
        return dbIsAtMost;
    }

    public boolean isAtMost(int version, int release) {
        boolean dbIsAtMost = false;
        if (this.fVersion < version) {
            dbIsAtMost = true;
        } else if (this.fVersion == version && this.fRelease <= release) {
            dbIsAtMost = true;
        }
        return dbIsAtMost;
    }

    public boolean isAtMost(int version, int release, int mod) {
        boolean dbIsAtMost = false;
        if (this.fVersion < version) {
            dbIsAtMost = true;
        } else if (this.fVersion == version) {
            if (this.fRelease < release) {
                dbIsAtMost = true;
            } else if (this.fRelease == release && this.fMod <= mod) {
                dbIsAtMost = true;
            }
        }
        return dbIsAtMost;
    }

    public boolean isExactly(int version) {
        boolean dbIsExactly = false;
        if (this.fVersion == version) {
            dbIsExactly = true;
        }
        return dbIsExactly;
    }

    public boolean isExactly(int version, int release) {
        boolean dbIsExactly = false;
        if (this.fVersion == version && this.fRelease == release) {
            dbIsExactly = true;
        }
        return dbIsExactly;
    }

    public boolean isExactly(int version, int release, int mod) {
        boolean dbIsExactly = false;
        if (this.fVersion == version && this.fRelease == release && this.fMod == mod) {
            dbIsExactly = true;
        }
        return dbIsExactly;
    }

    protected void parseProductIDString(String prodStr) {
        if ((prodStr = prodStr.trim()).equals(ID_APACHE_DERBY)) {
            this.fProductFamily = "CLOUDSCAPE";
            this.fProduct = PRODUCT_DERBY;
        }
        if (prodStr.equals(ID_DERBY)) {
            this.fProductFamily = "CLOUDSCAPE";
            this.fProduct = PRODUCT_DERBY;
        } else if (prodStr.equals(ID_IBM_CLOUDSCAPE)) {
            this.fProductFamily = "CLOUDSCAPE";
            this.fProduct = "CLOUDSCAPE";
        } else if (prodStr.equals(ID_DB2_EVERYPLACE)) {
            this.fProductFamily = "DB2";
            this.fProduct = PRODUCT_DB2_EVERYPLACE;
        } else if (prodStr.equals(ID_AS) || prodStr.equals(ID_AS400) || prodStr.equals(ID_DB2400_SQL) || prodStr.equals(ID_DB2_UDB_AS400) || prodStr.equals(ID_DB2_UDB_ISERIES)) {
            this.fProductFamily = "DB2";
            this.fProduct = PRODUCT_DB2_ISERIES;
        } else if (prodStr.equals(ID_WORKSTATION) || prodStr.equals(ID_DB2_UDB) || prodStr.startsWith(ID_DB2_PREFIX) && !prodStr.equals(ID_DB2400_SQL)) {
            this.fProductFamily = "DB2";
            this.fProduct = "DB2_LUW";
        } else if (prodStr.equals("DB2") || prodStr.equals(ID_DB2_UDB_ZSERIES)) {
            this.fProductFamily = "DB2";
            this.fProduct = PRODUCT_DB2_ZOS;
        } else if (prodStr.equals(ID_SQLDS)) {
            this.fProductFamily = "DB2";
            this.fProduct = PRODUCT_DB2_VMVSE;
        } else if (prodStr.equals(ID_INFORMIX)) {
            this.fProductFamily = "INFORMIX";
            this.fProduct = "INFORMIX";
        } else if (prodStr.equals(ID_MYSQL)) {
            this.fProductFamily = "MYSQL";
            this.fProduct = "MYSQL";
        } else if (prodStr.equals(ID_ORACLE)) {
            this.fProductFamily = "ORACLE";
            this.fProduct = "ORACLE";
        } else if (prodStr.equals(ID_SQL_SERVER)) {
            this.fProductFamily = "SQL_SERVER";
            this.fProduct = "SQL_SERVER";
        } else if (prodStr.equals(ID_SYBASE_ASA)) {
            this.fProductFamily = FAMILY_SYBASE;
            this.fProduct = PRODUCT_SYBASE_ASA;
        } else if (prodStr.equals(ID_SYBASE_ASE)) {
            this.fProductFamily = FAMILY_SYBASE;
            this.fProduct = PRODUCT_SYBASE_ASE;
        }
    }

    protected void parseVersionString(String versionString) {
        if (versionString != null && versionString.length() > 0) {
            if (versionString.substring(0, 1).equalsIgnoreCase("V")) {
                this.parseNumericVersion(versionString.substring(1));
            } else if (versionString.startsWith("SQL")) {
                this.parseSQLVersion(versionString.substring(3));
            } else {
                char c = versionString.charAt(0);
                if (Character.isDigit(c)) {
                    this.parseNumericVersion(versionString);
                }
            }
        }
    }

    protected void parseNumericVersion(String versionString) {
        this.fVersion = 0;
        this.fRelease = 0;
        this.fMod = 0;
        StringTokenizer st = new StringTokenizer(versionString, ". \t");
        String tkn = null;
        try {
            if (st.hasMoreTokens()) {
                tkn = st.nextToken();
                this.fVersion = Integer.parseInt(tkn);
            }
            if (st.hasMoreTokens()) {
                tkn = st.nextToken();
                this.fRelease = Integer.parseInt(tkn);
            }
            if (st.hasMoreTokens()) {
                tkn = st.nextToken();
                this.fMod = Integer.parseInt(tkn);
            }
        }
        catch (Exception exception) {}
    }

    protected void parseSQLVersion(String versionString) {
        this.fVersion = 0;
        this.fRelease = 0;
        this.fMod = 0;
        try {
            String verStr = versionString.substring(0, 2);
            this.fVersion = Integer.parseInt(verStr);
            String relStr = versionString.substring(2, 4);
            this.fRelease = Integer.parseInt(relStr);
            String modStr = versionString.substring(4);
            this.fMod = Integer.parseInt(modStr);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void setProductFamily(String family) {
        if (family != null) {
            this.fProductFamily = family;
        }
    }

    public void setProduct(String product) {
        if (product != null) {
            this.fProduct = product;
        }
    }

    public void setProductIDString(String prodStr) {
        if (prodStr != null) {
            this.fProductIDString = prodStr;
            this.parseProductIDString(prodStr);
        }
    }

    public void setVersionString(String versionString) {
        if (versionString != null) {
            this.fVersionString = versionString;
            this.parseVersionString(versionString);
        }
    }

    public void setVersionReleaseMod(int version, int release, int mod) {
        this.fVersion = version;
        this.fRelease = release;
        this.fMod = mod;
        this.fVersionString = this.fVersion + "." + this.fRelease + "." + this.fMod;
    }

    public String toString() {
        String result = ID_DB2_EVERYPLACE;
        result = String.valueOf(this.fProduct) + " " + this.fVersion + "." + this.fRelease + "." + this.fMod;
        return result;
    }
}

