/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.topic;

import org.ros.internal.message.Md5Generator;
import org.ros.internal.message.topic.TopicDescription;
import org.ros.message.MessageDefinitionProvider;

public class TopicDescriptionFactory {
    private final MessageDefinitionProvider messageDefinitionProvider;
    private final Md5Generator md5Generator;

    public TopicDescriptionFactory(MessageDefinitionProvider messageDefinitionProvider) {
        this.messageDefinitionProvider = messageDefinitionProvider;
        this.md5Generator = new Md5Generator(messageDefinitionProvider);
    }

    public TopicDescription newFromType(String topicType) {
        String md5Checksum = this.md5Generator.generate(topicType);
        String topicDefinition = this.messageDefinitionProvider.get(topicType);
        return new TopicDescription(topicType, topicDefinition, md5Checksum);
    }

    public boolean hasType(String topicType) {
        return this.messageDefinitionProvider.has(topicType);
    }
}

