/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;

public class ShortArrayField
extends Field {
    private final int size;
    private short[] value;

    public static ShortArrayField newVariable(FieldType type, String name, int size) {
        return new ShortArrayField(type, name, size);
    }

    private ShortArrayField(FieldType type, String name, int size) {
        super(type, name, false);
        this.size = size;
        this.setValue(new short[Math.max(0, size)]);
    }

    public short[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        Preconditions.checkArgument((this.size < 0 || ((short[])value).length == this.size ? 1 : 0) != 0);
        this.value = (short[])value;
    }

    @Override
    public void serialize(ChannelBuffer buffer) {
        if (this.size < 0) {
            buffer.writeInt(this.value.length);
        }
        short[] sArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            short v = sArray[n2];
            this.type.serialize(v, buffer);
            ++n2;
        }
    }

    @Override
    public void deserialize(ChannelBuffer buffer) {
        int currentSize = this.size;
        if (currentSize < 0) {
            currentSize = buffer.readInt();
        }
        this.value = new short[currentSize];
        int i = 0;
        while (i < currentSize) {
            this.value[i] = buffer.readShort();
            ++i;
        }
    }

    @Override
    public String getMd5String() {
        return String.format("%s %s\n", this.type, this.name);
    }

    @Override
    public String getJavaTypeName() {
        return String.valueOf(this.type.getJavaTypeName()) + "[]";
    }

    public String toString() {
        return "ShortArrayField<" + this.type + ", " + this.name + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShortArrayField other = (ShortArrayField)obj;
        return !(this.value == null ? other.value != null : !Arrays.equals(this.value, other.value));
    }
}

