/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;

public class ListField<T>
extends Field {
    private List<T> value = new ArrayList<T>();

    public static <T> ListField<T> newVariable(FieldType type, String name) {
        return new ListField<T>(type, name);
    }

    private ListField(FieldType type, String name) {
        super(type, name, false);
    }

    public List<T> getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        Preconditions.checkNotNull((Object)value);
        this.value = (List)value;
    }

    @Override
    public void serialize(ChannelBuffer buffer) {
        buffer.writeInt(this.value.size());
        for (T v : this.value) {
            this.type.serialize(v, buffer);
        }
    }

    @Override
    public void deserialize(ChannelBuffer buffer) {
        this.value.clear();
        int size = buffer.readInt();
        int i = 0;
        while (i < size) {
            this.value.add(this.type.deserialize(buffer));
            ++i;
        }
    }

    @Override
    public String getMd5String() {
        return String.format("%s %s\n", this.type, this.name);
    }

    @Override
    public String getJavaTypeName() {
        return String.format("java.util.List<%s>", this.type.getJavaTypeName());
    }

    public String toString() {
        return "ListField<" + this.type + ", " + this.name + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListField other = (ListField)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

