/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.examples.lander.Lander;
import org.eclipse.apogy.examples.lander.provider.LanderItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class LanderCustomItemProvider
extends LanderItemProvider {
    private final DecimalFormat fuelMassFormat = new DecimalFormat("0.0");
    private final DecimalFormat thrustFormat = new DecimalFormat("0");

    public LanderCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Lander lander = (Lander)object;
        String label = this.getString("UI_Lander_type");
        label = String.valueOf(label) + this.getLanderSuffixText(lander);
        return label;
    }

    protected String getLanderSuffixText(Lander lander) {
        String text = "";
        text = String.valueOf(text) + "(Fuel : " + this.fuelMassFormat.format(lander.getFuelMass()) + " kg";
        if (lander.getThruster() != null) {
            text = String.valueOf(text) + ", Thrust : " + this.thrustFormat.format(lander.getThruster().getCurrentThrust()) + " N";
        }
        text = String.valueOf(text) + ")";
        return text;
    }
}

