/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.renderers;

import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.ui.composites.Matrix4x4Composite;
import org.eclipse.apogy.common.math.ui.composites.TransformMatrixComposite;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matrix4x4ControlRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(Matrix4x4ControlRenderer.class);
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    @Inject
    public Matrix4x4ControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        return new Binding[0];
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        Matrix4x4 matrix = (Matrix4x4)this.getValue();
        if (matrix == null) {
            matrix = ApogyCommonMathFactory.eINSTANCE.createMatrix4x4();
            this.getModelValue().setValue((Object)matrix);
        }
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        TransformMatrixComposite transformComposite = new TransformMatrixComposite(composite, 0, (EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)matrix));
        transformComposite.setMatrix4x4(matrix);
        transformComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        transformComposite.setBackground(parent.getDisplay().getSystemColor(1));
        Section section = this.toolkit.createSection(composite, 258);
        this.toolkit.adapt((Composite)section);
        section.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        section.setExpanded(false);
        section.setText("Complete");
        Matrix4x4Composite completeMatrixcomposite = new Matrix4x4Composite((Composite)section, 0, (EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)matrix));
        completeMatrixcomposite.setMatrix4x4(matrix);
        completeMatrixcomposite.setBackground(parent.getDisplay().getSystemColor(1));
        section.setClient((Control)completeMatrixcomposite);
        return composite;
    }

    protected String getUnsetText() {
        return "Unset";
    }

    protected Object getValue() {
        try {
            Object obj = this.getModelValue().getValue();
            return obj;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error setting the RGB value.", (Throwable)e);
            return null;
        }
    }

    protected void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }
}

