/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.composites;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.provider.MathEditUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class RotationMatrixSlidersComposite
extends Composite {
    private EditingDomain editingDomain;
    private Matrix3x3 matrix;
    private boolean disableEvent = false;
    private Adapter matrixAdapter;
    private final Slider rxSlider;
    private final Slider rySlider;
    private final Slider rzSlider;

    public RotationMatrixSlidersComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, true));
        Label rxLabel = new Label((Composite)this, 0);
        rxLabel.setAlignment(16384);
        rxLabel.setText("Rx (deg):");
        this.rxSlider = this.createSlider(this, 2308, RotationAxis.X);
        this.rxSlider.setToolTipText("Rotation about X in degrees.");
        this.rxSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label ryLabel = new Label((Composite)this, 0);
        ryLabel.setAlignment(16384);
        ryLabel.setText("Ry (deg):");
        this.rySlider = this.createSlider(this, 2308, RotationAxis.Y);
        this.rySlider.setToolTipText("Rotation about Y in degrees.");
        this.rySlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label rzLabel = new Label((Composite)this, 0);
        rzLabel.setAlignment(16384);
        rzLabel.setText("Rz (deg):");
        this.rzSlider = this.createSlider(this, 2308, RotationAxis.Z);
        this.rzSlider.setToolTipText("Rotation about Z in degrees.");
        this.rzSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public RotationMatrixSlidersComposite(Composite parent, int style, EditingDomain editingDomain) {
        this(parent, style);
        this.editingDomain = editingDomain;
    }

    public void setMatrix3x3(Matrix3x3 newMatrix3x3) {
        this.setMatrix3x3(newMatrix3x3, true);
    }

    public void setMatrix3x3(Matrix3x3 newMatrix3x3, boolean update) {
        if (this.matrix != null) {
            this.matrix.eAdapters().remove((Object)this.getMatrixAdapter());
        }
        this.matrix = newMatrix3x3;
        if (newMatrix3x3 != null) {
            newMatrix3x3.eAdapters().add((Object)this.getMatrixAdapter());
            this.disableEvent = true;
            this.updateRotations(newMatrix3x3);
            this.disableEvent = false;
        }
    }

    private Vector3d getRotationVector() {
        Vector3d rotation = new Vector3d();
        rotation.setX((double)(this.rxSlider.getSelection() - 180));
        rotation.setY((double)(this.rySlider.getSelection() - 180));
        rotation.setZ((double)(this.rzSlider.getSelection() - 180));
        return rotation;
    }

    private void updateXRotation(double xRotation) {
        if (this.matrix != null) {
            Vector3d rotationVector = this.getRotationVector();
            rotationVector.setX(Math.toDegrees(xRotation));
            Matrix3d matrix3d = GeometricUtils.packXYZ((double)Math.toRadians(rotationVector.getX()), (double)Math.toRadians(rotationVector.getY()), (double)Math.toRadians(rotationVector.getZ()));
            MathEditUtils.updateOrientation((Matrix3x3)this.matrix, (Matrix3x3)ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix3d), (EditingDomain)this.editingDomain);
        }
    }

    private void updateYRotation(double yRotation) {
        if (this.matrix != null) {
            Vector3d rotationVector = this.getRotationVector();
            rotationVector.setY(Math.toDegrees(yRotation));
            Matrix3d matrix3d = GeometricUtils.packXYZ((double)Math.toRadians(rotationVector.getX()), (double)Math.toRadians(rotationVector.getY()), (double)Math.toRadians(rotationVector.getZ()));
            MathEditUtils.updateOrientation((Matrix3x3)this.matrix, (Matrix3x3)ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix3d), (EditingDomain)this.editingDomain);
        }
    }

    private void updateZRotation(double zRotation) {
        if (this.matrix != null) {
            Vector3d rotationVector = this.getRotationVector();
            rotationVector.setZ(Math.toDegrees(zRotation));
            Matrix3d matrix3d = GeometricUtils.packXYZ((double)Math.toRadians(rotationVector.getX()), (double)Math.toRadians(rotationVector.getY()), (double)Math.toRadians(rotationVector.getZ()));
            MathEditUtils.updateOrientation((Matrix3x3)this.matrix, (Matrix3x3)ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix3d), (EditingDomain)this.editingDomain);
        }
    }

    protected Slider createSlider(Composite parent, int style, RotationAxis rotationAxis) {
        final Slider slider = new Slider(parent, style);
        slider.setMinimum(0);
        slider.setPageIncrement(1);
        slider.setMaximum(360);
        slider.setSelection(180);
        if (rotationAxis == RotationAxis.X) {
            slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RotationMatrixSlidersComposite.this.disableEvent = true;
                    double newValue = Math.toRadians(slider.getSelection() - 180);
                    RotationMatrixSlidersComposite.this.updateXRotation(newValue);
                    RotationMatrixSlidersComposite.this.disableEvent = false;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if (rotationAxis == RotationAxis.Y) {
            slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RotationMatrixSlidersComposite.this.disableEvent = true;
                    double newValue = Math.toRadians(slider.getSelection() - 180);
                    RotationMatrixSlidersComposite.this.updateYRotation(newValue);
                    RotationMatrixSlidersComposite.this.disableEvent = false;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            slider.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RotationMatrixSlidersComposite.this.disableEvent = true;
                    double newValue = Math.toRadians(slider.getSelection() - 180);
                    RotationMatrixSlidersComposite.this.updateZRotation(newValue);
                    RotationMatrixSlidersComposite.this.disableEvent = false;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        return slider;
    }

    private void updateRotations(Matrix3x3 matrix) {
        if (!(matrix == null || this.rxSlider == null || this.rxSlider.isDisposed() || this.rySlider == null || this.rySlider.isDisposed() || this.rzSlider == null || this.rzSlider.isDisposed())) {
            Vector3d rotationVector = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)matrix.asMatrix3d());
            int xRot = (int)Math.floor(Math.toDegrees(GeometricUtils.normalizeAngle((double)rotationVector.getX()))) + 180;
            int yRot = (int)Math.floor(Math.toDegrees(GeometricUtils.normalizeAngle((double)rotationVector.getY()))) + 180;
            int zRot = (int)Math.floor(Math.toDegrees(GeometricUtils.normalizeAngle((double)rotationVector.getZ()))) + 180;
            this.rxSlider.setSelection(xRot);
            this.rySlider.setSelection(yRot);
            this.rzSlider.setSelection(zRot);
        }
    }

    private Adapter getMatrixAdapter() {
        if (this.matrixAdapter == null) {
            this.matrixAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!RotationMatrixSlidersComposite.this.disableEvent) {
                        RotationMatrixSlidersComposite.this.updateRotations((Matrix3x3)msg.getNotifier());
                    }
                }
            };
        }
        return this.matrixAdapter;
    }

    static enum RotationAxis {
        X,
        Y,
        Z;

    }
}

