/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import org.eclipse.apogy.addons.impl.GeometryPlacementAtFeatureOfInterestToolImpl;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.FeatureOfInterestNode;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeometryPlacementAtFeatureOfInterestToolCustomImpl
extends GeometryPlacementAtFeatureOfInterestToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(GeometryPlacementAtFeatureOfInterestToolImpl.class);
    private TransformNode transformNode;
    private Node geometryNode;

    @Override
    public void setFeatureOfInterest(FeatureOfInterest newFeatureOfInterest) {
        super.setFeatureOfInterest(newFeatureOfInterest);
        this.update();
    }

    @Override
    public abstract Node loadGeometry();

    @Override
    public void initialise() {
        super.initialise();
        this.update();
    }

    @Override
    public void setActive(boolean value) {
        super.setActive(value);
        this.update();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.update();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.getTransformNode().setNodeId(name);
    }

    @Override
    public void dispose() {
        if (this.transformNode != null && this.transformNode.getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.transformNode.getParent();
            parent.getChildren().remove((Object)this.transformNode);
        }
        super.dispose();
    }

    @Override
    public TransformNode basicGetTransformNode() {
        if (this.transformNode == null) {
            this.transformNode = ApogyCommonTopologyFactory.eINSTANCE.createTransformNode();
            this.transformNode.setNodeId(this.getName());
            this.transformNode.setDescription("Tranform used to orient the geometry.");
            this.transformNode.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4().asMatrix4d());
            try {
                this.transformNode.getChildren().add((Object)this.getGeometryNode());
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return this.transformNode;
    }

    protected Node getGeometryNode() {
        if (this.geometryNode == null) {
            this.geometryNode = this.loadGeometry();
        }
        return this.geometryNode;
    }

    protected void update() {
        if (this.getFeatureOfInterestNode() != null) {
            this.getFeatureOfInterestNode().getChildren().remove((Object)this.getTransformNode());
        }
        if (this.getFeatureOfInterest() != null) {
            FeatureOfInterestNode newFeatureOfInterestNode = ApogyCoreTopologyFacade.INSTANCE.getFeatureOfInterestNode(this.getFeatureOfInterest());
            this.setFeatureOfInterestNode(newFeatureOfInterestNode);
            if (newFeatureOfInterestNode != null) {
                newFeatureOfInterestNode.getChildren().add((Object)this.getTransformNode());
            }
        }
    }
}

