/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.data3d.impl;

import geometry_msgs.Point;
import geometry_msgs.Pose;
import geometry_msgs.Quaternion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.ros.data3d.impl.ApogyAddonsROSData3dFacadeImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianOrientationCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.ros.message.MessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sensor_msgs.PointCloud2;
import sensor_msgs.PointField;
import shape_msgs.Mesh;
import shape_msgs.MeshTriangle;

public class ApogyAddonsROSData3dFacadeCustomImpl
extends ApogyAddonsROSData3dFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyAddonsROSData3dFacadeImpl.class);

    @Override
    public CartesianPositionCoordinates convertToCartesianPositionCoordinates(Point rosPoint) {
        return ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(rosPoint.getX(), rosPoint.getY(), rosPoint.getZ());
    }

    @Override
    public Point convertToROSPoint(CartesianPositionCoordinates point, MessageFactory messageFactory) {
        Point p = (Point)messageFactory.newFromType("geometry_msgs/Point");
        p.setX(point.getX());
        p.setY(point.getY());
        p.setZ(point.getZ());
        return p;
    }

    @Override
    public Quaternion convertToROSQuaternion(CartesianOrientationCoordinates orientation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CartesianOrientationCoordinates convertToCartesianOrientationCoordinates(Quaternion rosQuaternion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.eclipse.apogy.common.geometry.data3d.Pose convertToPose(Pose rosPose) {
        org.eclipse.apogy.common.geometry.data3d.Pose pose = ApogyCommonGeometryData3DFactory.eINSTANCE.createPose();
        pose.setX(rosPose.getPosition().getX());
        pose.setY(rosPose.getPosition().getY());
        pose.setZ(rosPose.getPosition().getZ());
        CartesianOrientationCoordinates rot = this.convertToCartesianOrientationCoordinates(rosPose.getOrientation());
        pose.setXRotation(rot.getXRotation());
        pose.setYRotation(rot.getYRotation());
        pose.setZRotation(rot.getZRotation());
        return pose;
    }

    @Override
    public Pose convertToROSPose(org.eclipse.apogy.common.geometry.data3d.Pose pose, MessageFactory messageFactory) {
        Point position = this.convertToROSPoint((CartesianPositionCoordinates)pose, messageFactory);
        Quaternion orientation = this.convertToROSQuaternion((CartesianOrientationCoordinates)pose);
        Pose rosPose = (Pose)messageFactory.newFromType("geometry_msgs/Pose");
        rosPose.setPosition(position);
        rosPose.setOrientation(orientation);
        return rosPose;
    }

    @Override
    public Pose convertToROSPose(Matrix4d matrix, MessageFactory messageFactory) {
        Vector3d position = new Vector3d();
        matrix.get(position);
        Point point = (Point)messageFactory.newFromType("geometry_msgs/Point");
        point.setX(position.getX());
        point.setY(position.getY());
        point.setZ(position.getZ());
        Quat4d quat = new Quat4d();
        quat.set(matrix);
        Quaternion quaternion = (Quaternion)messageFactory.newFromType("geometry_msgs/Quaternion");
        quaternion.setX(quat.x);
        quaternion.setY(quat.y);
        quaternion.setZ(quat.z);
        quaternion.setW(quat.w);
        Pose rosPose = (Pose)messageFactory.newFromType("geometry_msgs/Pose");
        rosPose.setPosition(point);
        rosPose.setOrientation(quaternion);
        return rosPose;
    }

    @Override
    public CartesianCoordinatesSet convertToCartesianCoordinatesSet(PointCloud2 pointCloud2) {
        if (pointCloud2.getFields().size() < 3) {
            return null;
        }
        Logger.debug("PointCloud2 Details");
        Logger.info("\t isBigEndian   : " + pointCloud2.getIsBigendian());
        Logger.debug("\t Points Step   : " + pointCloud2.getPointStep());
        Logger.debug("\t Row Step      : " + pointCloud2.getRowStep());
        Logger.debug("\t Height        : " + pointCloud2.getHeight());
        Logger.debug("\t Width         : " + pointCloud2.getWidth());
        Logger.debug("\t Data Capacity : " + pointCloud2.getData().capacity());
        Logger.debug("\t Data Array    : " + pointCloud2.getData().array().length);
        Logger.debug("\t Is Dense      : " + pointCloud2.getIsDense());
        List pointFields = pointCloud2.getFields();
        Logger.debug("\t Fields Size   : " + pointFields.size());
        for (PointField field : pointFields) {
            Logger.debug("\t\t Field Name     : " + field.getName());
            Logger.debug("\t\t Field Count    : " + field.getCount());
            Logger.debug("\t\t Field Datatype : " + field.getDatatype());
            Logger.debug("\t\t Field Offset   : " + field.getOffset());
            Logger.debug("");
        }
        CartesianCoordinatesSet cartesianCoordinatesSet = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        int count = pointCloud2.getData().capacity() / pointCloud2.getPointStep();
        int trailingBytes = pointCloud2.getPointStep() - 12;
        Logger.debug("\t Count         : " + count);
        Logger.debug("\t trailingBytes : " + trailingBytes);
        ByteBuffer bb = ByteBuffer.wrap(pointCloud2.getData().array());
        bb.order(pointCloud2.getData().order());
        bb.position(pointCloud2.getData().arrayOffset());
        byte[] byteBucket = new byte[trailingBytes * 2];
        int i = 0;
        while (i < count) {
            try {
                double x = bb.getFloat();
                double y = bb.getFloat();
                double z = bb.getFloat();
                bb.get(byteBucket, 0, trailingBytes);
                CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                points.add(coord);
            }
            catch (Exception exception) {}
            ++i;
        }
        cartesianCoordinatesSet.getPoints().addAll(points);
        return cartesianCoordinatesSet;
    }

    public CartesianCoordinatesSet convertToCartesianCoordinatesSetNew(PointCloud2 pointCloud2) {
        if (pointCloud2.getFields().size() < 3) {
            return null;
        }
        Logger.debug("PointCloud2 Details");
        Logger.debug("\t isBigEndian   : " + pointCloud2.getIsBigendian());
        Logger.debug("\t Points Step   : " + pointCloud2.getPointStep());
        Logger.debug("\t Row Step      : " + pointCloud2.getRowStep());
        Logger.debug("\t Height        : " + pointCloud2.getHeight());
        Logger.debug("\t Width         : " + pointCloud2.getWidth());
        Logger.debug("\t Data Capacity : " + pointCloud2.getData().capacity());
        Logger.debug("\t Data Array    : " + pointCloud2.getData().array().length);
        Logger.debug("\t Is Dense      : " + pointCloud2.getIsDense());
        List pointFields = pointCloud2.getFields();
        Logger.debug("\t Fields Size   : " + pointFields.size());
        for (PointField field : pointFields) {
            Logger.debug("\t\t Field Name     : " + field.getName());
            Logger.debug("\t\t Field Count    : " + field.getCount());
            Logger.debug("\t\t Field Datatype : " + field.getDatatype());
            Logger.debug("\t\t Field Offset   : " + field.getOffset());
            Logger.debug("");
        }
        CartesianCoordinatesSet cartesianCoordinatesSet = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        int count = pointCloud2.getData().capacity() / pointCloud2.getPointStep();
        int pointStep = pointCloud2.getPointStep();
        int xIndex = -1;
        int yIndex = -1;
        int zIndex = -1;
        pointFields = pointCloud2.getFields();
        for (PointField field : pointFields) {
            Logger.info("\t\t Field Name     : " + field.getName());
            if (field.getName() == null || field.getName().length() <= 0) continue;
            if (field.getName().trim().compareToIgnoreCase("x") == 0 && xIndex == -1) {
                xIndex = field.getOffset();
            }
            if (field.getName().trim().compareToIgnoreCase("y") == 0 && yIndex == -1) {
                yIndex = field.getOffset();
            }
            if (field.getName().trim().compareToIgnoreCase("z") != 0 || zIndex != -1) continue;
            zIndex = field.getOffset();
        }
        ByteBuffer bb = ByteBuffer.wrap(pointCloud2.getData().array());
        bb.order(pointCloud2.getData().order());
        bb.position(pointCloud2.getData().arrayOffset());
        byte[] pointRawData = new byte[pointCloud2.getPointStep()];
        int i = 0;
        while (i < count) {
            try {
                bb.get(pointRawData, 0, pointStep);
                ByteBuffer pointBuffer = ByteBuffer.wrap(pointRawData);
                pointBuffer.order(pointCloud2.getData().order());
                pointBuffer.position(0);
                double x = pointBuffer.getFloat(xIndex);
                double y = pointBuffer.getFloat(yIndex);
                double z = pointBuffer.getFloat(zIndex);
                CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                points.add(coord);
            }
            catch (Exception exception) {}
            ++i;
        }
        cartesianCoordinatesSet.getPoints().addAll(points);
        return cartesianCoordinatesSet;
    }

    @Override
    public ColoredCartesianCoordinatesSet rosPointCloudToCartesianCoordinateSet(PointCloud2 pointCloud2) {
        ColoredCartesianCoordinatesSet coordinates = ApogyCommonGeometryData3DFactory.eINSTANCE.createColoredCartesianCoordinatesSet();
        ArrayList<ColoredCartesianPositionCoordinates> points = new ArrayList<ColoredCartesianPositionCoordinates>();
        int count = pointCloud2.getData().capacity() / pointCloud2.getPointStep();
        ByteBuffer bb = ByteBuffer.wrap(pointCloud2.getData().array());
        bb.order(pointCloud2.getData().order());
        bb.position(pointCloud2.getData().arrayOffset());
        boolean color = pointCloud2.getFields().size() > 3;
        int i = 0;
        while (i < count) {
            ColoredCartesianPositionCoordinates coord;
            if (color) {
                coord = this.readRGBCartesianPositionCoordinates(bb);
            } else {
                CartesianPositionCoordinates tmp = this.readCartesianPositionCoordinates(bb);
                coord = ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates(tmp.getX(), tmp.getY(), tmp.getZ(), (short)255, (short)255, (short)255);
            }
            points.add(coord);
            ++i;
        }
        coordinates.getPoints().addAll(points);
        return coordinates;
    }

    @Override
    public ColoredCartesianPositionCoordinates readRGBCartesianPositionCoordinates(ByteBuffer byteBuffer) {
        float x = byteBuffer.getFloat();
        float y = byteBuffer.getFloat();
        float z = byteBuffer.getFloat();
        byteBuffer.getFloat();
        long rgb = byteBuffer.getLong();
        short red = (short)(rgb >> 16 & 0xFFL);
        short green = (short)(rgb >> 8 & 0xFFL);
        short blue = (short)(rgb >> 0 & 0xFFL);
        byteBuffer.getLong();
        return ApogyCommonGeometryData3DFacade.INSTANCE.createColoredCartesianPositionCoordinates((double)x, (double)y, (double)z, red, green, blue);
    }

    @Override
    public CartesianPositionCoordinates readCartesianPositionCoordinates(ByteBuffer byteBuffer) {
        CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates((double)byteBuffer.getFloat(), (double)byteBuffer.getFloat(), (double)byteBuffer.getFloat());
        byteBuffer.getFloat();
        return coord;
    }

    @Override
    public PointCloud2 cartesianCoordinateSetToRosPointCloud(CartesianCoordinatesSet map, MessageFactory messageFactory) {
        PointCloud2 pc = (PointCloud2)messageFactory.newFromType("sensor_msgs/PointCloud2");
        PointField pfx = (PointField)messageFactory.newFromType("sensor_msgs/PointField");
        pfx.setName("x");
        pfx.setDatatype((byte)7);
        pfx.setCount(1);
        PointField pfy = (PointField)messageFactory.newFromType("sensor_msgs/PointField");
        pfy.setName("y");
        pfy.setDatatype((byte)7);
        pfy.setOffset(4);
        pfy.setCount(1);
        PointField pfz = (PointField)messageFactory.newFromType("sensor_msgs/PointField");
        pfz.setName("z");
        pfz.setDatatype((byte)7);
        pfz.setOffset(8);
        pfz.setCount(1);
        pc.getFields().add(pfx);
        pc.getFields().add(pfy);
        pc.getFields().add(pfz);
        pc.setHeight(1);
        pc.setWidth(map.getPoints().size());
        pc.setIsBigendian(false);
        pc.setIsDense(true);
        pc.setPointStep(16);
        pc.setRowStep(map.getPoints().size() * 16);
        ChannelBuffer data = ChannelBuffers.buffer((ByteOrder)ByteOrder.LITTLE_ENDIAN, (int)(map.getPoints().size() * 16));
        for (CartesianPositionCoordinates pt : map.getPoints()) {
            data.writeFloat((float)pt.getX());
            data.writeFloat((float)pt.getY());
            data.writeFloat((float)pt.getZ());
            data.writeFloat(1.0f);
        }
        pc.setData(data);
        return pc;
    }

    @Override
    public Mesh cartesianTriangularMeshtoRosMesh(CartesianTriangularMesh cartesianTriangularMesh, MessageFactory messageFactory) {
        Logger.debug("Converting mesh contains {} points and {} triangles.", (Object)cartesianTriangularMesh.getPoints().size(), (Object)cartesianTriangularMesh.getPolygons().size());
        Mesh mesh = (Mesh)messageFactory.newFromType("shape_msgs/Mesh");
        HashMap<CartesianPositionCoordinates, Integer> poinToIndexMap = new HashMap<CartesianPositionCoordinates, Integer>();
        int i = 0;
        while (i < cartesianTriangularMesh.getPoints().size()) {
            CartesianPositionCoordinates p = (CartesianPositionCoordinates)cartesianTriangularMesh.getPoints().get(i);
            poinToIndexMap.put(p, i);
            Point vertex = this.convertToROSPoint(p, messageFactory);
            mesh.getVertices().add(vertex);
            ++i;
        }
        for (CartesianTriangle t : cartesianTriangularMesh.getPolygons()) {
            int p0 = (Integer)poinToIndexMap.get(t.getVertices().get(0));
            int p1 = (Integer)poinToIndexMap.get(t.getVertices().get(1));
            int p2 = (Integer)poinToIndexMap.get(t.getVertices().get(2));
            MeshTriangle triangle = (MeshTriangle)messageFactory.newFromType("shape_msgs/MeshTriangle");
            int[] verticesIndex = new int[]{p0, p1, p2};
            triangle.setVertexIndices(verticesIndex);
            mesh.getTriangles().add(triangle);
        }
        Logger.debug("Converted ROS Mesh contains {} points and {} triangles.", (Object)mesh.getVertices().size(), (Object)mesh.getTriangles().size());
        return mesh;
    }
}

