/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.SystemElementProvider;
import org.eclipse.apogy.addons.powersystems.ui.composites.PowerSwitchesListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class LoadSheddingSwitchesWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.powersystems.ui.wizards.LoadSheddingSwitchesWizardPage";
    protected SystemElementProvider systemElementProvider;
    protected PowerSwitchesListComposite<SystemElementProvider, SystemElementProvider> currentLoadSheddingPowerSwitches;
    protected PowerSwitchesListComposite<SystemElementProvider, SystemElementProvider> availableLoadSheddingPowerSwitches;
    private Button addPowerSwitchToLoadSheddingButton;
    private Button removePowerSwitchFromLoadSheddingButton;

    public LoadSheddingSwitchesWizardPage(SystemElementProvider systemElementProvider) {
        super(WIZARD_PAGE_ID);
        this.setTitle("Select load shedding switches for the power bus.");
        this.setPageComplete(true);
        this.systemElementProvider = systemElementProvider;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        ECollectionCompositeSettings settingAvailable = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settingAvailable.setCollectionSectionTitle("Available Power Switches");
        settingAvailable.setCollectionSectionDisplayed(true);
        settingAvailable.setButtonsSectionDisplayed(false);
        settingAvailable.setDetailSectionDisplayed(false);
        this.availableLoadSheddingPowerSwitches = new PowerSwitchesListComposite<SystemElementProvider, SystemElementProvider>(composite, 0, null, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SYSTEM_ELEMENT_PROVIDER__PROVIDED_ELEMENTS, settingAvailable){

            @Override
            protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
                ArrayList<SystemElement> result = new ArrayList<SystemElement>();
                PowerBus powerBus = LoadSheddingSwitchesWizardPage.this.getPowerBus((SystemElementProvider)this.getResolvedEObject());
                if (powerBus != null) {
                    for (SystemElement systemElement : inputs) {
                        if (!(systemElement instanceof PowerSwitch) || powerBus.getLoadSheddingSwitches().contains((Object)systemElement)) continue;
                        result.add(systemElement);
                    }
                }
                return result;
            }
        };
        this.availableLoadSheddingPowerSwitches.setLayoutData(new GridData(4, 4, true, true));
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        buttonsComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.addPowerSwitchToLoadSheddingButton = new Button(buttonsComposite, 8);
        this.addPowerSwitchToLoadSheddingButton.setText("-->");
        this.addPowerSwitchToLoadSheddingButton.setToolTipText("Adds selected PowerSwitch to the load shedding the list.");
        this.addPowerSwitchToLoadSheddingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LoadSheddingSwitchesWizardPage.this.addRecipients(LoadSheddingSwitchesWizardPage.this.availableLoadSheddingPowerSwitches.getCurrentSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.removePowerSwitchFromLoadSheddingButton = new Button(buttonsComposite, 8);
        this.removePowerSwitchFromLoadSheddingButton.setText("<--");
        this.removePowerSwitchFromLoadSheddingButton.setToolTipText("Removes selected PowerSwitch from the load shedding the list.");
        this.removePowerSwitchFromLoadSheddingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LoadSheddingSwitchesWizardPage.this.removeRecipients(LoadSheddingSwitchesWizardPage.this.currentLoadSheddingPowerSwitches.getCurrentSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        ECollectionCompositeSettings settingsCurrent = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settingsCurrent.setCollectionSectionTitle("Current Load Shedding Switches");
        settingsCurrent.setButtonsSectionDisplayed(false);
        settingsCurrent.setDetailSectionDisplayed(false);
        this.currentLoadSheddingPowerSwitches = new PowerSwitchesListComposite<SystemElementProvider, SystemElementProvider>(composite, 0, null, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SYSTEM_ELEMENT_PROVIDER__PROVIDED_ELEMENTS, settingsCurrent){

            @Override
            protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
                ArrayList<SystemElement> result = new ArrayList<SystemElement>();
                PowerBus powerBus = LoadSheddingSwitchesWizardPage.this.getPowerBus((SystemElementProvider)this.getResolvedEObject());
                if (powerBus != null) {
                    result.addAll((Collection<SystemElement>)powerBus.getLoadSheddingSwitches());
                }
                return result;
            }
        };
        this.currentLoadSheddingPowerSwitches.setLayoutData(new GridData(4, 4, true, true));
        this.availableLoadSheddingPowerSwitches.setRootEObject(this.systemElementProvider);
        this.currentLoadSheddingPowerSwitches.setRootEObject(this.systemElementProvider);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LoadSheddingSwitchesWizardPage.this.availableLoadSheddingPowerSwitches.refresh();
                LoadSheddingSwitchesWizardPage.this.currentLoadSheddingPowerSwitches.refresh();
            }
        });
        this.setControl((Control)composite);
    }

    protected PowerBus getPowerBus(SystemElementProvider systemElementProvider) {
        PowerBus powerBus = null;
        if (systemElementProvider != null) {
            EList elements = systemElementProvider.getProvidedElements();
            Iterator it = elements.iterator();
            while (it.hasNext() && powerBus == null) {
                SystemElement element = (SystemElement)it.next();
                if (!(element instanceof PowerBus)) continue;
                powerBus = (PowerBus)element;
            }
        }
        return powerBus;
    }

    protected void addRecipients(IStructuredSelection selection) {
        Iterator it = selection.iterator();
        PowerBus powerBus = this.getPowerBus(this.systemElementProvider);
        if (powerBus != null) {
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof PowerSwitch)) continue;
                PowerSwitch powerSwitch = (PowerSwitch)obj;
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)powerBus, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__LOAD_SHEDDING_SWITCHES, (Object)powerSwitch, true);
            }
        }
        this.availableLoadSheddingPowerSwitches.refresh();
        this.currentLoadSheddingPowerSwitches.refresh();
    }

    protected void removeRecipients(IStructuredSelection selection) {
        Iterator it = selection.iterator();
        PowerBus powerBus = this.getPowerBus(this.systemElementProvider);
        if (powerBus != null) {
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof PowerSwitch)) continue;
                PowerSwitch powerSwitch = (PowerSwitch)obj;
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)powerBus, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__LOAD_SHEDDING_SWITCHES, (Object)powerSwitch, true);
            }
        }
        this.availableLoadSheddingPowerSwitches.refresh();
        this.currentLoadSheddingPowerSwitches.refresh();
    }
}

