/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerSource;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PowerSourcesListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, PowerSource> {
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static final int POWER_AVAILABLE_MIN_WIDTH = 150;
    protected static final int POWER_PROVIDED_MIN_WIDTH = 150;

    public PowerSourcesListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        powerInputColumn.getColumn().setText("Power Provided (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSource) {
                    PowerSource powerSource = (PowerSource)element;
                    return decimalFormat.format(powerSource.getPowerProvided());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_PROVIDED);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSource) {
                    return PowerSourcesListComposite.this.getBackgroundColor((PowerSource)element);
                }
                return null;
            }
        });
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)150);
        stateColumn.getColumn().setText("Power Available (W)");
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSource) {
                    PowerSource powerSource = (PowerSource)element;
                    return decimalFormat.format(powerSource.getPowerAvailable());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_AVAILABLE);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSource) {
                    return PowerSourcesListComposite.this.getBackgroundColor((PowerSource)element);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof PowerSource)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(PowerSource powerSource) {
        Color color = null;
        color = !powerSource.isPowerStateValid() ? INVALID_COLOR : (powerSource.getPowerAvailable() == 0.0 ? Display.getCurrent().getSystemColor(15) : (powerSource.getPowerProvided() == 0.0 ? Display.getCurrent().getSystemColor(9) : Display.getCurrent().getSystemColor(5)));
        return color;
    }
}

