/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.SimpleLoad;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PowerLoadListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, SimpleLoad> {
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static final int STATE_COL_MIN_WIDTH = 50;
    protected static final int REQUIRED_POWER_MIN_WIDTH = 170;
    protected static final int CONSUMED_POWER_MIN_WIDTH = 170;

    public PowerLoadListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn powerOutputColumn = new TreeViewerColumn(viewer, 0);
        powerOutputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        powerOutputColumn.getColumn().setText("Power Consumed (W)");
        powerOutputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SimpleLoad) {
                    SimpleLoad load = (SimpleLoad)element;
                    return decimalFormat.format(load.getPowerConsumed());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONSUMER__POWER_CONSUMED);
            }

            public Color getBackground(Object element) {
                if (element instanceof SimpleLoad) {
                    return PowerLoadListComposite.this.getBackgroundColor((SimpleLoad)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        powerInputColumn.getColumn().setText("Required Power (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SimpleLoad) {
                    SimpleLoad load = (SimpleLoad)element;
                    return decimalFormat.format(load.getRequiredPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONSUMER__REQUIRED_POWER);
            }

            public Color getBackground(Object element) {
                if (element instanceof SimpleLoad) {
                    return PowerLoadListComposite.this.getBackgroundColor((SimpleLoad)element);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof SimpleLoad)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(SimpleLoad simpleLoad) {
        Color color = null;
        color = !simpleLoad.isPowerStateValid() ? INVALID_COLOR : (simpleLoad.getPowerConsumed() != 0.0 ? Display.getCurrent().getSystemColor(5) : Display.getCurrent().getSystemColor(15));
        return color;
    }
}

