/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerConverter;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PowerConverterListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, PowerConverter> {
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static DecimalFormat percentDecimalFormat = new DecimalFormat("0.0");
    protected static final int STATE_COL_MIN_WIDTH = 50;
    protected static final int POWER_INPUT_MIN_WIDTH = 100;
    protected static final int POWER_OUTPUT_MIN_WIDTH = 100;
    protected static final int EFFICIENCY_MIN_WIDTH = 100;
    protected static final int MAX_POWER_OUTPUT_MIN_WIDTH = 120;
    protected static final int AUTO_RESTART_MIN_WIDTH = 100;

    public PowerConverterListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)50);
        stateColumn.getColumn().setText("State");
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    return ((PowerConverter)element).getConverterState().getLiteral();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER_STATE);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerOutputColumn = new TreeViewerColumn(viewer, 0);
        powerOutputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        powerOutputColumn.getColumn().setText("Output (W)");
        powerOutputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    PowerConverter powerConverter = (PowerConverter)element;
                    return decimalFormat.format(powerConverter.getOutputPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.IN_LINE_SYSTEM_ELEMENT__OUTPUT_POWER);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        powerInputColumn.getColumn().setText("Input (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    PowerConverter powerConverter = (PowerConverter)element;
                    return decimalFormat.format(powerConverter.getInputPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.IN_LINE_SYSTEM_ELEMENT__INPUT_POWER);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
        TreeViewerColumn efficiencyColumn = new TreeViewerColumn(viewer, 0);
        efficiencyColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        efficiencyColumn.getColumn().setText("Efficiency (%)");
        efficiencyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    PowerConverter powerConverter = (PowerConverter)element;
                    return percentDecimalFormat.format(powerConverter.getEfficiency());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER__EFFICIENCY);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
        TreeViewerColumn maxPowerColumn = new TreeViewerColumn(viewer, 0);
        maxPowerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        maxPowerColumn.getColumn().setText("Max Output (W)");
        maxPowerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    PowerConverter powerConverter = (PowerConverter)element;
                    return decimalFormat.format(powerConverter.getMaxPowerOutput());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER__MAX_POWER_OUTPUT);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
        TreeViewerColumn autoResetColumn = new TreeViewerColumn(viewer, 0);
        autoResetColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        autoResetColumn.getColumn().setText("Auto Restart");
        autoResetColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerConverter) {
                    PowerConverter powerConverter = (PowerConverter)element;
                    if (powerConverter.isAutoRestart()) {
                        return "Yes";
                    }
                    return "No";
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER__AUTO_RESTART);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerConverter) {
                    return PowerConverterListComposite.this.getBackgroundColor((PowerConverter)element);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof PowerConverter)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(PowerConverter powerConverter) {
        Color color = null;
        if (!powerConverter.isPowerStateValid()) {
            color = INVALID_COLOR;
        } else {
            switch (powerConverter.getConverterState().getValue()) {
                case 0: {
                    if (powerConverter.getOutputPower() > 0.0) {
                        color = Display.getCurrent().getSystemColor(5);
                        break;
                    }
                    color = Display.getCurrent().getSystemColor(15);
                    break;
                }
                case 1: {
                    color = Display.getCurrent().getSystemColor(3);
                    break;
                }
            }
        }
        return color;
    }
}

