/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import org.apache.commons.math3.geometry.euclidean.twod.SubLine;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.geometry.partitioning.AbstractSubHyperplane;
import org.apache.commons.math3.geometry.partitioning.BSPTree;
import org.apache.commons.math3.geometry.partitioning.Hyperplane;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.geometry.partitioning.Side;
import org.apache.commons.math3.geometry.partitioning.SubHyperplane;

public class SubPlane
extends AbstractSubHyperplane<Euclidean3D, Euclidean2D> {
    public SubPlane(Hyperplane<Euclidean3D> hyperplane, Region<Euclidean2D> remainingRegion) {
        super(hyperplane, remainingRegion);
    }

    @Override
    protected AbstractSubHyperplane<Euclidean3D, Euclidean2D> buildNew(Hyperplane<Euclidean3D> hyperplane, Region<Euclidean2D> remainingRegion) {
        return new SubPlane(hyperplane, remainingRegion);
    }

    @Override
    public Side side(Hyperplane<Euclidean3D> hyperplane) {
        Plane otherPlane = (Plane)hyperplane;
        Plane thisPlane = (Plane)this.getHyperplane();
        Line inter = otherPlane.intersection(thisPlane);
        if (inter == null) {
            double global = otherPlane.getOffset(thisPlane);
            return global < -1.0E-10 ? Side.MINUS : (global > 1.0E-10 ? Side.PLUS : Side.HYPER);
        }
        Vector p = thisPlane.toSubSpace(inter.toSpace((Vector)Vector1D.ZERO));
        Vector q = thisPlane.toSubSpace(inter.toSpace((Vector)Vector1D.ONE));
        Vector3D crossP = Vector3D.crossProduct(inter.getDirection(), thisPlane.getNormal());
        if (crossP.dotProduct(otherPlane.getNormal()) < 0.0) {
            Vector tmp = p;
            p = q;
            q = tmp;
        }
        org.apache.commons.math3.geometry.euclidean.twod.Line line2D = new org.apache.commons.math3.geometry.euclidean.twod.Line((Vector2D)p, (Vector2D)q);
        return this.getRemainingRegion().side(line2D);
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Euclidean3D> split(Hyperplane<Euclidean3D> hyperplane) {
        Plane otherPlane = (Plane)hyperplane;
        Plane thisPlane = (Plane)this.getHyperplane();
        Line inter = otherPlane.intersection(thisPlane);
        if (inter == null) {
            double global = otherPlane.getOffset(thisPlane);
            return global < -1.0E-10 ? new SubHyperplane.SplitSubHyperplane<Euclidean3D>(null, this) : new SubHyperplane.SplitSubHyperplane<Euclidean3D>(this, null);
        }
        Vector p = thisPlane.toSubSpace(inter.toSpace((Vector)Vector1D.ZERO));
        Vector q = thisPlane.toSubSpace(inter.toSpace((Vector)Vector1D.ONE));
        Vector3D crossP = Vector3D.crossProduct(inter.getDirection(), thisPlane.getNormal());
        if (crossP.dotProduct(otherPlane.getNormal()) < 0.0) {
            Vector tmp = p;
            p = q;
            q = tmp;
        }
        SubLine l2DMinus = new org.apache.commons.math3.geometry.euclidean.twod.Line((Vector2D)p, (Vector2D)q).wholeHyperplane();
        SubLine l2DPlus = new org.apache.commons.math3.geometry.euclidean.twod.Line((Vector2D)q, (Vector2D)p).wholeHyperplane();
        BSPTree<Euclidean2D> splitTree = this.getRemainingRegion().getTree(false).split(l2DMinus);
        BSPTree<Euclidean2D> plusTree = this.getRemainingRegion().isEmpty(splitTree.getPlus()) ? new BSPTree<Euclidean2D>(Boolean.FALSE) : new BSPTree<Euclidean2D>(l2DPlus, new BSPTree(Boolean.FALSE), splitTree.getPlus(), null);
        BSPTree<Euclidean2D> minusTree = this.getRemainingRegion().isEmpty(splitTree.getMinus()) ? new BSPTree<Euclidean2D>(Boolean.FALSE) : new BSPTree<Euclidean2D>(l2DMinus, new BSPTree(Boolean.FALSE), splitTree.getMinus(), null);
        return new SubHyperplane.SplitSubHyperplane<Euclidean3D>(new SubPlane(thisPlane.copySelf(), new PolygonsSet(plusTree)), new SubPlane(thisPlane.copySelf(), new PolygonsSet(minusTree)));
    }
}

