/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.TextureProjector;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.texture.Texture2D;
import java.util.HashMap;

public class SimpleTextureProjector
implements TextureProjector {
    private Camera projectorCamera;
    private Texture2D projectiveTextureMap;
    private GeometryList targetGeometryList;
    private float fallOffDistance;
    private float fallOffPower;
    private HashMap parameters;

    public SimpleTextureProjector(Texture2D projectiveTextureMap) {
        this.projectiveTextureMap = projectiveTextureMap;
        this.projectorCamera = new Camera(projectiveTextureMap.getImage().getWidth(), projectiveTextureMap.getImage().getHeight());
        this.fallOffDistance = Float.MAX_VALUE;
        this.fallOffPower = 3.0f;
        this.parameters = new HashMap();
    }

    public void setProjectiveTextureMap(Texture2D projectiveTextureMap) {
        this.projectiveTextureMap = projectiveTextureMap;
    }

    @Override
    public Vector3f getProjectorLocation() {
        return this.projectorCamera.getLocation();
    }

    @Override
    public Vector3f getProjectorDirection() {
        return this.projectorCamera.getDirection();
    }

    @Override
    public Matrix4f getProjectorViewProjectionMatrix() {
        return this.projectorCamera.getViewProjectionMatrix();
    }

    @Override
    public boolean isParallelProjection() {
        return this.projectorCamera.isParallelProjection();
    }

    @Override
    public Texture2D getProjectiveTexture() {
        return this.projectiveTextureMap;
    }

    @Override
    public GeometryList getTargetGeometryList() {
        return this.targetGeometryList;
    }

    public void setTargetGeometryList(GeometryList targetGeometryList) {
        this.targetGeometryList = targetGeometryList;
    }

    public Camera getProjectorCamera() {
        return this.projectorCamera;
    }

    public void setFallOffDistance(float fallOffDistance) {
        this.fallOffDistance = fallOffDistance;
    }

    @Override
    public float getFallOffDistance() {
        return this.fallOffDistance;
    }

    public void setFallOffPower(float fallOffPower) {
        this.fallOffPower = fallOffPower;
    }

    @Override
    public float getFallOffPower() {
        return this.fallOffPower;
    }

    @Override
    public Object getParameter(Object key) {
        return this.parameters.get(key);
    }

    public void setParameter(Object key, Object value) {
        this.parameters.put(key, value);
    }

    public void updateFrustumPoints(Vector3f[] points) {
        int w = this.projectorCamera.getWidth();
        int h = this.projectorCamera.getHeight();
        float n = 0.0f;
        float f = 1.0f;
        points[0].set(this.projectorCamera.getWorldCoordinates(new Vector2f(0.0f, 0.0f), 0.0f));
        points[1].set(this.projectorCamera.getWorldCoordinates(new Vector2f(0.0f, (float)h), 0.0f));
        points[2].set(this.projectorCamera.getWorldCoordinates(new Vector2f((float)w, (float)h), 0.0f));
        points[3].set(this.projectorCamera.getWorldCoordinates(new Vector2f((float)w, 0.0f), 0.0f));
        points[4].set(this.projectorCamera.getWorldCoordinates(new Vector2f(0.0f, 0.0f), 1.0f));
        points[5].set(this.projectorCamera.getWorldCoordinates(new Vector2f(0.0f, (float)h), 1.0f));
        points[6].set(this.projectorCamera.getWorldCoordinates(new Vector2f((float)w, (float)h), 1.0f));
        points[7].set(this.projectorCamera.getWorldCoordinates(new Vector2f((float)w, 0.0f), 1.0f));
    }
}

