/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.statemachine;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.sequoyah.device.framework.statemachine.StateMachine;
import org.eclipse.sequoyah.device.framework.statemachine.StateMachineModel;
import org.eclipse.sequoyah.device.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachineHandler {
    private IInstance instance;
    private StateMachineModel stmModel;
    private IStatusTransition transition = null;
    private boolean transitioning = false;

    public StateMachineHandler(IInstance iInstance) {
        this.instance = iInstance;
        IDeviceType iDeviceType = DeviceUtils.getDeviceType(iInstance);
        List<IService> list = iDeviceType.getServices();
        HashSet<IStatusTransition> hashSet = new HashSet<IStatusTransition>();
        for (IService object2 : list) {
            hashSet.addAll(object2.getStatusTransitions(iInstance.getDeviceTypeId()));
        }
        StateMachine stateMachine = new StateMachine(hashSet);
        this.stmModel = new StateMachineModel(stateMachine);
    }

    public IStatus runService(ServiceHandler serviceHandler, IInstance iInstance, Map<Object, Object> map, String string, IProgressMonitor iProgressMonitor) throws SequoyahException {
        IStatus iStatus = Status.OK_STATUS;
        this.setTransitioning(true);
        this.transition = serviceHandler.getService().getStatusTransitions(iInstance.getDeviceTypeId(), iInstance.getStatus());
        if (!this.transition.getStartId().equals(this.stmModel.getState())) {
            throw new SequoyahException();
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_ABOUT_TO_TRANSITION, iInstance, serviceHandler.getService().getId()));
        iProgressMonitor.beginTask(string, 1000);
        iStatus = serviceHandler.runService(iInstance, map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 950));
        if (iStatus.isOK()) {
            IServiceHandler iServiceHandler = serviceHandler.getParent();
            if (iServiceHandler != null) {
                if (iServiceHandler instanceof ServiceHandler) {
                    iStatus = ((ServiceHandler)iServiceHandler).updatingService(iInstance, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                } else {
                    iServiceHandler.updatingService(iInstance);
                    iProgressMonitor.worked(50);
                }
            } else {
                iStatus = serviceHandler.updatingService(iInstance, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
            }
        }
        if (iStatus.isOK()) {
            this.stmModel.transitionState(this.transition.getEndId());
        } else if (iStatus.getSeverity() != 8) {
            this.stmModel.transitionState(this.transition.getHaltId());
        }
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_TRANSITIONED, iInstance, serviceHandler.getService().getId()));
        iProgressMonitor.done();
        this.setTransitioning(false);
        return iStatus;
    }

    public synchronized void setState(String string) {
        this.stmModel.setState(string);
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_TRANSITIONED, this.instance));
    }

    public String getState() {
        return this.stmModel.getState();
    }

    public IStatusTransition getCurrentStatusTransition() {
        return this.transition;
    }

    private synchronized void setTransitioning(boolean bl) {
        this.transitioning = bl;
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }
}

