/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.framework.internal.model.DeviceServicesTransitions;
import org.eclipse.sequoyah.device.framework.internal.model.MobileDeviceType;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IParallelService;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileService
implements IParallelService {
    private String id;
    private String name;
    private ImageDescriptor image;
    private String copyright;
    private String description;
    private String provider;
    private String version;
    private IServiceHandler handler;
    private List<DeviceServicesTransitions> devicesTransitions;
    private boolean visible;
    private boolean parallelized;
    private int interval;

    public MobileService(String string) {
        this.id = string;
        this.devicesTransitions = new ArrayList<DeviceServicesTransitions>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ImageDescriptor getImage() {
        return this.image;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public IServiceHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setImage(ImageDescriptor imageDescriptor) {
        this.image = imageDescriptor;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setCopyright(String string) {
        this.copyright = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setProvider(String string) {
        this.provider = string;
    }

    @Override
    public void setVersion(String string) {
        this.version = string;
    }

    @Override
    public void setHandler(IServiceHandler iServiceHandler) {
        this.handler = (IServiceHandler)iServiceHandler.clone();
        this.handler.setService(this);
    }

    @Override
    public Object clone() {
        MobileService mobileService = new MobileService(this.id);
        mobileService.setName(this.name);
        mobileService.setImage(this.image);
        mobileService.setCopyright(this.copyright);
        mobileService.setDescription(this.description);
        mobileService.setProvider(this.provider);
        mobileService.setVersion(this.version);
        mobileService.setHandler(this.handler);
        mobileService.setVisible(this.visible);
        mobileService.setParallelized(this.parallelized);
        mobileService.setInterval(this.interval);
        return mobileService;
    }

    public String toString() {
        return "[Service: id=" + (this.id == null ? "" : this.id) + ",name=" + (this.name == null ? "" : this.name) + ",description=" + (this.description == null ? "" : this.description) + ",version=" + (this.version == null ? "" : this.version) + ",provider=" + (this.provider == null ? "" : this.provider) + ",copyright=" + (this.copyright == null ? "" : this.copyright) + ",handler=" + (this.handler == null ? "" : this.handler.getClass().getName()) + ",parallelized=" + this.parallelized + ",interval=" + this.interval + "]";
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isParallelized() {
        return this.parallelized;
    }

    @Override
    public void setParallelized(boolean bl) {
        this.parallelized = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IService) {
            IService iService = (IService)object;
            bl = iService.getId().equals(this.getId());
        }
        return bl;
    }

    @Override
    public void setInterval(int n) {
        this.interval = n;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    public Collection<IStatusTransition> getStatusTransitions(IDeviceType iDeviceType) {
        Map<String, IStatusTransition> map = this.getTransitionsMap(iDeviceType);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map.values();
    }

    public IStatusTransition getStatusTransitions(IDeviceType iDeviceType, String string) {
        Map<String, IStatusTransition> map = this.getTransitionsMap(iDeviceType);
        return map != null ? map.get(string) : null;
    }

    private Map<String, IStatusTransition> getTransitionsMap(IDeviceType iDeviceType) {
        Map<String, IStatusTransition> map = null;
        DeviceServicesTransitions deviceServicesTransitions = new DeviceServicesTransitions();
        deviceServicesTransitions.setDeviceTypeId(iDeviceType.getId());
        int n = this.devicesTransitions.indexOf(deviceServicesTransitions);
        if (n >= 0) {
            map = this.devicesTransitions.get(n).getTransitions();
        }
        return map;
    }

    @Override
    public Collection<IStatusTransition> getStatusTransitions(String string) {
        MobileDeviceType mobileDeviceType = new MobileDeviceType(string, "");
        return this.getStatusTransitions(mobileDeviceType);
    }

    @Override
    public IStatusTransition getStatusTransitions(String string, String string2) {
        MobileDeviceType mobileDeviceType = new MobileDeviceType(string, "");
        return this.getStatusTransitions(mobileDeviceType, string2);
    }

    @Override
    public List<DeviceServicesTransitions> getDevicesTransitions() {
        return this.devicesTransitions;
    }

    @Override
    public void setDevicesTransitions(List<DeviceServicesTransitions> list) {
        this.devicesTransitions = list;
    }

    public void addDeviceTransitions(DeviceServicesTransitions deviceServicesTransitions) {
        if (this.devicesTransitions == null) {
            this.devicesTransitions = new ArrayList<DeviceServicesTransitions>();
        }
        this.devicesTransitions.add(deviceServicesTransitions);
    }
}

