/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.manager.persistence.DeviceXmlReader;
import org.eclipse.sequoyah.device.framework.manager.persistence.DeviceXmlWriter;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IInstanceRegistry;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceRegistry
implements IInstanceRegistry {
    private Map<String, IInstance> instances = new HashMap<String, IInstance>();
    private static InstanceRegistry _instance;

    private InstanceRegistry() {
        this.reload();
        IWorkbench iWorkbench = DevicePlugin.getDefault().getWorkbench();
        iWorkbench.addWindowListener((IWindowListener)new WindowListener());
        InstanceAdapter instanceAdapter = new InstanceAdapter(){

            public void instanceUpdated(InstanceEvent instanceEvent) {
                DeviceXmlWriter.saveInstances();
            }
        };
        InstanceEventManager.getInstance().addInstanceListener(instanceAdapter);
    }

    public void reload() {
        this.clear();
        File file = DevicePlugin.getDeviceXmlLocation();
        File file2 = new File(file, DevicePlugin.getDeviceXmlFileName());
        Collection<IInstance> collection = DeviceXmlReader.loadInstances(file2);
        for (IInstance iInstance : collection) {
            this.addInstance(iInstance);
        }
    }

    public static InstanceRegistry getInstance() {
        if (_instance == null) {
            _instance = new InstanceRegistry();
        }
        return _instance;
    }

    @Override
    public ImageDescriptor getImage() {
        return DevicePlugin.getDefault().getImageDescriptor("ICON_DEVICE");
    }

    @Override
    public List<IInstance> getInstances() {
        return new ArrayList<IInstance>(this.instances.values());
    }

    @Override
    public void setInstances(List<IInstance> list) {
        this.instances.clear();
        for (IInstance iInstance : list) {
            this.addInstance(iInstance);
        }
    }

    @Override
    public void addInstance(IInstance iInstance) {
        this.instances.put(iInstance.getId(), iInstance);
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_LOADED, iInstance));
    }

    @Override
    public void removeInstance(IInstance iInstance) {
        this.instances.remove(iInstance.getId());
        InstanceEventManager.getInstance().notifyListeners(new InstanceEvent(InstanceEvent.InstanceEventType.INSTANCE_UNLOADED, iInstance));
    }

    @Override
    public void clear() {
        this.instances.clear();
    }

    public List<IInstance> getInstancesByName(String string) {
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        List<IInstance> list = instanceRegistry.getInstances();
        ArrayList<IInstance> arrayList = new ArrayList<IInstance>();
        for (IInstance iInstance : list) {
            if (!iInstance.getName().equals(string)) continue;
            arrayList.add(iInstance);
        }
        return arrayList;
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
            DeviceXmlWriter.saveInstances();
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
        }
    }
}

