/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.Figure3D;
import org.eclipse.draw3d.Figure3DFriend;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.PickingUpdateManager3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.camera.CameraLodHelper;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IParaxialBoundingBox;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.RenderImage;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.shapes.ParaxialBoundsFigureShape;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Figure3DHelper {
    private static final Logger log = Logger.getLogger(Figure3DHelper.class.getName());
    protected List<IFigure3D> m_decendants3DCache = new LinkedList<IFigure3D>();
    protected final Figure3DFriend m_figuresFriend;
    private ImageRenderFragment m_fragment;
    private RenderImage m_image;
    private boolean m_decendants3DCacheValid;

    public static IBoundingBox convertBoundsToBounds3D(IFigure i_reference, Rectangle i_rect) {
        return Figure3DHelper.convertBoundsToBounds3D(i_reference, i_rect, 0.0f);
    }

    public static IBoundingBox convertBoundsToBounds3D(IFigure i_reference, Rectangle i_rect, float i_z) {
        BoundingBoxImpl boundingBoxImpl;
        Vector3f origin = Draw3DCache.getVector3f();
        try {
            IFigure3D host = Figure3DHelper.getAncestor3D(i_reference);
            ISurface surface = host.getSurface();
            surface.getWorldLocation(i_rect.getTopLeft(), origin);
            BoundingBoxImpl bounds3D = new BoundingBoxImpl();
            bounds3D.setLocation(origin.getX(), origin.getY(), origin.getZ());
            bounds3D.setSize((float)i_rect.width, (float)i_rect.height, i_z);
            boundingBoxImpl = bounds3D;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin});
        return boundingBoxImpl;
    }

    public static IFigure3D getAncestor3D(IFigure i_figure) {
        IFigure current = i_figure;
        while (current != null && !(current instanceof IFigure3D)) {
            if (current instanceof Connection) {
                Connection conn = (Connection)current;
                return Figure3DHelper.getAncestor3D(conn.getSourceAnchor().getOwner());
            }
            current = current.getParent();
        }
        return (IFigure3D)current;
    }

    public static IVector3f getCenter3D(IFigure i_figure, Vector3f io_result) {
        if (i_figure instanceof IFigure3D) {
            IFigure3D figure3D = (IFigure3D)i_figure;
            return figure3D.getBounds3D().getCenter(io_result);
        }
        if (i_figure instanceof Connection) {
            Connection conn = (Connection)i_figure;
            Point midPoint = conn.getPoints().getMidpoint();
            IFigure3D host = Figure3DHelper.getAncestor3D(i_figure);
            ISurface surface = host.getSurface();
            return surface.getWorldLocation(midPoint, io_result);
        }
        Rectangle rect = i_figure.getBounds();
        Point center = rect.getCenter();
        IFigure3D host = Figure3DHelper.getAncestor3D(i_figure);
        ISurface surface = host.getSurface();
        return surface.getWorldLocation(center, io_result);
    }

    public static final Point getLocation(IFigure i_figure, IVector3f i_location) {
        if (i_figure == null) {
            throw new NullPointerException("figure must not be null");
        }
        if (i_location == null) {
            throw new NullPointerException("location must not be null");
        }
        IFigure3D host = Figure3DHelper.getAncestor3D(i_figure);
        if (host == null) {
            throw new IllegalArgumentException("no 3D host found for " + i_figure);
        }
        ISurface surface = host.getSurface();
        return surface.getSurfaceLocation2D(i_location, null);
    }

    public Figure3DHelper(Figure3DFriend i_figuresFriend) {
        if (i_figuresFriend == null) {
            throw new NullPointerException("i_figuresFriend must not be null");
        }
        this.m_figuresFriend = i_figuresFriend;
    }

    private void configureGraphics(Graphics i_graphics) {
        Font font;
        Color backgroundColor;
        IFigure3D figure = this.m_figuresFriend.figure;
        Color foregroundColor = figure.getLocalForegroundColor();
        if (foregroundColor != null) {
            i_graphics.setForegroundColor(foregroundColor);
        }
        if ((backgroundColor = figure.getLocalBackgroundColor()) != null) {
            i_graphics.setBackgroundColor(backgroundColor);
        }
        if ((font = this.m_figuresFriend.getLocalFont()) != null) {
            i_graphics.setFont(font);
        }
    }

    private void doGetDescendants3D(List<IFigure3D> o_list, IFigure i_fig) {
        for (Object child : i_fig.getChildren()) {
            if (child instanceof IFigure3D) {
                o_list.add((IFigure3D)child);
                continue;
            }
            this.doGetDescendants3D(o_list, (IFigure)child);
        }
    }

    private void doPaintChildren2D(Collection<IFigure> children2D, IFigure3D host, Graphics graphics) {
        graphics.pushState();
        try {
            try {
                for (IFigure child2D : children2D) {
                    graphics.clipRect(child2D.getBounds());
                    child2D.paint(graphics);
                    graphics.restoreState();
                }
                ConnectionLayer connectionLayer = host.getConnectionLayer(null);
                if (connectionLayer != null) {
                    connectionLayer.paint(graphics);
                    graphics.restoreState();
                }
            }
            catch (Error er) {
                log.severe("Error painting 2d children: " + er);
                graphics.popState();
            }
        }
        finally {
            graphics.popState();
        }
    }

    public IFigure findFigureAt(int i_sx, int i_sy, TreeSearch i_search) {
        IFigure3D figure = this.m_figuresFriend.figure;
        ISurface surface = figure.getSurface();
        if (surface != null) {
            return surface.findFigureAt(i_sx, i_sy, i_search);
        }
        if (i_search == null || !i_search.prune((IFigure)figure) && i_search.accept((IFigure)figure)) {
            return figure;
        }
        return null;
    }

    public List<IFigure> getChildren2D() {
        List allChildren = this.m_figuresFriend.figure.getChildren();
        if (allChildren.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IFigure> children2D = new LinkedList<IFigure>();
        for (Object child : allChildren) {
            if (child instanceof Figure3D) continue;
            children2D.add((IFigure)child);
        }
        return Collections.unmodifiableList(children2D);
    }

    public List<IFigure3D> getChildren3D() {
        List allChildren = this.m_figuresFriend.figure.getChildren();
        if (allChildren.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IFigure3D> children3D = new LinkedList<IFigure3D>();
        for (Object child : allChildren) {
            if (!(child instanceof Figure3D)) continue;
            children3D.add((IFigure3D)child);
        }
        return Collections.unmodifiableList(children3D);
    }

    public List<IFigure3D> getDescendants3D(boolean i_updateCache) {
        if (!this.m_decendants3DCacheValid && i_updateCache) {
            this.doGetDescendants3D(this.m_decendants3DCache, this.m_figuresFriend.figure);
        }
        return this.m_decendants3DCache;
    }

    public Picker getPicker() {
        UpdateManager updateManager = this.m_figuresFriend.figure.getUpdateManager();
        return ((PickingUpdateManager3D)updateManager).getPicker();
    }

    public void invalidateParaxialBoundsTree() {
        this.m_figuresFriend.figure.invalidateParaxialBounds();
        List<IFigure3D> descendants3D = this.getDescendants3D(false);
        for (IFigure3D descendant3D : descendants3D) {
            descendant3D.invalidateParaxialBounds();
        }
    }

    public void paintBorder(Graphics i_graphics) {
    }

    public void paintChildren(Graphics i_graphics) {
        this.paintChildren2D(i_graphics);
        this.paintChildren3D(i_graphics);
    }

    private void paintChildren2D(Graphics i_graphics) {
        List<IFigure> children2D = this.getChildren2D();
        if (!children2D.isEmpty()) {
            IFigure3D figure = this.m_figuresFriend.figure;
            ISurface surface = figure.getSurface();
            RenderContext renderContext = figure.getRenderContext();
            Graphics3D g3d = renderContext.getGraphics3D();
            if (surface != null && surface.is2DHost()) {
                if (renderContext.isRedraw2DContent() || this.m_figuresFriend.is2DContentDirty()) {
                    if (this.m_image != null) {
                        this.m_image.dispose();
                        this.m_image = null;
                    }
                    Rectangle bounds = figure.getBounds();
                    Graphics graphics = g3d.begin2DRendering((Object)figure, (IPosition3D)figure.getPosition3D(), bounds.width, bounds.height);
                    try {
                        graphics.setFont(i_graphics.getFont());
                        this.configureGraphics(graphics);
                        this.doPaintChildren2D(children2D, figure, graphics);
                    }
                    finally {
                        this.m_image = g3d.deactivateGraphics2D();
                        this.m_image.initialize(g3d);
                        if (this.m_fragment == null) {
                            this.m_fragment = new ImageRenderFragment(figure);
                        }
                        this.m_fragment.setImage(this.m_image);
                    }
                }
                if (this.m_fragment != null) {
                    renderContext.addRenderFragment(this.m_fragment);
                }
            } else {
                Graphics graphics = i_graphics;
                graphics.setFont(i_graphics.getFont());
                this.configureGraphics(graphics);
                this.doPaintChildren2D(children2D, figure, i_graphics);
            }
        }
    }

    private void paintChildren3D(Graphics i_graphics) {
        List<IFigure3D> children3D = this.getChildren3D();
        if (!children3D.isEmpty()) {
            for (IFigure3D child3D : children3D) {
                child3D.paint(i_graphics);
            }
        }
    }

    public void paintFigure(Graphics i_graphics) {
        IFigure3D figure = this.m_figuresFriend.figure;
        RenderContext renderContext = figure.getRenderContext();
        figure.collectRenderFragments(renderContext);
        IScene scene = renderContext.getScene();
        if (scene != null && scene.isDebug()) {
            renderContext.addRenderFragment(new ParaxialBoundsFigureShape(figure));
        }
    }

    public void revalidate() {
        this.m_decendants3DCache.clear();
        this.m_decendants3DCacheValid = false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " with " + this.m_figuresFriend;
    }

    public void unionWithChildParaxialBounds(ParaxialBoundingBox i_figureBounds) {
        ParaxialBoundingBox tmp = Draw3DCache.getParaxialBoundingBox();
        try {
            List<IFigure3D> descendants3D = this.getDescendants3D(true);
            for (IFigure3D descendant3D : descendants3D) {
                ParaxialBoundingBox descBounds = descendant3D.getParaxialBoundingBox(tmp);
                if (descBounds == null) continue;
                i_figureBounds.union((IParaxialBoundingBox)descBounds);
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{tmp});
            throw throwable;
        }
        Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{tmp});
    }

    private static class ImageRenderFragment
    implements RenderFragment {
        private IFigure3D m_figure;
        private RenderImage m_image;

        public ImageRenderFragment(IFigure3D i_figure) {
            this.m_figure = i_figure;
        }

        public float getDistanceMeasure(RenderContext i_renderContext) {
            float dist;
            Vector3f diff;
            Vector3f viewPoint;
            Vector3f viewDir;
            block3: {
                float f;
                ISurface surface = this.m_figure.getSurface();
                IVector3f normal = surface.getNormal();
                viewDir = Draw3DCache.getVector3f();
                viewPoint = Draw3DCache.getVector3f();
                diff = Draw3DCache.getVector3f();
                try {
                    ICamera camera = i_renderContext.getScene().getCamera();
                    camera.getViewDirection(viewDir);
                    camera.getPosition(viewPoint);
                    IVector3f figCenter = this.m_figure.getPosition3D().getCenter3D();
                    Math3D.sub((IVector3f)figCenter, (IVector3f)viewPoint, (Vector3f)diff);
                    dist = diff.lengthSquared();
                    float cos = Math3D.dot((IVector3f)normal, (IVector3f)viewDir);
                    if (!(cos > 0.0f)) break block3;
                    f = dist + 0.1f;
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewDir, viewPoint, diff});
                    throw throwable;
                }
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewDir, viewPoint, diff});
                return f;
            }
            float f = dist - 0.1f;
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewDir, viewPoint, diff});
            return f;
        }

        public RenderFragment.RenderType getRenderType() {
            return RenderFragment.RenderType.getRenderType(this.m_figure.getAlpha(), false);
        }

        public void render(RenderContext i_renderContext) {
            Position3D temp = Draw3DCache.getPosition3D();
            try {
                this.m_figure.getPosition3D().getAbsolute(temp);
                temp.setSize3D(IVector3f.UNITVEC3f);
                Graphics3D g3d = i_renderContext.getGraphics3D();
                g3d.glPushMatrix();
                try {
                    ICamera camera = i_renderContext.getScene().getCamera();
                    CameraLodHelper lodHelper = new CameraLodHelper(camera);
                    g3d.glDisable(2884);
                    g3d.setPosition((IPosition3D)temp);
                    this.m_image.render(g3d, (ILodHelper)lodHelper);
                }
                finally {
                    g3d.glPopMatrix();
                    g3d.glEnable(2884);
                }
            }
            catch (Throwable throwable) {
                Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{temp});
                throw throwable;
            }
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{temp});
        }

        public void setImage(RenderImage i_image) {
            this.m_image = i_image;
        }
    }
}

