/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.Math3DBase;
import org.eclipse.draw3d.geometry.Vector2f;
import org.eclipse.draw3d.geometry.Vector2fImpl;

public class Math3DVector2f
extends Math3DBase {
    public static Vector2f abs(IVector2f i_source, Vector2f io_result) {
        if (io_result == null) {
            io_result = new Vector2fImpl(Math.abs(i_source.getX()), Math.abs(i_source.getY()));
        } else {
            io_result.set(Math.abs(i_source.getX()), Math.abs(i_source.getY()));
        }
        return io_result;
    }

    public static Vector2f add(IVector2f i_left, IVector2f i_right, Vector2f o_result) {
        if (o_result == null) {
            return new Vector2fImpl(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY());
        }
        o_result.set(i_left.getX() + i_right.getX(), i_left.getY() + i_right.getY());
        return o_result;
    }

    public static float angle(IVector2f i_left, IVector2f i_right) {
        float cosAlpha = Math3DVector2f.dot(i_left, i_right) / (i_left.length() * i_right.length());
        if (cosAlpha <= -1.0f) {
            return (float)Math.PI;
        }
        if (cosAlpha >= 1.0f) {
            return 0.0f;
        }
        return (float)Math.acos(cosAlpha);
    }

    public static float dot(IVector2f i_left, IVector2f i_right) {
        return i_left.getX() * i_right.getX() + i_left.getY() * i_right.getY();
    }

    public static Vector2f negate(IVector2f i_source, Vector2f o_result) {
        if (o_result == null) {
            return new Vector2fImpl(-i_source.getX(), -i_source.getY());
        }
        o_result.set(-i_source.getX(), -i_source.getY());
        return o_result;
    }

    public static Vector2f normalise(IVector2f i_source, Vector2f o_result) {
        float lengthInv = 1.0f / i_source.length();
        return Math3DVector2f.scale(lengthInv, i_source, o_result);
    }

    public static Vector2f scale(float scale, IVector2f i_source, Vector2f o_result) {
        if (o_result == null) {
            return new Vector2fImpl(scale * i_source.getX(), scale * i_source.getY());
        }
        o_result.set(scale * i_source.getX(), scale * i_source.getY());
        return o_result;
    }

    public static Vector2f sub(IVector2f i_left, IVector2f i_right, Vector2f o_result) {
        if (o_result == null) {
            return new Vector2fImpl(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY());
        }
        o_result.set(i_left.getX() - i_right.getX(), i_left.getY() - i_right.getY());
        return o_result;
    }

    public static Vector2f translate(IVector2f i_source, float x, float y, Vector2f o_result) {
        if (o_result == null) {
            return new Vector2fImpl(x + i_source.getX(), y + i_source.getY());
        }
        o_result.set(x + i_source.getX(), y + i_source.getY());
        return o_result;
    }
}

