/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;
import java.util.HashSet;

public class HashSetCollections { 
  public int identifier;
  public HashSet HashSetOfObject0;
  public HashSet HashSetOfObject1;
  public HashSet HashSetOfObject2;
  public HashSet HashSetOfSimpleClass3;
  public HashSet HashSetOfSimpleClass4;
  public HashSet HashSetOfSimpleClass5;
  public HashSet HashSetOfSimpleInterface6;
  public HashSet HashSetOfSimpleInterface7;
  public HashSet HashSetOfSimpleInterface8;
  public HashSet HashSetOfString9;
  public HashSet HashSetOfString10;
  public HashSet HashSetOfString11;
  public HashSet HashSetOfDate12;
  public HashSet HashSetOfDate13;
  public HashSet HashSetOfDate14;
  public HashSet HashSetOfLocale15;
  public HashSet HashSetOfLocale16;
  public HashSet HashSetOfLocale17;
  public HashSet HashSetOfBigDecimal18;
  public HashSet HashSetOfBigDecimal19;
  public HashSet HashSetOfBigDecimal20;
  public HashSet HashSetOfBigInteger21;
  public HashSet HashSetOfBigInteger22;
  public HashSet HashSetOfBigInteger23;
  public HashSet HashSetOfByte24;
  public HashSet HashSetOfByte25;
  public HashSet HashSetOfByte26;
  public HashSet HashSetOfDouble27;
  public HashSet HashSetOfDouble28;
  public HashSet HashSetOfDouble29;
  public HashSet HashSetOfFloat30;
  public HashSet HashSetOfFloat31;
  public HashSet HashSetOfFloat32;
  public HashSet HashSetOfInteger33;
  public HashSet HashSetOfInteger34;
  public HashSet HashSetOfInteger35;
  public HashSet HashSetOfLong36;
  public HashSet HashSetOfLong37;
  public HashSet HashSetOfLong38;
  public HashSet HashSetOfShort39;
  public HashSet HashSetOfShort40;
  public HashSet HashSetOfShort41;
  public HashSet HashSetOfSimpleClass42;

  public static final String [] fieldSpecs = { 
  "public HashSet HashSetOfObject0",
  "embedded-element=true public HashSet HashSetOfObject1",
  "embedded-element=false public HashSet HashSetOfObject2",
  "public HashSet HashSetOfSimpleClass3",
  "embedded-element=true public HashSet HashSetOfSimpleClass4",
  "embedded-element=false public HashSet HashSetOfSimpleClass5",
  "public HashSet HashSetOfSimpleInterface6",
  "embedded-element=true public HashSet HashSetOfSimpleInterface7",
  "embedded-element=false public HashSet HashSetOfSimpleInterface8",
  "public HashSet HashSetOfString9",
  "embedded-element=true public HashSet HashSetOfString10",
  "embedded-element=false public HashSet HashSetOfString11",
  "public HashSet HashSetOfDate12",
  "embedded-element=true public HashSet HashSetOfDate13",
  "embedded-element=false public HashSet HashSetOfDate14",
  "public HashSet HashSetOfLocale15",
  "embedded-element=true public HashSet HashSetOfLocale16",
  "embedded-element=false public HashSet HashSetOfLocale17",
  "public HashSet HashSetOfBigDecimal18",
  "embedded-element=true public HashSet HashSetOfBigDecimal19",
  "embedded-element=false public HashSet HashSetOfBigDecimal20",
  "public HashSet HashSetOfBigInteger21",
  "embedded-element=true public HashSet HashSetOfBigInteger22",
  "embedded-element=false public HashSet HashSetOfBigInteger23",
  "public HashSet HashSetOfByte24",
  "embedded-element=true public HashSet HashSetOfByte25",
  "embedded-element=false public HashSet HashSetOfByte26",
  "public HashSet HashSetOfDouble27",
  "embedded-element=true public HashSet HashSetOfDouble28",
  "embedded-element=false public HashSet HashSetOfDouble29",
  "public HashSet HashSetOfFloat30",
  "embedded-element=true public HashSet HashSetOfFloat31",
  "embedded-element=false public HashSet HashSetOfFloat32",
  "public HashSet HashSetOfInteger33",
  "embedded-element=true public HashSet HashSetOfInteger34",
  "embedded-element=false public HashSet HashSetOfInteger35",
  "public HashSet HashSetOfLong36",
  "embedded-element=true public HashSet HashSetOfLong37",
  "embedded-element=false public HashSet HashSetOfLong38",
  "public HashSet HashSetOfShort39",
  "embedded-element=true public HashSet HashSetOfShort40",
  "embedded-element=false public HashSet HashSetOfShort41",
  "serialized=true public HashSet HashSetOfSimpleClass42"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public HashSet get(int index)
  {
    switch (index)
    {
      case(0):
        return HashSetOfObject0;
      case(1):
        return HashSetOfObject1;
      case(2):
        return HashSetOfObject2;
      case(3):
        return HashSetOfSimpleClass3;
      case(4):
        return HashSetOfSimpleClass4;
      case(5):
        return HashSetOfSimpleClass5;
      case(6):
        return HashSetOfSimpleInterface6;
      case(7):
        return HashSetOfSimpleInterface7;
      case(8):
        return HashSetOfSimpleInterface8;
      case(9):
        return HashSetOfString9;
      case(10):
        return HashSetOfString10;
      case(11):
        return HashSetOfString11;
      case(12):
        return HashSetOfDate12;
      case(13):
        return HashSetOfDate13;
      case(14):
        return HashSetOfDate14;
      case(15):
        return HashSetOfLocale15;
      case(16):
        return HashSetOfLocale16;
      case(17):
        return HashSetOfLocale17;
      case(18):
        return HashSetOfBigDecimal18;
      case(19):
        return HashSetOfBigDecimal19;
      case(20):
        return HashSetOfBigDecimal20;
      case(21):
        return HashSetOfBigInteger21;
      case(22):
        return HashSetOfBigInteger22;
      case(23):
        return HashSetOfBigInteger23;
      case(24):
        return HashSetOfByte24;
      case(25):
        return HashSetOfByte25;
      case(26):
        return HashSetOfByte26;
      case(27):
        return HashSetOfDouble27;
      case(28):
        return HashSetOfDouble28;
      case(29):
        return HashSetOfDouble29;
      case(30):
        return HashSetOfFloat30;
      case(31):
        return HashSetOfFloat31;
      case(32):
        return HashSetOfFloat32;
      case(33):
        return HashSetOfInteger33;
      case(34):
        return HashSetOfInteger34;
      case(35):
        return HashSetOfInteger35;
      case(36):
        return HashSetOfLong36;
      case(37):
        return HashSetOfLong37;
      case(38):
        return HashSetOfLong38;
      case(39):
        return HashSetOfShort39;
      case(40):
        return HashSetOfShort40;
      case(41):
        return HashSetOfShort41;
      case(42):
        return HashSetOfSimpleClass42;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,HashSet value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        HashSetOfObject0= value;
         break;
      case(1):
        HashSetOfObject1= value;
         break;
      case(2):
        HashSetOfObject2= value;
         break;
      case(3):
        HashSetOfSimpleClass3= value;
         break;
      case(4):
        HashSetOfSimpleClass4= value;
         break;
      case(5):
        HashSetOfSimpleClass5= value;
         break;
      case(6):
        HashSetOfSimpleInterface6= value;
         break;
      case(7):
        HashSetOfSimpleInterface7= value;
         break;
      case(8):
        HashSetOfSimpleInterface8= value;
         break;
      case(9):
        HashSetOfString9= value;
         break;
      case(10):
        HashSetOfString10= value;
         break;
      case(11):
        HashSetOfString11= value;
         break;
      case(12):
        HashSetOfDate12= value;
         break;
      case(13):
        HashSetOfDate13= value;
         break;
      case(14):
        HashSetOfDate14= value;
         break;
      case(15):
        HashSetOfLocale15= value;
         break;
      case(16):
        HashSetOfLocale16= value;
         break;
      case(17):
        HashSetOfLocale17= value;
         break;
      case(18):
        HashSetOfBigDecimal18= value;
         break;
      case(19):
        HashSetOfBigDecimal19= value;
         break;
      case(20):
        HashSetOfBigDecimal20= value;
         break;
      case(21):
        HashSetOfBigInteger21= value;
         break;
      case(22):
        HashSetOfBigInteger22= value;
         break;
      case(23):
        HashSetOfBigInteger23= value;
         break;
      case(24):
        HashSetOfByte24= value;
         break;
      case(25):
        HashSetOfByte25= value;
         break;
      case(26):
        HashSetOfByte26= value;
         break;
      case(27):
        HashSetOfDouble27= value;
         break;
      case(28):
        HashSetOfDouble28= value;
         break;
      case(29):
        HashSetOfDouble29= value;
         break;
      case(30):
        HashSetOfFloat30= value;
         break;
      case(31):
        HashSetOfFloat31= value;
         break;
      case(32):
        HashSetOfFloat32= value;
         break;
      case(33):
        HashSetOfInteger33= value;
         break;
      case(34):
        HashSetOfInteger34= value;
         break;
      case(35):
        HashSetOfInteger35= value;
         break;
      case(36):
        HashSetOfLong36= value;
         break;
      case(37):
        HashSetOfLong37= value;
         break;
      case(38):
        HashSetOfLong38= value;
         break;
      case(39):
        HashSetOfShort39= value;
         break;
      case(40):
        HashSetOfShort40= value;
         break;
      case(41):
        HashSetOfShort41= value;
         break;
      case(42):
        HashSetOfSimpleClass42= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
