/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.corpus;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrammarReader {
    private static final Pattern tokenPattern = Pattern.compile("K_[A-Z0-9_]+:\\s*'([^']+)'\\s*;");

    public static Set<String> parse(String grammarFilePath) throws IOException {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        List<String> lines = Files.readAllLines(Paths.get(grammarFilePath, new String[0]), StandardCharsets.UTF_8);
        for (String line : lines) {
            Matcher matcher = tokenPattern.matcher(line.trim());
            if (!matcher.matches()) continue;
            String keyword = matcher.group(1);
            keywords.add(keyword);
        }
        return keywords;
    }
}

