/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.TraverserGenerator;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class AddVertexStartStep
extends AbstractStep<Vertex, Vertex>
implements AddVertexStepContract<Vertex> {
    private Parameters internalParameters = new Parameters();
    private Parameters withConfiguration = new Parameters();
    private boolean first = true;
    private CallbackRegistry<Event.VertexAddedEvent> callbackRegistry;
    private boolean userProvidedLabel;

    public AddVertexStartStep(Traversal.Admin traversal, String label) {
        super(traversal);
        this.internalParameters.set(this, T.label, null == label ? "vertex" : label);
        this.userProvidedLabel = label != null;
    }

    public AddVertexStartStep(Traversal.Admin traversal, Traversal<?, String> vertexLabelTraversal) {
        super(traversal);
        this.internalParameters.set(this, T.label, null == vertexLabelTraversal ? "vertex" : vertexLabelTraversal);
        this.userProvidedLabel = vertexLabelTraversal != null;
    }

    @Override
    public boolean hasUserProvidedLabel() {
        return this.userProvidedLabel;
    }

    @Override
    public Object getElementId() {
        List ids = this.internalParameters.get(T.id, null);
        return ids.isEmpty() ? null : ids.get(0);
    }

    @Override
    public void setElementId(Object elementId) {
        this.configureInternalParams(T.id, elementId);
    }

    @Override
    public Parameters getParameters() {
        return this.withConfiguration;
    }

    @Override
    public Set<String> getScopeKeys() {
        return this.internalParameters.getReferencedLabels();
    }

    @Override
    public <S, E> List<Traversal.Admin<S, E>> getLocalChildren() {
        return this.internalParameters.getTraversals();
    }

    @Override
    public void configure(Object ... keyValues) {
        this.withConfiguration.set(this, keyValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureInternalParams(Object ... keyValues) {
        if (keyValues[0] == T.label && this.internalParameters.contains(T.label)) {
            if (!this.internalParameters.contains(T.label, "vertex")) throw new IllegalArgumentException(String.format("Vertex T.label has already been set to [%s] and cannot be overridden with [%s]", this.internalParameters.getRaw(new Object[0]).get(T.label).get(0), keyValues[1]));
            this.internalParameters.remove(T.label);
            this.internalParameters.set(this, keyValues);
            return;
        } else {
            if (keyValues[0] == T.id && this.internalParameters.contains(T.id)) {
                throw new IllegalArgumentException(String.format("Vertex T.id has already been set to [%s] and cannot be overridden with [%s]", this.internalParameters.getRaw(new Object[0]).get(T.id).get(0), keyValues[1]));
            }
            this.internalParameters.set(this, keyValues);
        }
    }

    @Override
    protected Traverser.Admin<Vertex> processNextStart() {
        if (this.first) {
            this.first = false;
            TraverserGenerator generator = this.getTraversal().getTraverserGenerator();
            Vertex vertex = this.getTraversal().getGraph().get().addVertex(this.internalParameters.getKeyValues(generator.generate(false, this, 1L), new Object[0]));
            EventUtil.registerVertexCreation(this.callbackRegistry, this.getTraversal(), vertex);
            return generator.generate(vertex, this, 1L);
        }
        throw FastNoSuchElementException.instance();
    }

    @Override
    public CallbackRegistry<Event.VertexAddedEvent> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event.VertexAddedEvent>();
        }
        return this.callbackRegistry;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.internalParameters.hashCode() ^ this.withConfiguration.hashCode();
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.internalParameters);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.internalParameters.getTraversals().forEach(this::integrateChild);
        this.withConfiguration.getTraversals().forEach(this::integrateChild);
    }

    @Override
    public AddVertexStartStep clone() {
        AddVertexStartStep clone = (AddVertexStartStep)super.clone();
        clone.internalParameters = this.internalParameters.clone();
        clone.withConfiguration = this.withConfiguration.clone();
        clone.userProvidedLabel = this.userProvidedLabel;
        return clone;
    }

    @Override
    public Object getLabel() {
        String label = this.internalParameters.get(T.label, () -> "vertex").get(0);
        if (label instanceof ConstantTraversal) {
            return ((ConstantTraversal)((Object)label)).next();
        }
        return label;
    }

    @Override
    public void setLabel(Object label) {
        this.configure(T.label, label);
    }

    @Override
    public Map<Object, List<Object>> getProperties() {
        return Collections.unmodifiableMap(this.internalParameters.getRaw(T.id, T.label));
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.internalParameters.contains(k)) {
            this.internalParameters.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeElementId() {
        if (this.internalParameters.contains(T.id)) {
            this.internalParameters.remove(T.id);
            return true;
        }
        return false;
    }

    @Override
    public void addProperty(Object key, Object value) {
        this.configureInternalParams(key, value);
    }
}

