/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import io.netty.buffer.ByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.util.ser.AbstractGraphSONMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.ser.MessageTextSerializer;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphSONUntypedMessageSerializerV1
extends AbstractGraphSONMessageSerializerV1
implements MessageTextSerializer<ObjectMapper> {
    private static final Logger logger = LoggerFactory.getLogger(GraphSONUntypedMessageSerializerV1.class);
    private static final String MIME_TYPE = "application/vnd.gremlin-v1.0+json;types=false";
    private static byte[] header;

    public GraphSONUntypedMessageSerializerV1() {
    }

    public GraphSONUntypedMessageSerializerV1(GraphSONMapper mapper) {
        super(mapper);
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE, "application/json"};
    }

    @Override
    GraphSONMapper.Builder configureBuilder(GraphSONMapper.Builder builder) {
        return builder.addCustomModule((SimpleModule)new AbstractGraphSONMessageSerializerV1.GremlinServerModule()).typeInfo(TypeInfo.NO_TYPES);
    }

    @Override
    byte[] obtainHeader() {
        return header;
    }

    @Override
    public ResponseMessage deserializeResponse(String msg) throws SerializationException {
        try {
            Map responseData = (Map)this.mapper.readValue(msg, this.mapTypeReference);
            Map status = (Map)responseData.get("status");
            Map result = (Map)responseData.get("result");
            return ResponseMessage.build(UUID.fromString(responseData.get("requestId").toString())).code(ResponseStatusCode.getFromValue((Integer)status.get("code"))).statusMessage(String.valueOf(status.get("message"))).statusAttributes((Map)status.get("attributes")).result(result.get("data")).responseMetaData((Map)result.get("meta")).create();
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV1.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeResponseAsString(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)responseMessage);
        }
        catch (Exception ex) {
            logger.warn("Response [{}] could not be serialized by {}.", (Object)responseMessage.toString(), (Object)AbstractGraphSONMessageSerializerV1.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public RequestMessage deserializeRequest(String msg) throws SerializationException {
        try {
            return (RequestMessage)this.mapper.readValue(msg, RequestMessage.class);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be deserialized by {}.", (Object)msg, (Object)AbstractGraphSONMessageSerializerV1.class.getName());
            throw new SerializationException(ex);
        }
    }

    @Override
    public String serializeRequestAsString(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        try {
            return this.mapper.writeValueAsString((Object)requestMessage);
        }
        catch (Exception ex) {
            logger.warn("Request [{}] could not be serialized by {}.", (Object)requestMessage.toString(), (Object)AbstractGraphSONMessageSerializerV1.class.getName());
            throw new SerializationException(ex);
        }
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocate(MIME_TYPE.length() + 1);
        buffer.put((byte)MIME_TYPE.length());
        buffer.put(MIME_TYPE.getBytes());
        header = buffer.array();
    }
}

