/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.exec;

import org.apache.spark.ExceptionFailure;
import org.apache.spark.Resubmitted$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.TaskEndReason;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.StorageStatusListener;
import org.apache.spark.ui.exec.ExecutorTaskSummary;
import org.apache.spark.ui.exec.ExecutorTaskSummary$;
import org.apache.spark.ui.exec.ExecutorsListener$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u00015\u0011\u0011#\u0012=fGV$xN]:MSN$XM\\3s\u0015\t\u0019A!\u0001\u0003fq\u0016\u001c'BA\u0003\u0007\u0003\t)\u0018N\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E1\u0011!C:dQ\u0016$W\u000f\\3s\u0013\t\u0019\u0002CA\u0007Ta\u0006\u00148\u000eT5ti\u0016tWM\u001d\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005)2\u000f^8sC\u001e,7\u000b^1ukNd\u0015n\u001d;f]\u0016\u0014\bCA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u0007\r\u0003+M#xN]1hKN#\u0018\r^;t\u0019&\u001cH/\u001a8fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:4\u0007CA\u0010!\u001b\u00051\u0011BA\u0011\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0004K\u001dB\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"B\u000b#\u0001\u00041\u0002\"B\u000f#\u0001\u0004q\u0002b\u0002\u0016\u0001\u0001\u0004%\taK\u0001\u0016Kb,7-\u001e;peR{G+Y:l'VlW.\u0019:z+\u0005a\u0003\u0003B\u00175myj\u0011A\f\u0006\u0003_A\nq!\\;uC\ndWM\u0003\u00022e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u0018\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\t94H\u0004\u00029s5\t!'\u0003\u0002;e\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ$\u0007\u0005\u0002'\u007f%\u0011\u0001I\u0001\u0002\u0014\u000bb,7-\u001e;peR\u000b7o[*v[6\f'/\u001f\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0003e)\u00070Z2vi>\u0014Hk\u001c+bg.\u001cV/\\7bef|F%Z9\u0015\u0005\u0011;\u0005C\u0001\u001dF\u0013\t1%G\u0001\u0003V]&$\bb\u0002%B\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\n\u0004B\u0002&\u0001A\u0003&A&\u0001\ffq\u0016\u001cW\u000f^8s)>$\u0016m]6Tk6l\u0017M]=!\u0011\u001da\u0005\u00011A\u0005\u00025\u000ba\"\u001a=fGV$xN]#wK:$8/F\u0001O!\ris*U\u0005\u0003!:\u0012!\u0002T5ti\n+hMZ3s!\ty!+\u0003\u0002T!\t\u00112\u000b]1sW2K7\u000f^3oKJ,e/\u001a8u\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000b!#\u001a=fGV$xN]#wK:$8o\u0018\u0013fcR\u0011Ai\u0016\u0005\b\u0011R\u000b\t\u00111\u0001O\u0011\u0019I\u0006\u0001)Q\u0005\u001d\u0006yQ\r_3dkR|'/\u0012<f]R\u001c\b\u0005C\u0004\\\u0001\t\u0007I\u0011\u0002/\u0002)5\f\u0007\u0010V5nK2Lg.Z#yK\u000e,Ho\u001c:t+\u0005i\u0006C\u0001\u001d_\u0013\ty&GA\u0002J]RDa!\u0019\u0001!\u0002\u0013i\u0016!F7bqRKW.\u001a7j]\u0016,\u00050Z2vi>\u00148\u000f\t\u0005\bG\u0002\u0011\r\u0011\"\u0003]\u0003U\u0011X\r^1j]\u0016$G)Z1e\u000bb,7-\u001e;peNDa!\u001a\u0001!\u0002\u0013i\u0016A\u0006:fi\u0006Lg.\u001a3EK\u0006$W\t_3dkR|'o\u001d\u0011\t\u000b\u001d\u0004A\u0011\u00015\u0002/\u0005\u001cG/\u001b<f'R|'/Y4f'R\fG/^:MSN$X#A5\u0011\u0007)\u0014XO\u0004\u0002la:\u0011An\\\u0007\u0002[*\u0011a\u000eD\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!!\u001d\u001a\u0002\u000fA\f7m[1hK&\u00111\u000f\u001e\u0002\u0004'\u0016\f(BA93!\t9b/\u0003\u0002x1\ti1\u000b^8sC\u001e,7\u000b^1ukNDQ!\u001f\u0001\u0005\u0002!\fQ\u0003Z3bIN#xN]1hKN#\u0018\r^;t\u0019&\u001cH\u000fC\u0003|\u0001\u0011\u0005C0A\bp]\u0016CXmY;u_J\fE\rZ3e)\t!U\u0010C\u0003\u007fu\u0002\u0007q0A\u0007fq\u0016\u001cW\u000f^8s\u0003\u0012$W\r\u001a\t\u0004\u001f\u0005\u0005\u0011bAA\u0002!\tQ2\u000b]1sW2K7\u000f^3oKJ,\u00050Z2vi>\u0014\u0018\t\u001a3fI\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011!E8o\u000bb,7-\u001e;peJ+Wn\u001c<fIR\u0019A)a\u0003\t\u0011\u00055\u0011Q\u0001a\u0001\u0003\u001f\tq\"\u001a=fGV$xN\u001d*f[>4X\r\u001a\t\u0004\u001f\u0005E\u0011bAA\n!\ta2\u000b]1sW2K7\u000f^3oKJ,\u00050Z2vi>\u0014(+Z7pm\u0016$\u0007bBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\u0013_:\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006\u0014H\u000fF\u0002E\u00037A\u0001\"!\b\u0002\u0016\u0001\u0007\u0011qD\u0001\u0011CB\u0004H.[2bi&|gn\u0015;beR\u00042aDA\u0011\u0013\r\t\u0019\u0003\u0005\u0002\u001e'B\f'o\u001b'jgR,g.\u001a:BaBd\u0017nY1uS>t7\u000b^1si\"9\u0011q\u0005\u0001\u0005B\u0005%\u0012aC8o)\u0006\u001c8n\u0015;beR$2\u0001RA\u0016\u0011!\ti#!\nA\u0002\u0005=\u0012!\u0003;bg.\u001cF/\u0019:u!\ry\u0011\u0011G\u0005\u0004\u0003g\u0001\"AF*qCJ\\G*[:uK:,'\u000fV1tWN#\u0018M\u001d;\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:\u0005IqN\u001c+bg.,e\u000e\u001a\u000b\u0004\t\u0006m\u0002\u0002CA\u001f\u0003k\u0001\r!a\u0010\u0002\u000fQ\f7o[#oIB\u0019q\"!\u0011\n\u0007\u0005\r\u0003C\u0001\u000bTa\u0006\u00148\u000eT5ti\u0016tWM\u001d+bg.,e\u000e\u001a\u0015\u0004\u0001\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055c!\u0001\u0006b]:|G/\u0019;j_:LA!!\u0015\u0002L\taA)\u001a<fY>\u0004XM]!qS\u0002")
public class ExecutorsListener
extends SparkListener {
    private final StorageStatusListener storageStatusListener;
    private final SparkConf conf;
    private LinkedHashMap<String, ExecutorTaskSummary> executorToTaskSummary;
    private ListBuffer<SparkListenerEvent> executorEvents;
    private final int maxTimelineExecutors;
    private final int retainedDeadExecutors;

    public LinkedHashMap<String, ExecutorTaskSummary> executorToTaskSummary() {
        return this.executorToTaskSummary;
    }

    public void executorToTaskSummary_$eq(LinkedHashMap<String, ExecutorTaskSummary> x$1) {
        this.executorToTaskSummary = x$1;
    }

    public ListBuffer<SparkListenerEvent> executorEvents() {
        return this.executorEvents;
    }

    public void executorEvents_$eq(ListBuffer<SparkListenerEvent> x$1) {
        this.executorEvents = x$1;
    }

    private int maxTimelineExecutors() {
        return this.maxTimelineExecutors;
    }

    private int retainedDeadExecutors() {
        return this.retainedDeadExecutors;
    }

    public Seq<StorageStatus> activeStorageStatusList() {
        return this.storageStatusListener.storageStatusList();
    }

    public Seq<StorageStatus> deadStorageStatusList() {
        return this.storageStatusListener.deadStorageStatusList();
    }

    @Override
    public void onExecutorAdded(SparkListenerExecutorAdded executorAdded2) {
        ExecutorsListener executorsListener = this;
        synchronized (executorsListener) {
            BoxedUnit boxedUnit;
            String eid = executorAdded2.executorId();
            ExecutorTaskSummary taskSummary2 = (ExecutorTaskSummary)this.executorToTaskSummary().getOrElseUpdate((Object)eid, (Function0)new Serializable(this, eid){
                public static final long serialVersionUID = 0L;
                private final String eid$1;

                public final ExecutorTaskSummary apply() {
                    return new ExecutorTaskSummary(this.eid$1, ExecutorTaskSummary$.MODULE$.apply$default$2(), ExecutorTaskSummary$.MODULE$.apply$default$3(), ExecutorTaskSummary$.MODULE$.apply$default$4(), ExecutorTaskSummary$.MODULE$.apply$default$5(), ExecutorTaskSummary$.MODULE$.apply$default$6(), ExecutorTaskSummary$.MODULE$.apply$default$7(), ExecutorTaskSummary$.MODULE$.apply$default$8(), ExecutorTaskSummary$.MODULE$.apply$default$9(), ExecutorTaskSummary$.MODULE$.apply$default$10(), ExecutorTaskSummary$.MODULE$.apply$default$11(), ExecutorTaskSummary$.MODULE$.apply$default$12(), ExecutorTaskSummary$.MODULE$.apply$default$13(), ExecutorTaskSummary$.MODULE$.apply$default$14(), ExecutorTaskSummary$.MODULE$.apply$default$15(), ExecutorTaskSummary$.MODULE$.apply$default$16());
                }
                {
                    this.eid$1 = eid$1;
                }
            });
            taskSummary2.executorLogs_$eq(executorAdded2.executorInfo().logUrlMap());
            taskSummary2.totalCores_$eq(executorAdded2.executorInfo().totalCores());
            taskSummary2.tasksMax_$eq(taskSummary2.totalCores() / this.conf.getInt("spark.task.cpus", 1));
            this.executorEvents().$plus$eq((Object)executorAdded2);
            Object object = this.executorEvents().size() > this.maxTimelineExecutors() ? this.executorEvents().remove(0) : BoxedUnit.UNIT;
            LinkedHashMap deadExecutors = (LinkedHashMap)this.executorToTaskSummary().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, ExecutorTaskSummary> e) {
                    return !((ExecutorTaskSummary)e._2()).isAlive();
                }
            });
            if (deadExecutors.size() > this.retainedDeadExecutors()) {
                Tuple2 head = (Tuple2)deadExecutors.head();
                boxedUnit = this.executorToTaskSummary().remove(head._1());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public synchronized void onExecutorRemoved(SparkListenerExecutorRemoved executorRemoved2) {
        this.executorEvents().$plus$eq((Object)executorRemoved2);
        Object object = this.executorEvents().size() > this.maxTimelineExecutors() ? this.executorEvents().remove(0) : BoxedUnit.UNIT;
        this.executorToTaskSummary().get((Object)executorRemoved2.executorId()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(ExecutorTaskSummary e) {
                e.isAlive_$eq(false);
            }
        });
    }

    @Override
    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
        applicationStart.driverLogs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorsListener $outer;

            public final void apply(Map<String, String> logs) {
                Option storageStatus2 = this.$outer.activeStorageStatusList().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(StorageStatus s) {
                        String string = s.blockManagerId().executorId();
                        String string2 = SparkContext$.MODULE$.LEGACY_DRIVER_IDENTIFIER();
                        if (string == null) {
                            if (string2 == null) return true;
                        } else if (string.equals(string2)) return true;
                        String string3 = s.blockManagerId().executorId();
                        String string4 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                        if (string3 != null) {
                            if (!string3.equals(string4)) return false;
                            return true;
                        }
                        if (string4 == null) return true;
                        return false;
                    }
                });
                storageStatus2.foreach((Function1)new Serializable(this, logs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$onApplicationStart$1 $outer;
                    private final Map logs$1;

                    public final void apply(StorageStatus s) {
                        String eid = s.blockManagerId().executorId();
                        ExecutorTaskSummary taskSummary2 = (ExecutorTaskSummary)this.$outer.org$apache$spark$ui$exec$ExecutorsListener$$anonfun$$$outer().executorToTaskSummary().getOrElseUpdate((Object)eid, (Function0)new Serializable(this, eid){
                            public static final long serialVersionUID = 0L;
                            private final String eid$2;

                            public final ExecutorTaskSummary apply() {
                                return new ExecutorTaskSummary(this.eid$2, ExecutorTaskSummary$.MODULE$.apply$default$2(), ExecutorTaskSummary$.MODULE$.apply$default$3(), ExecutorTaskSummary$.MODULE$.apply$default$4(), ExecutorTaskSummary$.MODULE$.apply$default$5(), ExecutorTaskSummary$.MODULE$.apply$default$6(), ExecutorTaskSummary$.MODULE$.apply$default$7(), ExecutorTaskSummary$.MODULE$.apply$default$8(), ExecutorTaskSummary$.MODULE$.apply$default$9(), ExecutorTaskSummary$.MODULE$.apply$default$10(), ExecutorTaskSummary$.MODULE$.apply$default$11(), ExecutorTaskSummary$.MODULE$.apply$default$12(), ExecutorTaskSummary$.MODULE$.apply$default$13(), ExecutorTaskSummary$.MODULE$.apply$default$14(), ExecutorTaskSummary$.MODULE$.apply$default$15(), ExecutorTaskSummary$.MODULE$.apply$default$16());
                            }
                            {
                                this.eid$2 = eid$2;
                            }
                        });
                        taskSummary2.executorLogs_$eq((scala.collection.immutable.Map<String, String>)this.logs$1.toMap(Predef$.MODULE$.$conforms()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.logs$1 = logs$1;
                    }
                });
            }

            public /* synthetic */ ExecutorsListener org$apache$spark$ui$exec$ExecutorsListener$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public synchronized void onTaskStart(SparkListenerTaskStart taskStart) {
        String eid = taskStart.taskInfo().executorId();
        ExecutorTaskSummary taskSummary2 = (ExecutorTaskSummary)this.executorToTaskSummary().getOrElseUpdate((Object)eid, (Function0)new Serializable(this, eid){
            public static final long serialVersionUID = 0L;
            private final String eid$3;

            public final ExecutorTaskSummary apply() {
                return new ExecutorTaskSummary(this.eid$3, ExecutorTaskSummary$.MODULE$.apply$default$2(), ExecutorTaskSummary$.MODULE$.apply$default$3(), ExecutorTaskSummary$.MODULE$.apply$default$4(), ExecutorTaskSummary$.MODULE$.apply$default$5(), ExecutorTaskSummary$.MODULE$.apply$default$6(), ExecutorTaskSummary$.MODULE$.apply$default$7(), ExecutorTaskSummary$.MODULE$.apply$default$8(), ExecutorTaskSummary$.MODULE$.apply$default$9(), ExecutorTaskSummary$.MODULE$.apply$default$10(), ExecutorTaskSummary$.MODULE$.apply$default$11(), ExecutorTaskSummary$.MODULE$.apply$default$12(), ExecutorTaskSummary$.MODULE$.apply$default$13(), ExecutorTaskSummary$.MODULE$.apply$default$14(), ExecutorTaskSummary$.MODULE$.apply$default$15(), ExecutorTaskSummary$.MODULE$.apply$default$16());
            }
            {
                this.eid$3 = eid$3;
            }
        });
        taskSummary2.tasksActive_$eq(taskSummary2.tasksActive() + 1);
    }

    @Override
    public synchronized void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskInfo info = taskEnd.taskInfo();
        if (info != null) {
            String eid = info.executorId();
            ExecutorTaskSummary taskSummary2 = (ExecutorTaskSummary)this.executorToTaskSummary().getOrElseUpdate((Object)eid, (Function0)new Serializable(this, eid){
                public static final long serialVersionUID = 0L;
                private final String eid$4;

                public final ExecutorTaskSummary apply() {
                    return new ExecutorTaskSummary(this.eid$4, ExecutorTaskSummary$.MODULE$.apply$default$2(), ExecutorTaskSummary$.MODULE$.apply$default$3(), ExecutorTaskSummary$.MODULE$.apply$default$4(), ExecutorTaskSummary$.MODULE$.apply$default$5(), ExecutorTaskSummary$.MODULE$.apply$default$6(), ExecutorTaskSummary$.MODULE$.apply$default$7(), ExecutorTaskSummary$.MODULE$.apply$default$8(), ExecutorTaskSummary$.MODULE$.apply$default$9(), ExecutorTaskSummary$.MODULE$.apply$default$10(), ExecutorTaskSummary$.MODULE$.apply$default$11(), ExecutorTaskSummary$.MODULE$.apply$default$12(), ExecutorTaskSummary$.MODULE$.apply$default$13(), ExecutorTaskSummary$.MODULE$.apply$default$14(), ExecutorTaskSummary$.MODULE$.apply$default$15(), ExecutorTaskSummary$.MODULE$.apply$default$16());
                }
                {
                    this.eid$4 = eid$4;
                }
            });
            TaskEndReason taskEndReason = taskEnd.reason();
            if (Resubmitted$.MODULE$.equals(taskEndReason)) {
                return;
            }
            if (taskEndReason instanceof ExceptionFailure) {
                taskSummary2.tasksFailed_$eq(taskSummary2.tasksFailed() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                taskSummary2.tasksComplete_$eq(taskSummary2.tasksComplete() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (taskSummary2.tasksActive() >= 1) {
                taskSummary2.tasksActive_$eq(taskSummary2.tasksActive() - 1);
            }
            taskSummary2.duration_$eq(taskSummary2.duration() + info.duration());
            TaskMetrics metrics = taskEnd.taskMetrics();
            if (metrics != null) {
                taskSummary2.inputBytes_$eq(taskSummary2.inputBytes() + metrics.inputMetrics().bytesRead());
                taskSummary2.inputRecords_$eq(taskSummary2.inputRecords() + metrics.inputMetrics().recordsRead());
                taskSummary2.outputBytes_$eq(taskSummary2.outputBytes() + metrics.outputMetrics().bytesWritten());
                taskSummary2.outputRecords_$eq(taskSummary2.outputRecords() + metrics.outputMetrics().recordsWritten());
                taskSummary2.shuffleRead_$eq(taskSummary2.shuffleRead() + metrics.shuffleReadMetrics().remoteBytesRead());
                taskSummary2.shuffleWrite_$eq(taskSummary2.shuffleWrite() + metrics.shuffleWriteMetrics().bytesWritten());
                taskSummary2.jvmGCTime_$eq(taskSummary2.jvmGCTime() + metrics.jvmGCTime());
            }
        }
    }

    public ExecutorsListener(StorageStatusListener storageStatusListener, SparkConf conf) {
        this.storageStatusListener = storageStatusListener;
        this.conf = conf;
        this.executorToTaskSummary = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.executorEvents = new ListBuffer();
        this.maxTimelineExecutors = conf.getInt("spark.ui.timeline.executors.maximum", 1000);
        this.retainedDeadExecutors = conf.getInt("spark.ui.retainedDeadExecutors", 100);
    }
}

