/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ModelDriven;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ValidationAware;

public class JSONValidationInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LogManager.getLogger(JSONValidationInterceptor.class);
    public static final String VALIDATE_ONLY_PARAM = "struts.validateOnly";
    public static final String VALIDATE_JSON_PARAM = "struts.enableJSONValidation";
    public static final String NO_ENCODING_SET_PARAM = "struts.JSONValidation.no.encoding";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private int validationFailedStatus = 400;
    private String validateOnlyParam = "struts.validateOnly";
    private String validateJsonParam = "struts.enableJSONValidation";
    private String noEncodingSetParam = "struts.JSONValidation.no.encoding";

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        HttpServletRequest request = ServletActionContext.getRequest();
        Object action = invocation.getAction();
        if (this.isJsonEnabled(request)) {
            ValidationAware validationAware;
            if (action instanceof ValidationAware && (validationAware = (ValidationAware)action).hasErrors()) {
                return this.generateJSON(request, response, validationAware);
            }
            if (this.isValidateOnly(request)) {
                this.setupEncoding(response, request);
                response.getWriter().print("{}");
                response.setContentType("application/json");
                return "none";
            }
            return invocation.invoke();
        }
        return invocation.invoke();
    }

    private void setupEncoding(HttpServletResponse response, HttpServletRequest request) {
        if (this.isSetEncoding(request)) {
            LOG.debug("Default encoding not set!");
        } else {
            LOG.debug("Setting up encoding to: [{}]!", (Object)DEFAULT_ENCODING);
            response.setCharacterEncoding(DEFAULT_ENCODING);
        }
    }

    private String generateJSON(HttpServletRequest request, HttpServletResponse response, ValidationAware validationAware) throws IOException {
        if (this.validationFailedStatus >= 0) {
            response.setStatus(this.validationFailedStatus);
        }
        this.setupEncoding(response, request);
        response.getWriter().print(this.buildResponse(validationAware));
        response.setContentType("application/json");
        return "none";
    }

    public boolean isJsonEnabled(HttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(this.validateJsonParam));
    }

    public boolean isValidateOnly(HttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(this.validateOnlyParam));
    }

    public boolean isSetEncoding(HttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(this.noEncodingSetParam));
    }

    protected String buildResponse(ValidationAware validationAware) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        if (validationAware.hasErrors()) {
            if (validationAware.hasActionErrors()) {
                sb.append("\"errors\":");
                sb.append(this.buildArray(validationAware.getActionErrors()));
            }
            if (validationAware.hasFieldErrors()) {
                if (validationAware.hasActionErrors()) {
                    sb.append(",");
                }
                sb.append("\"fieldErrors\": {");
                Map fieldErrors = validationAware.getFieldErrors();
                for (Map.Entry fieldError : fieldErrors.entrySet()) {
                    sb.append("\"");
                    String fieldErrorKey = (String)fieldError.getKey();
                    sb.append(validationAware instanceof ModelDriven && fieldErrorKey.startsWith("model.") ? fieldErrorKey.substring(6) : fieldErrorKey);
                    sb.append("\":");
                    sb.append(this.buildArray((Collection)fieldError.getValue()));
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("}");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private String buildArray(Collection<String> values) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (String value : values) {
            sb.append("\"");
            sb.append(StringEscapeUtils.escapeJson((String)value));
            sb.append("\",");
        }
        if (values.size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setValidationFailedStatus(int validationFailedStatus) {
        this.validationFailedStatus = validationFailedStatus;
    }

    public void setValidateOnlyParam(String validateOnlyParam) {
        this.validateOnlyParam = validateOnlyParam;
    }

    public void setValidateJsonParam(String validateJsonParam) {
        this.validateJsonParam = validateJsonParam;
    }

    public void setNoEncodingSetParam(String noEncodingSetParam) {
        this.noEncodingSetParam = noEncodingSetParam;
    }
}

