/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.util;

import com.google.gxp.com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;

public class ClassMap<K, V>
implements Serializable {
    private final Map<Class<?>, V> map = Maps.newIdentityHashMap();
    private static final long serialVersionUID = 1L;

    public static <K, V> ClassMap<K, V> create() {
        return new ClassMap<K, V>();
    }

    public V put(Class<? extends K> key, V value) {
        if (key.isInterface()) {
            throw new IllegalArgumentException("ClassMap cannot use interfaces as keys!");
        }
        V result = this.map.put(key, value);
        if (result == null) {
            result = this.getImpl(key.getSuperclass());
        }
        return result;
    }

    public V get(Object key) {
        if (key instanceof Class) {
            return this.getImpl((Class)key);
        }
        return null;
    }

    private V getImpl(Class<?> key) {
        for (Class<?> superKey = key; superKey != null; superKey = superKey.getSuperclass()) {
            V result = this.map.get(superKey);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

