/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.ant;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSet;
import com.google.gxp.compiler.alerts.AlertSink;
import org.apache.tools.ant.Task;

public class LoggingAlertSink
implements AlertSink {
    private final AlertPolicy alertPolicy;
    private final Task task;

    public LoggingAlertSink(AlertPolicy alertPolicy, Task task) {
        this.alertPolicy = Preconditions.checkNotNull(alertPolicy);
        this.task = Preconditions.checkNotNull(task);
    }

    @Override
    public void add(Alert alert) {
        switch (this.alertPolicy.getSeverity(alert)) {
            case INFO: {
                this.task.log(alert.toString(), 3);
                break;
            }
            case WARNING: {
                this.task.log(alert.toString(), 1);
                break;
            }
            case ERROR: {
                this.task.log(alert.toString(), 0);
            }
        }
    }

    @Override
    public void addAll(AlertSet alertSet) {
        for (Alert alert : alertSet) {
            this.add(alert);
        }
    }
}

