/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.ProcessorContext;

abstract class BaseProcessor<T>
implements Processor<T> {
    private final Set<String> punctuationState = new HashSet<String>();
    protected ProcessorContext context;

    BaseProcessor() {
    }

    @Override
    public void init(ProcessorContext context) {
        this.context = context;
    }

    @Override
    public void execute(T input, String streamId) {
        this.execute(input);
    }

    protected void execute(T input) {
    }

    @Override
    public void punctuate(String stream) {
        if (stream == null || this.shouldPunctuate(stream)) {
            this.finish();
            this.context.forward("__punctuation");
            this.punctuationState.clear();
        }
    }

    protected void finish() {
    }

    protected final <R> void mayBeForwardAggUpdate(Supplier<R> result2) {
        if (!this.context.isWindowed()) {
            this.context.forward(result2.get());
        }
    }

    private boolean shouldPunctuate(String parentStream) {
        this.punctuationState.add(parentStream);
        return this.punctuationState.equals(this.context.getWindowedParentStreams());
    }
}

