/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.traverse;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.traverse.CrossComponentIterator;
import org.apache.storm.shade.org.jgrapht.util.TypeUtil;

public class DepthFirstIterator<V, E>
extends CrossComponentIterator<V, E, CrossComponentIterator.VisitColor> {
    public static final Object SENTINEL = new Object();
    private Deque<Object> stack = new ArrayDeque<Object>();
    private transient TypeUtil<V> vertexTypeDecl = null;

    public DepthFirstIterator(Graph<V, E> g) {
        this(g, null);
    }

    public DepthFirstIterator(Graph<V, E> g, V startVertex) {
        super(g, startVertex);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        while (!this.stack.isEmpty()) {
            if (this.stack.getLast() != SENTINEL) {
                return false;
            }
            this.stack.removeLast();
            this.recordFinish();
        }
        return true;
    }

    @Override
    protected void encounterVertex(V vertex, E edge) {
        this.putSeenData(vertex, CrossComponentIterator.VisitColor.WHITE);
        this.stack.addLast(vertex);
    }

    @Override
    protected void encounterVertexAgain(V vertex, E edge) {
        CrossComponentIterator.VisitColor color = (CrossComponentIterator.VisitColor)((Object)this.getSeenData(vertex));
        if (color != CrossComponentIterator.VisitColor.WHITE) {
            return;
        }
        boolean found = this.stack.removeLastOccurrence(vertex);
        assert (found);
        this.stack.addLast(vertex);
    }

    @Override
    protected V provideNextVertex() {
        Object o;
        while ((o = this.stack.removeLast()) == SENTINEL) {
            this.recordFinish();
        }
        V v = TypeUtil.uncheckedCast(o, this.vertexTypeDecl);
        this.stack.addLast(v);
        this.stack.addLast(SENTINEL);
        this.putSeenData(v, CrossComponentIterator.VisitColor.GRAY);
        return v;
    }

    private void recordFinish() {
        V v = TypeUtil.uncheckedCast(this.stack.removeLast(), this.vertexTypeDecl);
        this.putSeenData(v, CrossComponentIterator.VisitColor.BLACK);
        this.finishVertex(v);
    }

    public Deque<Object> getStack() {
        return this.stack;
    }
}

