/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.Duration;
import io.dropwizard.validation.MaxDuration;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.concurrent.TimeUnit;

public class MaxDurationValidator
implements ConstraintValidator<MaxDuration, Duration> {
    private long maxQty = 0L;
    private TimeUnit maxUnit = TimeUnit.MILLISECONDS;
    private boolean inclusive = true;

    public void initialize(MaxDuration constraintAnnotation) {
        this.maxQty = constraintAnnotation.value();
        this.maxUnit = constraintAnnotation.unit();
        this.inclusive = constraintAnnotation.inclusive();
    }

    public boolean isValid(Duration value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        long valueNanos = value.toNanoseconds();
        long annotationNanos = this.maxUnit.toNanos(this.maxQty);
        if (this.inclusive) {
            return valueNanos <= annotationNanos;
        }
        return valueNanos < annotationNanos;
    }
}

