/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filterext;

import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;

public class ZoneAwareDiscoveryFilter
implements ServerListFilterExt {
    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.zoneaware.enabled", true).get();
    }

    @Override
    public List<ServiceCombServer> getFilteredListOfServers(List<ServiceCombServer> servers, Invocation invocation) {
        MicroserviceInstance myself = RegistryUtils.getMicroserviceInstance();
        ArrayList<ServiceCombServer> instancesRegionAndAZMatch = new ArrayList<ServiceCombServer>();
        ArrayList<ServiceCombServer> instancesAZMatch = new ArrayList<ServiceCombServer>();
        ArrayList<ServiceCombServer> instancesNoMatch = new ArrayList<ServiceCombServer>();
        servers.forEach(server -> {
            if (this.regionAndAZMatch(myself, server.getInstance())) {
                instancesRegionAndAZMatch.add((ServiceCombServer)((Object)server));
            } else if (this.regionMatch(myself, server.getInstance())) {
                instancesAZMatch.add((ServiceCombServer)((Object)server));
            } else {
                instancesNoMatch.add((ServiceCombServer)((Object)server));
            }
        });
        if (!instancesRegionAndAZMatch.isEmpty()) {
            return instancesRegionAndAZMatch;
        }
        if (!instancesAZMatch.isEmpty()) {
            return instancesAZMatch;
        }
        return instancesNoMatch;
    }

    private boolean regionAndAZMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself == null || myself.getDataCenterInfo() == null) {
            return true;
        }
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getDataCenterInfo().getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

