/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.transport.netty.http;

import com.netflix.client.ClientException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class DefaultResponseToErrorPolicy<O>
implements Func2<HttpClientResponse<O>, Integer, Observable<HttpClientResponse<O>>> {
    public Observable<HttpClientResponse<O>> call(HttpClientResponse<O> t1, Integer backoff) {
        if (t1.getStatus().equals((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR)) {
            return Observable.error((Throwable)new ClientException(ClientException.ErrorType.GENERAL));
        }
        if (t1.getStatus().equals((Object)HttpResponseStatus.SERVICE_UNAVAILABLE) || t1.getStatus().equals((Object)HttpResponseStatus.BAD_GATEWAY) || t1.getStatus().equals((Object)HttpResponseStatus.GATEWAY_TIMEOUT)) {
            if (backoff > 0) {
                return Observable.timer((long)backoff.intValue(), (TimeUnit)TimeUnit.MILLISECONDS).concatMap(new Func1<Long, Observable<HttpClientResponse<O>>>(){

                    public Observable<HttpClientResponse<O>> call(Long t1) {
                        return Observable.error((Throwable)new ClientException(ClientException.ErrorType.SERVER_THROTTLED));
                    }
                });
            }
            return Observable.error((Throwable)new ClientException(ClientException.ErrorType.SERVER_THROTTLED));
        }
        return Observable.just(t1);
    }
}

