/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.tag.TagList;
import java.util.concurrent.atomic.AtomicLong;

public final class BasicCounter
extends AbstractMonitor<Number>
implements Counter,
SpectatorMonitor {
    private final MonitorConfig baseConfig;
    private final AtomicLong count = new AtomicLong();
    private final SpectatorContext.LazyCounter spectatorCounter;

    public BasicCounter(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.COUNTER));
        this.baseConfig = config;
        this.spectatorCounter = SpectatorContext.counter(config);
    }

    @Override
    public void increment() {
        this.spectatorCounter.increment();
        this.count.incrementAndGet();
    }

    @Override
    public void increment(long amount) {
        this.spectatorCounter.increment(amount);
        this.count.getAndAdd(amount);
    }

    @Override
    public Number getValue(int pollerIdx) {
        return this.count.get();
    }

    @Override
    public void initializeSpectator(TagList tags) {
        this.spectatorCounter.setId(SpectatorContext.createId(this.baseConfig.withAdditionalTags(tags)));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicCounter)) {
            return false;
        }
        BasicCounter m = (BasicCounter)obj;
        return this.config.equals(m.getConfig()) && this.count.get() == m.count.get();
    }

    public int hashCode() {
        int result = this.config.hashCode();
        long n = this.count.get();
        result = 31 * result + (int)(n ^ n >>> 32);
        return result;
    }

    public String toString() {
        return "BasicCounter{config=" + this.config + ", count=" + this.count.get() + '}';
    }
}

