/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.metric.HystrixCommandStartStream;
import com.netflix.hystrix.metric.consumer.RollingConcurrencyStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RollingCommandMaxConcurrencyStream
extends RollingConcurrencyStream {
    private static final ConcurrentMap<String, RollingCommandMaxConcurrencyStream> streams = new ConcurrentHashMap<String, RollingCommandMaxConcurrencyStream>();

    public static RollingCommandMaxConcurrencyStream getInstance(HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return RollingCommandMaxConcurrencyStream.getInstance(commandKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingCommandMaxConcurrencyStream getInstance(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        RollingCommandMaxConcurrencyStream initialStream = (RollingCommandMaxConcurrencyStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingCommandMaxConcurrencyStream> clazz = RollingCommandMaxConcurrencyStream.class;
        synchronized (RollingCommandMaxConcurrencyStream.class) {
            RollingCommandMaxConcurrencyStream existingStream = (RollingCommandMaxConcurrencyStream)streams.get(commandKey.name());
            if (existingStream == null) {
                RollingCommandMaxConcurrencyStream newStream = new RollingCommandMaxConcurrencyStream(commandKey, numBuckets, bucketSizeInMs);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingCommandMaxConcurrencyStream(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        super(HystrixCommandStartStream.getInstance(commandKey), numBuckets, bucketSizeInMs);
    }
}

