/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.foundation.metrics.meter.AbstractPeriodMeter;
import org.apache.servicecomb.metrics.core.meter.os.CpuMeter;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;

public class OsMeter
extends AbstractPeriodMeter {
    public static final String OS_NAME = "os";
    public static final String OS_TYPE = "type";
    public static final String OS_TYPE_ALL_CPU = "cpu";
    public static final String OS_TYPE_PROCESS_CPU = "processCpu";
    public static final String OS_TYPE_NET = "net";
    private CpuMeter cpuMeter;
    private NetMeter netMeter;

    public OsMeter(Registry registry) {
        this.id = registry.createId(OS_NAME);
        this.cpuMeter = new CpuMeter(this.id);
        this.netMeter = new NetMeter(this.id.withTag(OS_TYPE, OS_TYPE_NET));
    }

    public void calcMeasurements(long msNow, long secondInterval) {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        this.calcMeasurements(measurements, msNow, secondInterval);
        this.allMeasurements = measurements;
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        this.cpuMeter.calcMeasurements(measurements, msNow);
        this.netMeter.calcMeasurements(measurements, msNow, secondInterval);
    }

    @VisibleForTesting
    public CpuMeter getCpuMeter() {
        return this.cpuMeter;
    }

    @VisibleForTesting
    public NetMeter getNetMeter() {
        return this.netMeter;
    }
}

