/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailHealthIndicator
extends AbstractHealthIndicator {
    private final JavaMailSenderImpl mailSender;

    public MailHealthIndicator(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.withDetail("location", this.mailSender.getHost() + ":" + this.mailSender.getPort());
        this.mailSender.testConnection();
        builder.up();
    }
}

