/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorGetMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.actuate.endpoint.mvc.NamePatternFilter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.metrics")
public class MetricsMvcEndpoint
extends EndpointMvcAdapter {
    private final MetricsEndpoint delegate;

    public MetricsMvcEndpoint(MetricsEndpoint delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @ActuatorGetMapping(value={"/{name:.*}"})
    @ResponseBody
    @HypermediaDisabled
    public Object value(@PathVariable String name) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return new NamePatternMapFilter((Map<String, ?>)this.delegate.invoke()).getResults(name);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such metric")
    public static class NoSuchMetricException
    extends RuntimeException {
        public NoSuchMetricException(String string) {
            super(string);
        }
    }

    private class NamePatternMapFilter
    extends NamePatternFilter<Map<String, ?>> {
        NamePatternMapFilter(Map<String, ?> source) {
            super(source);
        }

        @Override
        protected void getNames(Map<String, ?> source, NamePatternFilter.NameCallback callback) {
            for (String name : source.keySet()) {
                try {
                    callback.addName(name);
                }
                catch (NoSuchMetricException noSuchMetricException) {}
            }
        }

        @Override
        protected Object getOptionalValue(Map<String, ?> source, String name) {
            return source.get(name);
        }

        @Override
        protected Object getValue(Map<String, ?> source, String name) {
            Object value = this.getOptionalValue(source, name);
            if (value == null) {
                throw new NoSuchMetricException("No such metric: " + name);
            }
            return value;
        }
    }
}

