/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.springframework.util.StringUtils;

public class InvocationContextItem
implements AccessLogItem<RoutingContext> {
    public static final String NOT_FOUND = "-";
    String varName;

    public InvocationContextItem(String varName) {
        this.varName = varName;
    }

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        String invocationContextValue = this.getValueFromInvocationContext(accessLogParam);
        if (StringUtils.isEmpty((Object)invocationContextValue)) {
            return NOT_FOUND;
        }
        return invocationContextValue;
    }

    protected String getValueFromInvocationContext(AccessLogParam<RoutingContext> accessLogParam) {
        Map data = accessLogParam.getContextData().data();
        if (null == data) {
            return null;
        }
        Invocation invocation = (Invocation)data.get("servicecomb-rest-invocation-context");
        if (null == invocation) {
            return null;
        }
        return invocation.getContext(this.varName);
    }

    public String getVarName() {
        return this.varName;
    }
}

