/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumerBuilder;
import org.apache.rocketmq.client.java.impl.consumer.ConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.SimpleConsumerImpl;

public class SimpleConsumerBuilderImpl
implements SimpleConsumerBuilder {
    private ClientConfiguration clientConfiguration = null;
    private String consumerGroup = null;
    private Map<String, FilterExpression> subscriptionExpressions = new ConcurrentHashMap<String, FilterExpression>();
    private Duration awaitDuration = null;

    public SimpleConsumerBuilder setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = (ClientConfiguration)Preconditions.checkNotNull((Object)clientConfiguration, (Object)"clientConfiguration should not be null");
        return this;
    }

    public SimpleConsumerBuilder setConsumerGroup(String consumerGroup) {
        Preconditions.checkNotNull((Object)consumerGroup, (Object)"consumerGroup should not be null");
        Preconditions.checkArgument((boolean)ConsumerImpl.CONSUMER_GROUP_PATTERN.matcher(consumerGroup).matches(), (String)"consumerGroup does not match the regex [regex=%s]", (Object)ConsumerImpl.CONSUMER_GROUP_PATTERN.pattern());
        this.consumerGroup = consumerGroup;
        return this;
    }

    public SimpleConsumerBuilder setSubscriptionExpressions(Map<String, FilterExpression> subscriptionExpressions) {
        Preconditions.checkNotNull(subscriptionExpressions, (Object)"subscriptionExpressions should not be null");
        Preconditions.checkArgument((!subscriptionExpressions.isEmpty() ? 1 : 0) != 0, (Object)"subscriptionExpressions should not be empty");
        this.subscriptionExpressions = subscriptionExpressions;
        return this;
    }

    public SimpleConsumerBuilder setAwaitDuration(Duration awaitDuration) {
        this.awaitDuration = (Duration)Preconditions.checkNotNull((Object)awaitDuration, (Object)"awaitDuration should not be null");
        return this;
    }

    public SimpleConsumer build() throws ClientException {
        Preconditions.checkNotNull((Object)this.clientConfiguration, (Object)"clientConfiguration has not been set yet");
        Preconditions.checkNotNull((Object)this.consumerGroup, (Object)"consumerGroup has not been set yet");
        Preconditions.checkArgument((!this.subscriptionExpressions.isEmpty() ? 1 : 0) != 0, (Object)"subscriptionExpressions have not been set yet");
        Preconditions.checkNotNull((Object)this.awaitDuration, (Object)"awaitDuration has not been set yet");
        SimpleConsumerImpl consumer = new SimpleConsumerImpl(this.clientConfiguration, this.consumerGroup, this.awaitDuration, this.subscriptionExpressions);
        consumer.startAsync().awaitRunning();
        return consumer;
    }
}

