/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// PublishedDataItemsDataType is the corresponding interface of PublishedDataItemsDataType
type PublishedDataItemsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetPublishedData returns PublishedData (property field)
	GetPublishedData() []PublishedVariableDataType
	// IsPublishedDataItemsDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsPublishedDataItemsDataType()
	// CreateBuilder creates a PublishedDataItemsDataTypeBuilder
	CreatePublishedDataItemsDataTypeBuilder() PublishedDataItemsDataTypeBuilder
}

// _PublishedDataItemsDataType is the data-structure of this message
type _PublishedDataItemsDataType struct {
	ExtensionObjectDefinitionContract
	PublishedData []PublishedVariableDataType
}

var _ PublishedDataItemsDataType = (*_PublishedDataItemsDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_PublishedDataItemsDataType)(nil)

// NewPublishedDataItemsDataType factory function for _PublishedDataItemsDataType
func NewPublishedDataItemsDataType(publishedData []PublishedVariableDataType) *_PublishedDataItemsDataType {
	_result := &_PublishedDataItemsDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		PublishedData:                     publishedData,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// PublishedDataItemsDataTypeBuilder is a builder for PublishedDataItemsDataType
type PublishedDataItemsDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(publishedData []PublishedVariableDataType) PublishedDataItemsDataTypeBuilder
	// WithPublishedData adds PublishedData (property field)
	WithPublishedData(...PublishedVariableDataType) PublishedDataItemsDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the PublishedDataItemsDataType or returns an error if something is wrong
	Build() (PublishedDataItemsDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() PublishedDataItemsDataType
}

// NewPublishedDataItemsDataTypeBuilder() creates a PublishedDataItemsDataTypeBuilder
func NewPublishedDataItemsDataTypeBuilder() PublishedDataItemsDataTypeBuilder {
	return &_PublishedDataItemsDataTypeBuilder{_PublishedDataItemsDataType: new(_PublishedDataItemsDataType)}
}

type _PublishedDataItemsDataTypeBuilder struct {
	*_PublishedDataItemsDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (PublishedDataItemsDataTypeBuilder) = (*_PublishedDataItemsDataTypeBuilder)(nil)

func (b *_PublishedDataItemsDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._PublishedDataItemsDataType
}

func (b *_PublishedDataItemsDataTypeBuilder) WithMandatoryFields(publishedData []PublishedVariableDataType) PublishedDataItemsDataTypeBuilder {
	return b.WithPublishedData(publishedData...)
}

func (b *_PublishedDataItemsDataTypeBuilder) WithPublishedData(publishedData ...PublishedVariableDataType) PublishedDataItemsDataTypeBuilder {
	b.PublishedData = publishedData
	return b
}

func (b *_PublishedDataItemsDataTypeBuilder) Build() (PublishedDataItemsDataType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._PublishedDataItemsDataType.deepCopy(), nil
}

func (b *_PublishedDataItemsDataTypeBuilder) MustBuild() PublishedDataItemsDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_PublishedDataItemsDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_PublishedDataItemsDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_PublishedDataItemsDataTypeBuilder) DeepCopy() any {
	_copy := b.CreatePublishedDataItemsDataTypeBuilder().(*_PublishedDataItemsDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreatePublishedDataItemsDataTypeBuilder creates a PublishedDataItemsDataTypeBuilder
func (b *_PublishedDataItemsDataType) CreatePublishedDataItemsDataTypeBuilder() PublishedDataItemsDataTypeBuilder {
	if b == nil {
		return NewPublishedDataItemsDataTypeBuilder()
	}
	return &_PublishedDataItemsDataTypeBuilder{_PublishedDataItemsDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_PublishedDataItemsDataType) GetExtensionId() int32 {
	return int32(15583)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_PublishedDataItemsDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_PublishedDataItemsDataType) GetPublishedData() []PublishedVariableDataType {
	return m.PublishedData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastPublishedDataItemsDataType(structType any) PublishedDataItemsDataType {
	if casted, ok := structType.(PublishedDataItemsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*PublishedDataItemsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_PublishedDataItemsDataType) GetTypeName() string {
	return "PublishedDataItemsDataType"
}

func (m *_PublishedDataItemsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfPublishedData)
	lengthInBits += 32

	// Array field
	if len(m.PublishedData) > 0 {
		for _curItem, element := range m.PublishedData {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.PublishedData), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_PublishedDataItemsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_PublishedDataItemsDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__publishedDataItemsDataType PublishedDataItemsDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("PublishedDataItemsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for PublishedDataItemsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfPublishedData, err := ReadImplicitField[int32](ctx, "noOfPublishedData", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfPublishedData' field"))
	}
	_ = noOfPublishedData

	publishedData, err := ReadCountArrayField[PublishedVariableDataType](ctx, "publishedData", ReadComplex[PublishedVariableDataType](ExtensionObjectDefinitionParseWithBufferProducer[PublishedVariableDataType]((int32)(int32(14275))), readBuffer), uint64(noOfPublishedData))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishedData' field"))
	}
	m.PublishedData = publishedData

	if closeErr := readBuffer.CloseContext("PublishedDataItemsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for PublishedDataItemsDataType")
	}

	return m, nil
}

func (m *_PublishedDataItemsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_PublishedDataItemsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("PublishedDataItemsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for PublishedDataItemsDataType")
		}
		noOfPublishedData := int32(utils.InlineIf(bool((m.GetPublishedData()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetPublishedData()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfPublishedData", noOfPublishedData, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfPublishedData' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "publishedData", m.GetPublishedData(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'publishedData' field")
		}

		if popErr := writeBuffer.PopContext("PublishedDataItemsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for PublishedDataItemsDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_PublishedDataItemsDataType) IsPublishedDataItemsDataType() {}

func (m *_PublishedDataItemsDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_PublishedDataItemsDataType) deepCopy() *_PublishedDataItemsDataType {
	if m == nil {
		return nil
	}
	_PublishedDataItemsDataTypeCopy := &_PublishedDataItemsDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[PublishedVariableDataType, PublishedVariableDataType](m.PublishedData),
	}
	_PublishedDataItemsDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _PublishedDataItemsDataTypeCopy
}

func (m *_PublishedDataItemsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
