/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableProvisionable is an enum
type OpcuaNodeIdServicesVariableProvisionable int32

type IOpcuaNodeIdServicesVariableProvisionable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size                                                                                            OpcuaNodeIdServicesVariableProvisionable = 16325
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable                                                                                        OpcuaNodeIdServicesVariableProvisionable = 16326
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable                                                                                    OpcuaNodeIdServicesVariableProvisionable = 16327
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount                                                                                       OpcuaNodeIdServicesVariableProvisionable = 16328
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType                                                                                        OpcuaNodeIdServicesVariableProvisionable = 16329
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength                                                                             OpcuaNodeIdServicesVariableProvisionable = 16330
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime                                                                                OpcuaNodeIdServicesVariableProvisionable = 16331
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments                                                                             OpcuaNodeIdServicesVariableProvisionable = 16333
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments                                                                            OpcuaNodeIdServicesVariableProvisionable = 16334
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments                                                                            OpcuaNodeIdServicesVariableProvisionable = 16336
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments                                                                             OpcuaNodeIdServicesVariableProvisionable = 16338
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments                                                                            OpcuaNodeIdServicesVariableProvisionable = 16339
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments                                                                            OpcuaNodeIdServicesVariableProvisionable = 16341
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments                                                                      OpcuaNodeIdServicesVariableProvisionable = 16343
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments                                                                     OpcuaNodeIdServicesVariableProvisionable = 16344
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments                                                                      OpcuaNodeIdServicesVariableProvisionable = 16346
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime                                                                                  OpcuaNodeIdServicesVariableProvisionable = 16347
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion                                                                                  OpcuaNodeIdServicesVariableProvisionable = 16365
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout                                                                                 OpcuaNodeIdServicesVariableProvisionable = 16366
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType                                                                               OpcuaNodeIdServicesVariableProvisionable = 16367
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments                                                                   OpcuaNodeIdServicesVariableProvisionable = 16369
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments                                                                  OpcuaNodeIdServicesVariableProvisionable = 16370
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments                                                                    OpcuaNodeIdServicesVariableProvisionable = 16536
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks                                                                               OpcuaNodeIdServicesVariableProvisionable = 16657
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts                                                                                  OpcuaNodeIdServicesVariableProvisionable = 16658
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris                                                                              OpcuaNodeIdServicesVariableProvisionable = 16659
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes                                                                                  OpcuaNodeIdServicesVariableProvisionable = 16660
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes                                                                                OpcuaNodeIdServicesVariableProvisionable = 16661
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames                                                                                                  OpcuaNodeIdServicesVariableProvisionable = 18664
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions                                                                                              OpcuaNodeIdServicesVariableProvisionable = 18775
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup                                                                                                OpcuaNodeIdServicesVariableProvisionable = 19310
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments                                                                        OpcuaNodeIdServicesVariableProvisionable = 19348
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments                                                                       OpcuaNodeIdServicesVariableProvisionable = 19349
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments                                                                                  OpcuaNodeIdServicesVariableProvisionable = 19351
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose                                                                 OpcuaNodeIdServicesVariableProvisionable = 19733
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose                                                                       OpcuaNodeIdServicesVariableProvisionable = 19734
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose                                                                   OpcuaNodeIdServicesVariableProvisionable = 19735
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints                                                                                    OpcuaNodeIdServicesVariableProvisionable = 19736
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups                                                                            OpcuaNodeIdServicesVariableProvisionable = 19737
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes                                                                        OpcuaNodeIdServicesVariableProvisionable = 19738
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments                                                                    OpcuaNodeIdServicesVariableProvisionable = 19741
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments                                                                   OpcuaNodeIdServicesVariableProvisionable = 19742
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_IsSingleton                                                                                                                                   OpcuaNodeIdServicesVariableProvisionable = 26872
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_RequestTickets_OutputArguments                                                                                                                OpcuaNodeIdServicesVariableProvisionable = 26874
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments                                                                                                          OpcuaNodeIdServicesVariableProvisionable = 26876
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size                                                          OpcuaNodeIdServicesVariableProvisionable = 26882
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable                                                      OpcuaNodeIdServicesVariableProvisionable = 26883
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable                                                  OpcuaNodeIdServicesVariableProvisionable = 26884
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount                                                     OpcuaNodeIdServicesVariableProvisionable = 26885
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType                                                      OpcuaNodeIdServicesVariableProvisionable = 26886
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength                                           OpcuaNodeIdServicesVariableProvisionable = 26887
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime                                              OpcuaNodeIdServicesVariableProvisionable = 26888
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments                                           OpcuaNodeIdServicesVariableProvisionable = 26890
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 26891
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 26893
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments                                           OpcuaNodeIdServicesVariableProvisionable = 26895
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 26896
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 26898
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments                                    OpcuaNodeIdServicesVariableProvisionable = 26900
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 26901
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments                                    OpcuaNodeIdServicesVariableProvisionable = 26903
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime                                                OpcuaNodeIdServicesVariableProvisionable = 26904
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency                                               OpcuaNodeIdServicesVariableProvisionable = 26905
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions                                      OpcuaNodeIdServicesVariableProvisionable = 26906
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 26908
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 26909
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 26911
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments                                OpcuaNodeIdServicesVariableProvisionable = 26912
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 26914
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments                              OpcuaNodeIdServicesVariableProvisionable = 26916
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes                                                        OpcuaNodeIdServicesVariableProvisionable = 26917
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments                                         OpcuaNodeIdServicesVariableProvisionable = 26920
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId                                              OpcuaNodeIdServicesVariableProvisionable = 26922
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType                                            OpcuaNodeIdServicesVariableProvisionable = 26923
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode                                           OpcuaNodeIdServicesVariableProvisionable = 26924
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName                                           OpcuaNodeIdServicesVariableProvisionable = 26925
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time                                                 OpcuaNodeIdServicesVariableProvisionable = 26926
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime                                          OpcuaNodeIdServicesVariableProvisionable = 26927
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime                                            OpcuaNodeIdServicesVariableProvisionable = 26928
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message                                              OpcuaNodeIdServicesVariableProvisionable = 26929
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity                                             OpcuaNodeIdServicesVariableProvisionable = 26930
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId                                     OpcuaNodeIdServicesVariableProvisionable = 26931
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName                                   OpcuaNodeIdServicesVariableProvisionable = 26932
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId                                  OpcuaNodeIdServicesVariableProvisionable = 26933
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName                                OpcuaNodeIdServicesVariableProvisionable = 26934
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName                                        OpcuaNodeIdServicesVariableProvisionable = 26935
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId                                             OpcuaNodeIdServicesVariableProvisionable = 26936
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain                                               OpcuaNodeIdServicesVariableProvisionable = 26937
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState                                         OpcuaNodeIdServicesVariableProvisionable = 26938
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 26939
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 26940
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 26941
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 26942
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 26943
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 26944
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 26945
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 26946
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality                                              OpcuaNodeIdServicesVariableProvisionable = 26947
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableProvisionable = 26948
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity                                         OpcuaNodeIdServicesVariableProvisionable = 26949
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableProvisionable = 26950
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment                                              OpcuaNodeIdServicesVariableProvisionable = 26951
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableProvisionable = 26952
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId                                         OpcuaNodeIdServicesVariableProvisionable = 26953
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments                            OpcuaNodeIdServicesVariableProvisionable = 26957
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState                                           OpcuaNodeIdServicesVariableProvisionable = 26958
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 26959
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 26960
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 26961
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 26962
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 26963
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 26964
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 26965
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 26966
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState                                       OpcuaNodeIdServicesVariableProvisionable = 26967
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableProvisionable = 26968
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableProvisionable = 26969
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number                                OpcuaNodeIdServicesVariableProvisionable = 26970
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableProvisionable = 26971
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableProvisionable = 26972
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableProvisionable = 26973
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableProvisionable = 26974
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableProvisionable = 26975
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableProvisionable = 26977
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments                               OpcuaNodeIdServicesVariableProvisionable = 26979
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState                                          OpcuaNodeIdServicesVariableProvisionable = 26980
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id                                       OpcuaNodeIdServicesVariableProvisionable = 26981
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name                                     OpcuaNodeIdServicesVariableProvisionable = 26982
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number                                   OpcuaNodeIdServicesVariableProvisionable = 26983
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableProvisionable = 26984
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableProvisionable = 26985
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableProvisionable = 26986
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState                                OpcuaNodeIdServicesVariableProvisionable = 26987
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState                               OpcuaNodeIdServicesVariableProvisionable = 26988
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode                                            OpcuaNodeIdServicesVariableProvisionable = 26989
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState                                      OpcuaNodeIdServicesVariableProvisionable = 26990
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id                                   OpcuaNodeIdServicesVariableProvisionable = 26991
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name                                 OpcuaNodeIdServicesVariableProvisionable = 26992
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number                               OpcuaNodeIdServicesVariableProvisionable = 26993
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableProvisionable = 26994
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 26995
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableProvisionable = 26996
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableProvisionable = 26997
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableProvisionable = 26998
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState                                    OpcuaNodeIdServicesVariableProvisionable = 26999
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableProvisionable = 27000
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableProvisionable = 27001
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableProvisionable = 27002
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableProvisionable = 27003
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27004
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableProvisionable = 27005
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableProvisionable = 27006
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableProvisionable = 27007
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableProvisionable = 27009
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableProvisionable = 27010
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableProvisionable = 27011
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableProvisionable = 27012
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableProvisionable = 27013
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableProvisionable = 27014
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableProvisionable = 27015
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableProvisionable = 27016
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableProvisionable = 27017
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableProvisionable = 27018
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableProvisionable = 27019
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableProvisionable = 27020
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableProvisionable = 27021
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableProvisionable = 27022
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableProvisionable = 27024
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableProvisionable = 27026
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableProvisionable = 27029
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableProvisionable = 27032
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableProvisionable = 27033
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved                                       OpcuaNodeIdServicesVariableProvisionable = 27034
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled                                       OpcuaNodeIdServicesVariableProvisionable = 27035
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound                                         OpcuaNodeIdServicesVariableProvisionable = 27036
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableProvisionable = 27037
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableProvisionable = 27038
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableProvisionable = 27039
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState                                         OpcuaNodeIdServicesVariableProvisionable = 27040
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27041
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27042
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27043
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27044
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27045
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27046
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27047
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27048
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay                                              OpcuaNodeIdServicesVariableProvisionable = 27049
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay                                             OpcuaNodeIdServicesVariableProvisionable = 27050
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableProvisionable = 27051
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState                                         OpcuaNodeIdServicesVariableProvisionable = 27053
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27054
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27055
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27056
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27057
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27058
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27059
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27060
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27061
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime                                          OpcuaNodeIdServicesVariableProvisionable = 27062
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableProvisionable = 27063
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27067
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableProvisionable = 27070
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableProvisionable = 27073
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableProvisionable = 27076
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments                                OpcuaNodeIdServicesVariableProvisionable = 27079
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableProvisionable = 27081
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState                                          OpcuaNodeIdServicesVariableProvisionable = 27082
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate                                       OpcuaNodeIdServicesVariableProvisionable = 27083
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit                                      OpcuaNodeIdServicesVariableProvisionable = 27084
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType                                      OpcuaNodeIdServicesVariableProvisionable = 27085
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate                                          OpcuaNodeIdServicesVariableProvisionable = 27086
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId                                              OpcuaNodeIdServicesVariableProvisionable = 27088
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType                                            OpcuaNodeIdServicesVariableProvisionable = 27089
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode                                           OpcuaNodeIdServicesVariableProvisionable = 27090
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName                                           OpcuaNodeIdServicesVariableProvisionable = 27091
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time                                                 OpcuaNodeIdServicesVariableProvisionable = 27092
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime                                          OpcuaNodeIdServicesVariableProvisionable = 27093
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime                                            OpcuaNodeIdServicesVariableProvisionable = 27094
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message                                              OpcuaNodeIdServicesVariableProvisionable = 27095
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity                                             OpcuaNodeIdServicesVariableProvisionable = 27096
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId                                     OpcuaNodeIdServicesVariableProvisionable = 27097
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName                                   OpcuaNodeIdServicesVariableProvisionable = 27098
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId                                  OpcuaNodeIdServicesVariableProvisionable = 27099
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName                                OpcuaNodeIdServicesVariableProvisionable = 27100
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName                                        OpcuaNodeIdServicesVariableProvisionable = 27101
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId                                             OpcuaNodeIdServicesVariableProvisionable = 27102
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain                                               OpcuaNodeIdServicesVariableProvisionable = 27103
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState                                         OpcuaNodeIdServicesVariableProvisionable = 27104
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27105
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27106
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27107
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27108
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27109
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27110
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27111
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27112
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality                                              OpcuaNodeIdServicesVariableProvisionable = 27113
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp                              OpcuaNodeIdServicesVariableProvisionable = 27114
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity                                         OpcuaNodeIdServicesVariableProvisionable = 27115
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                         OpcuaNodeIdServicesVariableProvisionable = 27116
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment                                              OpcuaNodeIdServicesVariableProvisionable = 27117
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp                              OpcuaNodeIdServicesVariableProvisionable = 27118
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId                                         OpcuaNodeIdServicesVariableProvisionable = 27119
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments                            OpcuaNodeIdServicesVariableProvisionable = 27123
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState                                           OpcuaNodeIdServicesVariableProvisionable = 27124
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27125
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27126
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27127
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27128
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27129
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27130
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27131
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27132
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState                                       OpcuaNodeIdServicesVariableProvisionable = 27133
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id                                    OpcuaNodeIdServicesVariableProvisionable = 27134
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name                                  OpcuaNodeIdServicesVariableProvisionable = 27135
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number                                OpcuaNodeIdServicesVariableProvisionable = 27136
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                  OpcuaNodeIdServicesVariableProvisionable = 27137
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                        OpcuaNodeIdServicesVariableProvisionable = 27138
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime               OpcuaNodeIdServicesVariableProvisionable = 27139
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState                             OpcuaNodeIdServicesVariableProvisionable = 27140
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState                            OpcuaNodeIdServicesVariableProvisionable = 27141
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments                           OpcuaNodeIdServicesVariableProvisionable = 27143
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments                               OpcuaNodeIdServicesVariableProvisionable = 27145
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState                                          OpcuaNodeIdServicesVariableProvisionable = 27146
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id                                       OpcuaNodeIdServicesVariableProvisionable = 27147
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name                                     OpcuaNodeIdServicesVariableProvisionable = 27148
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number                                   OpcuaNodeIdServicesVariableProvisionable = 27149
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableProvisionable = 27150
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime                           OpcuaNodeIdServicesVariableProvisionable = 27151
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableProvisionable = 27152
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState                                OpcuaNodeIdServicesVariableProvisionable = 27153
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState                               OpcuaNodeIdServicesVariableProvisionable = 27154
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode                                            OpcuaNodeIdServicesVariableProvisionable = 27155
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState                                      OpcuaNodeIdServicesVariableProvisionable = 27156
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id                                   OpcuaNodeIdServicesVariableProvisionable = 27157
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name                                 OpcuaNodeIdServicesVariableProvisionable = 27158
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number                               OpcuaNodeIdServicesVariableProvisionable = 27159
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableProvisionable = 27160
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27161
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableProvisionable = 27162
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState                            OpcuaNodeIdServicesVariableProvisionable = 27163
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState                           OpcuaNodeIdServicesVariableProvisionable = 27164
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState                                    OpcuaNodeIdServicesVariableProvisionable = 27165
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id                                 OpcuaNodeIdServicesVariableProvisionable = 27166
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name                               OpcuaNodeIdServicesVariableProvisionable = 27167
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number                             OpcuaNodeIdServicesVariableProvisionable = 27168
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName               OpcuaNodeIdServicesVariableProvisionable = 27169
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27170
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime            OpcuaNodeIdServicesVariableProvisionable = 27171
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState                          OpcuaNodeIdServicesVariableProvisionable = 27172
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState                         OpcuaNodeIdServicesVariableProvisionable = 27173
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState                           OpcuaNodeIdServicesVariableProvisionable = 27175
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                        OpcuaNodeIdServicesVariableProvisionable = 27176
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                      OpcuaNodeIdServicesVariableProvisionable = 27177
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                    OpcuaNodeIdServicesVariableProvisionable = 27178
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName      OpcuaNodeIdServicesVariableProvisionable = 27179
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition                         OpcuaNodeIdServicesVariableProvisionable = 27180
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                      OpcuaNodeIdServicesVariableProvisionable = 27181
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                    OpcuaNodeIdServicesVariableProvisionable = 27182
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                  OpcuaNodeIdServicesVariableProvisionable = 27183
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime          OpcuaNodeIdServicesVariableProvisionable = 27184
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime OpcuaNodeIdServicesVariableProvisionable = 27185
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates                        OpcuaNodeIdServicesVariableProvisionable = 27186
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                   OpcuaNodeIdServicesVariableProvisionable = 27187
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                           OpcuaNodeIdServicesVariableProvisionable = 27188
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments             OpcuaNodeIdServicesVariableProvisionable = 27190
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments            OpcuaNodeIdServicesVariableProvisionable = 27192
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments               OpcuaNodeIdServicesVariableProvisionable = 27195
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments          OpcuaNodeIdServicesVariableProvisionable = 27198
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved                                  OpcuaNodeIdServicesVariableProvisionable = 27199
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved                                       OpcuaNodeIdServicesVariableProvisionable = 27200
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled                                       OpcuaNodeIdServicesVariableProvisionable = 27201
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound                                         OpcuaNodeIdServicesVariableProvisionable = 27202
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId                                  OpcuaNodeIdServicesVariableProvisionable = 27203
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId                                OpcuaNodeIdServicesVariableProvisionable = 27204
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId                               OpcuaNodeIdServicesVariableProvisionable = 27205
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState                                         OpcuaNodeIdServicesVariableProvisionable = 27206
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27207
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27208
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27209
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27210
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27211
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27212
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27213
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27214
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay                                              OpcuaNodeIdServicesVariableProvisionable = 27215
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay                                             OpcuaNodeIdServicesVariableProvisionable = 27216
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag                                     OpcuaNodeIdServicesVariableProvisionable = 27217
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState                                         OpcuaNodeIdServicesVariableProvisionable = 27219
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27220
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27221
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27222
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27223
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27224
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27225
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27226
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27227
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime                                          OpcuaNodeIdServicesVariableProvisionable = 27228
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount                                   OpcuaNodeIdServicesVariableProvisionable = 27229
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27233
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments                           OpcuaNodeIdServicesVariableProvisionable = 27236
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                    OpcuaNodeIdServicesVariableProvisionable = 27239
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments                       OpcuaNodeIdServicesVariableProvisionable = 27242
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments                                OpcuaNodeIdServicesVariableProvisionable = 27245
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                  OpcuaNodeIdServicesVariableProvisionable = 27247
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState                                          OpcuaNodeIdServicesVariableProvisionable = 27248
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId                                          OpcuaNodeIdServicesVariableProvisionable = 27249
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime                                       OpcuaNodeIdServicesVariableProvisionable = 27250
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency                                      OpcuaNodeIdServicesVariableProvisionable = 27251
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size                                                                OpcuaNodeIdServicesVariableProvisionable = 27254
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable                                                            OpcuaNodeIdServicesVariableProvisionable = 27255
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable                                                        OpcuaNodeIdServicesVariableProvisionable = 27256
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount                                                           OpcuaNodeIdServicesVariableProvisionable = 27257
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType                                                            OpcuaNodeIdServicesVariableProvisionable = 27258
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength                                                 OpcuaNodeIdServicesVariableProvisionable = 27259
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime                                                    OpcuaNodeIdServicesVariableProvisionable = 27260
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments                                                 OpcuaNodeIdServicesVariableProvisionable = 27262
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments                                                OpcuaNodeIdServicesVariableProvisionable = 27263
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments                                                OpcuaNodeIdServicesVariableProvisionable = 27265
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments                                                 OpcuaNodeIdServicesVariableProvisionable = 27267
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments                                                OpcuaNodeIdServicesVariableProvisionable = 27268
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments                                                OpcuaNodeIdServicesVariableProvisionable = 27270
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 27272
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments                                         OpcuaNodeIdServicesVariableProvisionable = 27273
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments                                          OpcuaNodeIdServicesVariableProvisionable = 27275
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime                                                      OpcuaNodeIdServicesVariableProvisionable = 27276
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency                                                     OpcuaNodeIdServicesVariableProvisionable = 27277
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions                                            OpcuaNodeIdServicesVariableProvisionable = 27278
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments                                        OpcuaNodeIdServicesVariableProvisionable = 27280
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments                                       OpcuaNodeIdServicesVariableProvisionable = 27281
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments                                       OpcuaNodeIdServicesVariableProvisionable = 27283
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments                                      OpcuaNodeIdServicesVariableProvisionable = 27284
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments                                       OpcuaNodeIdServicesVariableProvisionable = 27286
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments                                    OpcuaNodeIdServicesVariableProvisionable = 27288
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes                                                              OpcuaNodeIdServicesVariableProvisionable = 27289
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments                                               OpcuaNodeIdServicesVariableProvisionable = 27292
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId                                                    OpcuaNodeIdServicesVariableProvisionable = 27294
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType                                                  OpcuaNodeIdServicesVariableProvisionable = 27295
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode                                                 OpcuaNodeIdServicesVariableProvisionable = 27296
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName                                                 OpcuaNodeIdServicesVariableProvisionable = 27297
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time                                                       OpcuaNodeIdServicesVariableProvisionable = 27298
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime                                                OpcuaNodeIdServicesVariableProvisionable = 27299
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime                                                  OpcuaNodeIdServicesVariableProvisionable = 27300
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message                                                    OpcuaNodeIdServicesVariableProvisionable = 27301
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity                                                   OpcuaNodeIdServicesVariableProvisionable = 27302
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId                                           OpcuaNodeIdServicesVariableProvisionable = 27303
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName                                         OpcuaNodeIdServicesVariableProvisionable = 27304
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId                                        OpcuaNodeIdServicesVariableProvisionable = 27305
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName                                      OpcuaNodeIdServicesVariableProvisionable = 27306
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName                                              OpcuaNodeIdServicesVariableProvisionable = 27307
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId                                                   OpcuaNodeIdServicesVariableProvisionable = 27308
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain                                                     OpcuaNodeIdServicesVariableProvisionable = 27309
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState                                               OpcuaNodeIdServicesVariableProvisionable = 27310
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27311
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27312
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27313
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27314
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27315
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27316
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27317
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27318
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality                                                    OpcuaNodeIdServicesVariableProvisionable = 27319
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableProvisionable = 27320
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity                                               OpcuaNodeIdServicesVariableProvisionable = 27321
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableProvisionable = 27322
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment                                                    OpcuaNodeIdServicesVariableProvisionable = 27323
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableProvisionable = 27324
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId                                               OpcuaNodeIdServicesVariableProvisionable = 27325
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 27329
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState                                                 OpcuaNodeIdServicesVariableProvisionable = 27330
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id                                              OpcuaNodeIdServicesVariableProvisionable = 27331
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name                                            OpcuaNodeIdServicesVariableProvisionable = 27332
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number                                          OpcuaNodeIdServicesVariableProvisionable = 27333
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableProvisionable = 27334
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableProvisionable = 27335
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableProvisionable = 27336
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState                                       OpcuaNodeIdServicesVariableProvisionable = 27337
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState                                      OpcuaNodeIdServicesVariableProvisionable = 27338
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState                                             OpcuaNodeIdServicesVariableProvisionable = 27339
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableProvisionable = 27340
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableProvisionable = 27341
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableProvisionable = 27342
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableProvisionable = 27343
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableProvisionable = 27344
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27345
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableProvisionable = 27346
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableProvisionable = 27347
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27349
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableProvisionable = 27351
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState                                                OpcuaNodeIdServicesVariableProvisionable = 27352
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id                                             OpcuaNodeIdServicesVariableProvisionable = 27353
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name                                           OpcuaNodeIdServicesVariableProvisionable = 27354
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number                                         OpcuaNodeIdServicesVariableProvisionable = 27355
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableProvisionable = 27356
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableProvisionable = 27357
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableProvisionable = 27358
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableProvisionable = 27359
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableProvisionable = 27360
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode                                                  OpcuaNodeIdServicesVariableProvisionable = 27361
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState                                            OpcuaNodeIdServicesVariableProvisionable = 27362
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id                                         OpcuaNodeIdServicesVariableProvisionable = 27363
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name                                       OpcuaNodeIdServicesVariableProvisionable = 27364
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number                                     OpcuaNodeIdServicesVariableProvisionable = 27365
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableProvisionable = 27366
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableProvisionable = 27367
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableProvisionable = 27368
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableProvisionable = 27369
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableProvisionable = 27370
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState                                          OpcuaNodeIdServicesVariableProvisionable = 27371
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableProvisionable = 27372
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableProvisionable = 27373
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableProvisionable = 27374
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableProvisionable = 27375
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableProvisionable = 27376
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableProvisionable = 27377
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableProvisionable = 27378
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableProvisionable = 27379
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableProvisionable = 27381
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableProvisionable = 27382
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableProvisionable = 27383
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableProvisionable = 27384
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableProvisionable = 27385
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableProvisionable = 27386
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableProvisionable = 27387
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableProvisionable = 27388
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableProvisionable = 27389
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableProvisionable = 27390
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableProvisionable = 27391
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableProvisionable = 27392
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableProvisionable = 27393
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableProvisionable = 27394
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableProvisionable = 27396
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableProvisionable = 27398
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableProvisionable = 27401
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableProvisionable = 27404
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableProvisionable = 27405
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved                                             OpcuaNodeIdServicesVariableProvisionable = 27406
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled                                             OpcuaNodeIdServicesVariableProvisionable = 27407
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound                                               OpcuaNodeIdServicesVariableProvisionable = 27408
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableProvisionable = 27409
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableProvisionable = 27410
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableProvisionable = 27411
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState                                               OpcuaNodeIdServicesVariableProvisionable = 27412
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27413
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27414
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27415
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27416
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27417
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27418
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27419
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27420
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay                                                    OpcuaNodeIdServicesVariableProvisionable = 27421
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay                                                   OpcuaNodeIdServicesVariableProvisionable = 27422
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableProvisionable = 27423
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState                                               OpcuaNodeIdServicesVariableProvisionable = 27425
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27426
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27427
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27428
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27429
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27430
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27431
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27432
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27433
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime                                                OpcuaNodeIdServicesVariableProvisionable = 27434
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableProvisionable = 27435
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 27439
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27442
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableProvisionable = 27445
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27448
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableProvisionable = 27451
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableProvisionable = 27453
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState                                                OpcuaNodeIdServicesVariableProvisionable = 27454
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate                                             OpcuaNodeIdServicesVariableProvisionable = 27455
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit                                            OpcuaNodeIdServicesVariableProvisionable = 27456
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType                                            OpcuaNodeIdServicesVariableProvisionable = 27457
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate                                                OpcuaNodeIdServicesVariableProvisionable = 27458
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId                                                    OpcuaNodeIdServicesVariableProvisionable = 27460
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType                                                  OpcuaNodeIdServicesVariableProvisionable = 27461
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode                                                 OpcuaNodeIdServicesVariableProvisionable = 27462
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName                                                 OpcuaNodeIdServicesVariableProvisionable = 27463
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time                                                       OpcuaNodeIdServicesVariableProvisionable = 27464
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime                                                OpcuaNodeIdServicesVariableProvisionable = 27465
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime                                                  OpcuaNodeIdServicesVariableProvisionable = 27466
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message                                                    OpcuaNodeIdServicesVariableProvisionable = 27467
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity                                                   OpcuaNodeIdServicesVariableProvisionable = 27468
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId                                           OpcuaNodeIdServicesVariableProvisionable = 27469
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName                                         OpcuaNodeIdServicesVariableProvisionable = 27470
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId                                        OpcuaNodeIdServicesVariableProvisionable = 27471
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName                                      OpcuaNodeIdServicesVariableProvisionable = 27472
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName                                              OpcuaNodeIdServicesVariableProvisionable = 27473
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId                                                   OpcuaNodeIdServicesVariableProvisionable = 27474
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain                                                     OpcuaNodeIdServicesVariableProvisionable = 27475
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState                                               OpcuaNodeIdServicesVariableProvisionable = 27476
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27477
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27478
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27479
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27480
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27481
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27482
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27483
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27484
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality                                                    OpcuaNodeIdServicesVariableProvisionable = 27485
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp                                    OpcuaNodeIdServicesVariableProvisionable = 27486
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity                                               OpcuaNodeIdServicesVariableProvisionable = 27487
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                               OpcuaNodeIdServicesVariableProvisionable = 27488
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment                                                    OpcuaNodeIdServicesVariableProvisionable = 27489
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp                                    OpcuaNodeIdServicesVariableProvisionable = 27490
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId                                               OpcuaNodeIdServicesVariableProvisionable = 27491
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 27495
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState                                                 OpcuaNodeIdServicesVariableProvisionable = 27496
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id                                              OpcuaNodeIdServicesVariableProvisionable = 27497
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name                                            OpcuaNodeIdServicesVariableProvisionable = 27498
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number                                          OpcuaNodeIdServicesVariableProvisionable = 27499
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                            OpcuaNodeIdServicesVariableProvisionable = 27500
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime                                  OpcuaNodeIdServicesVariableProvisionable = 27501
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                         OpcuaNodeIdServicesVariableProvisionable = 27502
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState                                       OpcuaNodeIdServicesVariableProvisionable = 27503
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState                                      OpcuaNodeIdServicesVariableProvisionable = 27504
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState                                             OpcuaNodeIdServicesVariableProvisionable = 27505
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id                                          OpcuaNodeIdServicesVariableProvisionable = 27506
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name                                        OpcuaNodeIdServicesVariableProvisionable = 27507
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number                                      OpcuaNodeIdServicesVariableProvisionable = 27508
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableProvisionable = 27509
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                              OpcuaNodeIdServicesVariableProvisionable = 27510
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27511
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState                                   OpcuaNodeIdServicesVariableProvisionable = 27512
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState                                  OpcuaNodeIdServicesVariableProvisionable = 27513
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27515
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments                                     OpcuaNodeIdServicesVariableProvisionable = 27517
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState                                                OpcuaNodeIdServicesVariableProvisionable = 27518
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id                                             OpcuaNodeIdServicesVariableProvisionable = 27519
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name                                           OpcuaNodeIdServicesVariableProvisionable = 27520
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number                                         OpcuaNodeIdServicesVariableProvisionable = 27521
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                           OpcuaNodeIdServicesVariableProvisionable = 27522
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime                                 OpcuaNodeIdServicesVariableProvisionable = 27523
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                        OpcuaNodeIdServicesVariableProvisionable = 27524
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState                                      OpcuaNodeIdServicesVariableProvisionable = 27525
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState                                     OpcuaNodeIdServicesVariableProvisionable = 27526
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode                                                  OpcuaNodeIdServicesVariableProvisionable = 27527
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState                                            OpcuaNodeIdServicesVariableProvisionable = 27528
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id                                         OpcuaNodeIdServicesVariableProvisionable = 27529
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name                                       OpcuaNodeIdServicesVariableProvisionable = 27530
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number                                     OpcuaNodeIdServicesVariableProvisionable = 27531
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableProvisionable = 27532
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime                             OpcuaNodeIdServicesVariableProvisionable = 27533
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableProvisionable = 27534
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState                                  OpcuaNodeIdServicesVariableProvisionable = 27535
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState                                 OpcuaNodeIdServicesVariableProvisionable = 27536
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState                                          OpcuaNodeIdServicesVariableProvisionable = 27537
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id                                       OpcuaNodeIdServicesVariableProvisionable = 27538
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name                                     OpcuaNodeIdServicesVariableProvisionable = 27539
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number                                   OpcuaNodeIdServicesVariableProvisionable = 27540
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                     OpcuaNodeIdServicesVariableProvisionable = 27541
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                           OpcuaNodeIdServicesVariableProvisionable = 27542
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime                  OpcuaNodeIdServicesVariableProvisionable = 27543
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState                                OpcuaNodeIdServicesVariableProvisionable = 27544
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState                               OpcuaNodeIdServicesVariableProvisionable = 27545
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState                                 OpcuaNodeIdServicesVariableProvisionable = 27547
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                              OpcuaNodeIdServicesVariableProvisionable = 27548
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                            OpcuaNodeIdServicesVariableProvisionable = 27549
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                          OpcuaNodeIdServicesVariableProvisionable = 27550
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName            OpcuaNodeIdServicesVariableProvisionable = 27551
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition                               OpcuaNodeIdServicesVariableProvisionable = 27552
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                            OpcuaNodeIdServicesVariableProvisionable = 27553
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                          OpcuaNodeIdServicesVariableProvisionable = 27554
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                        OpcuaNodeIdServicesVariableProvisionable = 27555
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime                OpcuaNodeIdServicesVariableProvisionable = 27556
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime       OpcuaNodeIdServicesVariableProvisionable = 27557
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates                              OpcuaNodeIdServicesVariableProvisionable = 27558
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                         OpcuaNodeIdServicesVariableProvisionable = 27559
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                                 OpcuaNodeIdServicesVariableProvisionable = 27560
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments                   OpcuaNodeIdServicesVariableProvisionable = 27562
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments                  OpcuaNodeIdServicesVariableProvisionable = 27564
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                     OpcuaNodeIdServicesVariableProvisionable = 27567
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments                OpcuaNodeIdServicesVariableProvisionable = 27570
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved                                        OpcuaNodeIdServicesVariableProvisionable = 27571
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved                                             OpcuaNodeIdServicesVariableProvisionable = 27572
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled                                             OpcuaNodeIdServicesVariableProvisionable = 27573
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound                                               OpcuaNodeIdServicesVariableProvisionable = 27574
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId                                        OpcuaNodeIdServicesVariableProvisionable = 27575
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId                                      OpcuaNodeIdServicesVariableProvisionable = 27576
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId                                     OpcuaNodeIdServicesVariableProvisionable = 27577
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState                                               OpcuaNodeIdServicesVariableProvisionable = 27578
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27579
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27580
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27581
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27582
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27583
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27584
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27585
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27586
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay                                                    OpcuaNodeIdServicesVariableProvisionable = 27587
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay                                                   OpcuaNodeIdServicesVariableProvisionable = 27588
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag                                           OpcuaNodeIdServicesVariableProvisionable = 27589
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState                                               OpcuaNodeIdServicesVariableProvisionable = 27591
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id                                            OpcuaNodeIdServicesVariableProvisionable = 27592
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name                                          OpcuaNodeIdServicesVariableProvisionable = 27593
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number                                        OpcuaNodeIdServicesVariableProvisionable = 27594
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                          OpcuaNodeIdServicesVariableProvisionable = 27595
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime                                OpcuaNodeIdServicesVariableProvisionable = 27596
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27597
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState                                     OpcuaNodeIdServicesVariableProvisionable = 27598
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState                                    OpcuaNodeIdServicesVariableProvisionable = 27599
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime                                                OpcuaNodeIdServicesVariableProvisionable = 27600
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount                                         OpcuaNodeIdServicesVariableProvisionable = 27601
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 27605
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27608
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                          OpcuaNodeIdServicesVariableProvisionable = 27611
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27614
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments                                      OpcuaNodeIdServicesVariableProvisionable = 27617
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                        OpcuaNodeIdServicesVariableProvisionable = 27619
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState                                                OpcuaNodeIdServicesVariableProvisionable = 27620
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId                                                OpcuaNodeIdServicesVariableProvisionable = 27621
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime                                             OpcuaNodeIdServicesVariableProvisionable = 27622
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency                                            OpcuaNodeIdServicesVariableProvisionable = 27623
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size                                                            OpcuaNodeIdServicesVariableProvisionable = 27626
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable                                                        OpcuaNodeIdServicesVariableProvisionable = 27627
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable                                                    OpcuaNodeIdServicesVariableProvisionable = 27628
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount                                                       OpcuaNodeIdServicesVariableProvisionable = 27629
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType                                                        OpcuaNodeIdServicesVariableProvisionable = 27630
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength                                             OpcuaNodeIdServicesVariableProvisionable = 27631
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime                                                OpcuaNodeIdServicesVariableProvisionable = 27632
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments                                             OpcuaNodeIdServicesVariableProvisionable = 27634
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments                                            OpcuaNodeIdServicesVariableProvisionable = 27635
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments                                            OpcuaNodeIdServicesVariableProvisionable = 27637
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments                                             OpcuaNodeIdServicesVariableProvisionable = 27639
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments                                            OpcuaNodeIdServicesVariableProvisionable = 27640
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments                                            OpcuaNodeIdServicesVariableProvisionable = 27642
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments                                      OpcuaNodeIdServicesVariableProvisionable = 27644
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments                                     OpcuaNodeIdServicesVariableProvisionable = 27645
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments                                      OpcuaNodeIdServicesVariableProvisionable = 27647
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime                                                  OpcuaNodeIdServicesVariableProvisionable = 27648
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency                                                 OpcuaNodeIdServicesVariableProvisionable = 27649
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions                                        OpcuaNodeIdServicesVariableProvisionable = 27650
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments                                    OpcuaNodeIdServicesVariableProvisionable = 27652
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 27653
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 27655
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 27656
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments                                   OpcuaNodeIdServicesVariableProvisionable = 27658
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments                                OpcuaNodeIdServicesVariableProvisionable = 27660
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes                                                          OpcuaNodeIdServicesVariableProvisionable = 27661
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments                                           OpcuaNodeIdServicesVariableProvisionable = 27664
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId                                                OpcuaNodeIdServicesVariableProvisionable = 27666
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType                                              OpcuaNodeIdServicesVariableProvisionable = 27667
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode                                             OpcuaNodeIdServicesVariableProvisionable = 27668
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName                                             OpcuaNodeIdServicesVariableProvisionable = 27669
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time                                                   OpcuaNodeIdServicesVariableProvisionable = 27670
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime                                            OpcuaNodeIdServicesVariableProvisionable = 27671
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime                                              OpcuaNodeIdServicesVariableProvisionable = 27672
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message                                                OpcuaNodeIdServicesVariableProvisionable = 27673
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity                                               OpcuaNodeIdServicesVariableProvisionable = 27674
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId                                       OpcuaNodeIdServicesVariableProvisionable = 27675
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName                                     OpcuaNodeIdServicesVariableProvisionable = 27676
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId                                    OpcuaNodeIdServicesVariableProvisionable = 27677
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName                                  OpcuaNodeIdServicesVariableProvisionable = 27678
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName                                          OpcuaNodeIdServicesVariableProvisionable = 27679
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId                                               OpcuaNodeIdServicesVariableProvisionable = 27680
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain                                                 OpcuaNodeIdServicesVariableProvisionable = 27681
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState                                           OpcuaNodeIdServicesVariableProvisionable = 27682
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27683
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27684
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27685
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27686
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27687
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27688
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27689
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27690
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality                                                OpcuaNodeIdServicesVariableProvisionable = 27691
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableProvisionable = 27692
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity                                           OpcuaNodeIdServicesVariableProvisionable = 27693
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableProvisionable = 27694
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment                                                OpcuaNodeIdServicesVariableProvisionable = 27695
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableProvisionable = 27696
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId                                           OpcuaNodeIdServicesVariableProvisionable = 27697
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments                              OpcuaNodeIdServicesVariableProvisionable = 27701
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState                                             OpcuaNodeIdServicesVariableProvisionable = 27702
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id                                          OpcuaNodeIdServicesVariableProvisionable = 27703
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name                                        OpcuaNodeIdServicesVariableProvisionable = 27704
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number                                      OpcuaNodeIdServicesVariableProvisionable = 27705
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableProvisionable = 27706
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableProvisionable = 27707
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27708
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState                                   OpcuaNodeIdServicesVariableProvisionable = 27709
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState                                  OpcuaNodeIdServicesVariableProvisionable = 27710
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState                                         OpcuaNodeIdServicesVariableProvisionable = 27711
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27712
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27713
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27714
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27715
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27716
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27717
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27718
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27719
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27721
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27723
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState                                            OpcuaNodeIdServicesVariableProvisionable = 27724
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id                                         OpcuaNodeIdServicesVariableProvisionable = 27725
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name                                       OpcuaNodeIdServicesVariableProvisionable = 27726
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number                                     OpcuaNodeIdServicesVariableProvisionable = 27727
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableProvisionable = 27728
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableProvisionable = 27729
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableProvisionable = 27730
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableProvisionable = 27731
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableProvisionable = 27732
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode                                              OpcuaNodeIdServicesVariableProvisionable = 27733
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState                                        OpcuaNodeIdServicesVariableProvisionable = 27734
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id                                     OpcuaNodeIdServicesVariableProvisionable = 27735
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name                                   OpcuaNodeIdServicesVariableProvisionable = 27736
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number                                 OpcuaNodeIdServicesVariableProvisionable = 27737
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableProvisionable = 27738
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableProvisionable = 27739
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableProvisionable = 27740
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableProvisionable = 27741
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableProvisionable = 27742
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState                                      OpcuaNodeIdServicesVariableProvisionable = 27743
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableProvisionable = 27744
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableProvisionable = 27745
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableProvisionable = 27746
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableProvisionable = 27747
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27748
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableProvisionable = 27749
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableProvisionable = 27750
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableProvisionable = 27751
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableProvisionable = 27753
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableProvisionable = 27754
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableProvisionable = 27755
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableProvisionable = 27756
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableProvisionable = 27757
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableProvisionable = 27758
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableProvisionable = 27759
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableProvisionable = 27760
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableProvisionable = 27761
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableProvisionable = 27762
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableProvisionable = 27763
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableProvisionable = 27764
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableProvisionable = 27765
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableProvisionable = 27766
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableProvisionable = 27768
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableProvisionable = 27770
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableProvisionable = 27773
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableProvisionable = 27776
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableProvisionable = 27777
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved                                         OpcuaNodeIdServicesVariableProvisionable = 27778
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled                                         OpcuaNodeIdServicesVariableProvisionable = 27779
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound                                           OpcuaNodeIdServicesVariableProvisionable = 27780
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableProvisionable = 27781
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableProvisionable = 27782
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableProvisionable = 27783
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState                                           OpcuaNodeIdServicesVariableProvisionable = 27784
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27785
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27786
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27787
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27788
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27789
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27790
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27791
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27792
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay                                                OpcuaNodeIdServicesVariableProvisionable = 27793
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay                                               OpcuaNodeIdServicesVariableProvisionable = 27794
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableProvisionable = 27795
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState                                           OpcuaNodeIdServicesVariableProvisionable = 27797
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27798
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27799
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27800
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27801
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27802
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27803
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27804
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27805
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime                                            OpcuaNodeIdServicesVariableProvisionable = 27806
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableProvisionable = 27807
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableProvisionable = 27811
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27814
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableProvisionable = 27817
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableProvisionable = 27820
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 27823
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableProvisionable = 27825
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState                                            OpcuaNodeIdServicesVariableProvisionable = 27826
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate                                         OpcuaNodeIdServicesVariableProvisionable = 27827
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit                                        OpcuaNodeIdServicesVariableProvisionable = 27828
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType                                        OpcuaNodeIdServicesVariableProvisionable = 27829
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate                                            OpcuaNodeIdServicesVariableProvisionable = 27830
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId                                                OpcuaNodeIdServicesVariableProvisionable = 27832
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType                                              OpcuaNodeIdServicesVariableProvisionable = 27833
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode                                             OpcuaNodeIdServicesVariableProvisionable = 27834
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName                                             OpcuaNodeIdServicesVariableProvisionable = 27835
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time                                                   OpcuaNodeIdServicesVariableProvisionable = 27836
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime                                            OpcuaNodeIdServicesVariableProvisionable = 27837
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime                                              OpcuaNodeIdServicesVariableProvisionable = 27838
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message                                                OpcuaNodeIdServicesVariableProvisionable = 27839
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity                                               OpcuaNodeIdServicesVariableProvisionable = 27840
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId                                       OpcuaNodeIdServicesVariableProvisionable = 27841
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName                                     OpcuaNodeIdServicesVariableProvisionable = 27842
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId                                    OpcuaNodeIdServicesVariableProvisionable = 27843
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName                                  OpcuaNodeIdServicesVariableProvisionable = 27844
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName                                          OpcuaNodeIdServicesVariableProvisionable = 27845
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId                                               OpcuaNodeIdServicesVariableProvisionable = 27846
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain                                                 OpcuaNodeIdServicesVariableProvisionable = 27847
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState                                           OpcuaNodeIdServicesVariableProvisionable = 27848
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27849
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27850
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27851
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27852
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27853
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27854
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27855
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27856
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality                                                OpcuaNodeIdServicesVariableProvisionable = 27857
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp                                OpcuaNodeIdServicesVariableProvisionable = 27858
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity                                           OpcuaNodeIdServicesVariableProvisionable = 27859
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp                           OpcuaNodeIdServicesVariableProvisionable = 27860
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment                                                OpcuaNodeIdServicesVariableProvisionable = 27861
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp                                OpcuaNodeIdServicesVariableProvisionable = 27862
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId                                           OpcuaNodeIdServicesVariableProvisionable = 27863
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments                              OpcuaNodeIdServicesVariableProvisionable = 27867
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState                                             OpcuaNodeIdServicesVariableProvisionable = 27868
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id                                          OpcuaNodeIdServicesVariableProvisionable = 27869
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name                                        OpcuaNodeIdServicesVariableProvisionable = 27870
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number                                      OpcuaNodeIdServicesVariableProvisionable = 27871
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName                        OpcuaNodeIdServicesVariableProvisionable = 27872
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime                              OpcuaNodeIdServicesVariableProvisionable = 27873
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime                     OpcuaNodeIdServicesVariableProvisionable = 27874
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState                                   OpcuaNodeIdServicesVariableProvisionable = 27875
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState                                  OpcuaNodeIdServicesVariableProvisionable = 27876
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState                                         OpcuaNodeIdServicesVariableProvisionable = 27877
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id                                      OpcuaNodeIdServicesVariableProvisionable = 27878
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name                                    OpcuaNodeIdServicesVariableProvisionable = 27879
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number                                  OpcuaNodeIdServicesVariableProvisionable = 27880
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName                    OpcuaNodeIdServicesVariableProvisionable = 27881
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime                          OpcuaNodeIdServicesVariableProvisionable = 27882
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime                 OpcuaNodeIdServicesVariableProvisionable = 27883
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState                               OpcuaNodeIdServicesVariableProvisionable = 27884
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState                              OpcuaNodeIdServicesVariableProvisionable = 27885
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27887
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments                                 OpcuaNodeIdServicesVariableProvisionable = 27889
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState                                            OpcuaNodeIdServicesVariableProvisionable = 27890
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id                                         OpcuaNodeIdServicesVariableProvisionable = 27891
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name                                       OpcuaNodeIdServicesVariableProvisionable = 27892
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number                                     OpcuaNodeIdServicesVariableProvisionable = 27893
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName                       OpcuaNodeIdServicesVariableProvisionable = 27894
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime                             OpcuaNodeIdServicesVariableProvisionable = 27895
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime                    OpcuaNodeIdServicesVariableProvisionable = 27896
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState                                  OpcuaNodeIdServicesVariableProvisionable = 27897
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState                                 OpcuaNodeIdServicesVariableProvisionable = 27898
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode                                              OpcuaNodeIdServicesVariableProvisionable = 27899
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState                                        OpcuaNodeIdServicesVariableProvisionable = 27900
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id                                     OpcuaNodeIdServicesVariableProvisionable = 27901
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name                                   OpcuaNodeIdServicesVariableProvisionable = 27902
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number                                 OpcuaNodeIdServicesVariableProvisionable = 27903
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName                   OpcuaNodeIdServicesVariableProvisionable = 27904
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime                         OpcuaNodeIdServicesVariableProvisionable = 27905
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime                OpcuaNodeIdServicesVariableProvisionable = 27906
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState                              OpcuaNodeIdServicesVariableProvisionable = 27907
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState                             OpcuaNodeIdServicesVariableProvisionable = 27908
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState                                      OpcuaNodeIdServicesVariableProvisionable = 27909
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id                                   OpcuaNodeIdServicesVariableProvisionable = 27910
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name                                 OpcuaNodeIdServicesVariableProvisionable = 27911
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number                               OpcuaNodeIdServicesVariableProvisionable = 27912
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName                 OpcuaNodeIdServicesVariableProvisionable = 27913
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime                       OpcuaNodeIdServicesVariableProvisionable = 27914
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime              OpcuaNodeIdServicesVariableProvisionable = 27915
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState                            OpcuaNodeIdServicesVariableProvisionable = 27916
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState                           OpcuaNodeIdServicesVariableProvisionable = 27917
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState                             OpcuaNodeIdServicesVariableProvisionable = 27919
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id                          OpcuaNodeIdServicesVariableProvisionable = 27920
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name                        OpcuaNodeIdServicesVariableProvisionable = 27921
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number                      OpcuaNodeIdServicesVariableProvisionable = 27922
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName        OpcuaNodeIdServicesVariableProvisionable = 27923
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition                           OpcuaNodeIdServicesVariableProvisionable = 27924
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id                        OpcuaNodeIdServicesVariableProvisionable = 27925
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name                      OpcuaNodeIdServicesVariableProvisionable = 27926
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number                    OpcuaNodeIdServicesVariableProvisionable = 27927
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime            OpcuaNodeIdServicesVariableProvisionable = 27928
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime   OpcuaNodeIdServicesVariableProvisionable = 27929
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates                          OpcuaNodeIdServicesVariableProvisionable = 27930
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions                     OpcuaNodeIdServicesVariableProvisionable = 27931
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime                             OpcuaNodeIdServicesVariableProvisionable = 27932
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments               OpcuaNodeIdServicesVariableProvisionable = 27934
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments              OpcuaNodeIdServicesVariableProvisionable = 27936
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments                 OpcuaNodeIdServicesVariableProvisionable = 27939
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments            OpcuaNodeIdServicesVariableProvisionable = 27942
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved                                    OpcuaNodeIdServicesVariableProvisionable = 27943
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved                                         OpcuaNodeIdServicesVariableProvisionable = 27944
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled                                         OpcuaNodeIdServicesVariableProvisionable = 27945
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound                                           OpcuaNodeIdServicesVariableProvisionable = 27946
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId                                    OpcuaNodeIdServicesVariableProvisionable = 27947
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId                                  OpcuaNodeIdServicesVariableProvisionable = 27948
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId                                 OpcuaNodeIdServicesVariableProvisionable = 27949
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState                                           OpcuaNodeIdServicesVariableProvisionable = 27950
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27951
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27952
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27953
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27954
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27955
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27956
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27957
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27958
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay                                                OpcuaNodeIdServicesVariableProvisionable = 27959
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay                                               OpcuaNodeIdServicesVariableProvisionable = 27960
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag                                       OpcuaNodeIdServicesVariableProvisionable = 27961
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState                                           OpcuaNodeIdServicesVariableProvisionable = 27963
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id                                        OpcuaNodeIdServicesVariableProvisionable = 27964
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name                                      OpcuaNodeIdServicesVariableProvisionable = 27965
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number                                    OpcuaNodeIdServicesVariableProvisionable = 27966
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName                      OpcuaNodeIdServicesVariableProvisionable = 27967
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime                            OpcuaNodeIdServicesVariableProvisionable = 27968
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime                   OpcuaNodeIdServicesVariableProvisionable = 27969
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState                                 OpcuaNodeIdServicesVariableProvisionable = 27970
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState                                OpcuaNodeIdServicesVariableProvisionable = 27971
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime                                            OpcuaNodeIdServicesVariableProvisionable = 27972
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount                                     OpcuaNodeIdServicesVariableProvisionable = 27973
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments                               OpcuaNodeIdServicesVariableProvisionable = 27977
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments                             OpcuaNodeIdServicesVariableProvisionable = 27980
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments                      OpcuaNodeIdServicesVariableProvisionable = 27983
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments                         OpcuaNodeIdServicesVariableProvisionable = 27986
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments                                  OpcuaNodeIdServicesVariableProvisionable = 27989
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments                    OpcuaNodeIdServicesVariableProvisionable = 27991
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState                                            OpcuaNodeIdServicesVariableProvisionable = 27992
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId                                            OpcuaNodeIdServicesVariableProvisionable = 27993
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime                                         OpcuaNodeIdServicesVariableProvisionable = 27994
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency                                        OpcuaNodeIdServicesVariableProvisionable = 27995
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_Enabled                                                                                                           OpcuaNodeIdServicesVariableProvisionable = 27996
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri                                                                                                    OpcuaNodeIdServicesVariableProvisionable = 27997
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri                                                                                                        OpcuaNodeIdServicesVariableProvisionable = 27998
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType                                                                                                   OpcuaNodeIdServicesVariableProvisionable = 27999
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities                                                                                                OpcuaNodeIdServicesVariableProvisionable = 28000
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats                                                                                        OpcuaNodeIdServicesVariableProvisionable = 28001
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize                                                                                                  OpcuaNodeIdServicesVariableProvisionable = 28002
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled                                                                                               OpcuaNodeIdServicesVariableProvisionable = 28003
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_HasSecureElement                                                                                                  OpcuaNodeIdServicesVariableProvisionable = 28004
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments                                                                                  OpcuaNodeIdServicesVariableProvisionable = 28006
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments                                                                                 OpcuaNodeIdServicesVariableProvisionable = 28007
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments                                                                               OpcuaNodeIdServicesVariableProvisionable = 28011
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments                                                                              OpcuaNodeIdServicesVariableProvisionable = 28012
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments                                                                                   OpcuaNodeIdServicesVariableProvisionable = 28014
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_IsSingleton                                                                                                                                       OpcuaNodeIdServicesVariableProvisionable = 29879
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_RequestTickets_OutputArguments                                                                                                                    OpcuaNodeIdServicesVariableProvisionable = 29881
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_SetRegistrarEndpoints_InputArguments                                                                                                              OpcuaNodeIdServicesVariableProvisionable = 29883
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout                                               OpcuaNodeIdServicesVariableProvisionable = 32356
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout                                                     OpcuaNodeIdServicesVariableProvisionable = 32357
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout                                                 OpcuaNodeIdServicesVariableProvisionable = 32358
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments                                                                                    OpcuaNodeIdServicesVariableProvisionable = 32360
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments                                                                                   OpcuaNodeIdServicesVariableProvisionable = 32361
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime                                                                                  OpcuaNodeIdServicesVariableProvisionable = 32363
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime                                                                                    OpcuaNodeIdServicesVariableProvisionable = 32364
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result                                                                                     OpcuaNodeIdServicesVariableProvisionable = 32365
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists                                                                         OpcuaNodeIdServicesVariableProvisionable = 32366
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups                                                                  OpcuaNodeIdServicesVariableProvisionable = 32367
	OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors                                                                                     OpcuaNodeIdServicesVariableProvisionable = 32368
)

var OpcuaNodeIdServicesVariableProvisionableValues []OpcuaNodeIdServicesVariableProvisionable

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableProvisionableValues = []OpcuaNodeIdServicesVariableProvisionable{
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_IsSingleton,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_RequestTickets_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_Enabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_HasSecureElement,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_IsSingleton,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_RequestTickets_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_SetRegistrarEndpoints_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups,
		OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors,
	}
}

func OpcuaNodeIdServicesVariableProvisionableByValue(value int32) (enum OpcuaNodeIdServicesVariableProvisionable, ok bool) {
	switch value {
	case 16325:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size, true
	case 16326:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable, true
	case 16327:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable, true
	case 16328:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount, true
	case 16329:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType, true
	case 16330:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength, true
	case 16331:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime, true
	case 16333:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments, true
	case 16334:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments, true
	case 16336:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments, true
	case 16338:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments, true
	case 16339:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments, true
	case 16341:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments, true
	case 16343:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments, true
	case 16344:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments, true
	case 16346:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments, true
	case 16347:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime, true
	case 16365:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion, true
	case 16366:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout, true
	case 16367:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType, true
	case 16369:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments, true
	case 16370:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments, true
	case 16536:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments, true
	case 16657:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks, true
	case 16658:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts, true
	case 16659:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris, true
	case 16660:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes, true
	case 16661:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes, true
	case 18664:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames, true
	case 18775:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions, true
	case 19310:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup, true
	case 19348:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments, true
	case 19349:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments, true
	case 19351:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments, true
	case 19733:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose, true
	case 19734:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose, true
	case 19735:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose, true
	case 19736:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints, true
	case 19737:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups, true
	case 19738:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes, true
	case 19741:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments, true
	case 19742:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments, true
	case 26872:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_IsSingleton, true
	case 26874:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_RequestTickets_OutputArguments, true
	case 26876:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments, true
	case 26882:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case 26883:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case 26884:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case 26885:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case 26886:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case 26887:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength, true
	case 26888:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime, true
	case 26890:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case 26891:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case 26893:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case 26895:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case 26896:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case 26898:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case 26900:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case 26901:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case 26903:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case 26904:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case 26905:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case 26906:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions, true
	case 26908:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case 26909:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 26911:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 26912:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 26914:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case 26916:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case 26917:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case 26920:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments, true
	case 26922:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case 26923:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case 26924:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case 26925:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case 26926:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case 26927:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case 26928:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case 26929:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case 26930:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case 26931:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case 26932:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case 26933:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case 26934:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case 26935:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case 26936:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case 26937:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case 26938:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case 26939:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case 26940:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case 26941:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case 26942:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 26943:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 26944:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 26945:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case 26946:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case 26947:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case 26948:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 26949:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case 26950:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 26951:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case 26952:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 26953:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case 26957:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case 26958:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case 26959:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case 26960:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case 26961:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case 26962:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 26963:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case 26964:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 26965:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case 26966:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case 26967:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case 26968:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case 26969:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case 26970:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case 26971:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 26972:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 26973:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 26974:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 26975:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 26977:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 26979:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case 26980:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case 26981:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case 26982:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case 26983:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case 26984:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 26985:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 26986:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 26987:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case 26988:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case 26989:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case 26990:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case 26991:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case 26992:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case 26993:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case 26994:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 26995:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 26996:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 26997:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case 26998:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case 26999:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case 27000:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case 27001:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case 27002:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case 27003:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 27004:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 27005:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 27006:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 27007:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 27009:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 27010:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 27011:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 27012:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 27013:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27014:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 27015:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 27016:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 27017:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 27018:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 27019:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27020:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 27021:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 27022:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 27024:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 27026:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 27029:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 27032:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 27033:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case 27034:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case 27035:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case 27036:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case 27037:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case 27038:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 27039:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case 27040:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case 27041:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case 27042:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case 27043:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case 27044:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 27045:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 27046:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 27047:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case 27048:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case 27049:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case 27050:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case 27051:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case 27053:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case 27054:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case 27055:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case 27056:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case 27057:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 27058:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 27059:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 27060:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case 27061:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case 27062:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case 27063:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 27067:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments, true
	case 27070:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 27073:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 27076:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 27079:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments, true
	case 27081:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 27082:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case 27083:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case 27084:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case 27085:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case 27086:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case 27088:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case 27089:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case 27090:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case 27091:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case 27092:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case 27093:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case 27094:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case 27095:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case 27096:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case 27097:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case 27098:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case 27099:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 27100:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 27101:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case 27102:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case 27103:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case 27104:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case 27105:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case 27106:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case 27107:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case 27108:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 27109:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 27110:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 27111:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 27112:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 27113:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case 27114:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 27115:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case 27116:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 27117:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case 27118:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 27119:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case 27123:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 27124:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case 27125:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case 27126:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case 27127:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case 27128:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 27129:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 27130:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 27131:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 27132:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 27133:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case 27134:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 27135:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 27136:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 27137:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 27138:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 27139:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 27140:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 27141:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 27143:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 27145:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 27146:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case 27147:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case 27148:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case 27149:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case 27150:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 27151:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 27152:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 27153:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 27154:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 27155:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case 27156:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case 27157:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 27158:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 27159:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 27160:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 27161:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 27162:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 27163:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 27164:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 27165:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case 27166:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 27167:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 27168:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 27169:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 27170:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 27171:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 27172:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 27173:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 27175:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 27176:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 27177:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 27178:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 27179:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27180:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 27181:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 27182:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 27183:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 27184:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 27185:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27186:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 27187:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 27188:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 27190:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 27192:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 27195:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 27198:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 27199:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 27200:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 27201:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case 27202:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case 27203:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 27204:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 27205:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 27206:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case 27207:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case 27208:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case 27209:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case 27210:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 27211:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 27212:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 27213:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 27214:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 27215:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case 27216:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case 27217:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 27219:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case 27220:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case 27221:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case 27222:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case 27223:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 27224:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 27225:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 27226:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 27227:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 27228:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case 27229:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 27233:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 27236:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 27239:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 27242:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 27245:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 27247:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 27248:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case 27249:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case 27250:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case 27251:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case 27254:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case 27255:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case 27256:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case 27257:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case 27258:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case 27259:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength, true
	case 27260:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime, true
	case 27262:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case 27263:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case 27265:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case 27267:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case 27268:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case 27270:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case 27272:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case 27273:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case 27275:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case 27276:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case 27277:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case 27278:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions, true
	case 27280:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case 27281:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 27283:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 27284:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 27286:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case 27288:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case 27289:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case 27292:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments, true
	case 27294:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case 27295:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case 27296:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case 27297:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case 27298:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case 27299:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case 27300:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case 27301:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case 27302:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case 27303:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case 27304:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case 27305:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case 27306:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case 27307:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case 27308:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case 27309:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case 27310:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case 27311:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case 27312:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case 27313:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case 27314:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 27315:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 27316:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 27317:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case 27318:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case 27319:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case 27320:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 27321:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case 27322:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 27323:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case 27324:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 27325:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case 27329:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case 27330:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case 27331:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case 27332:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case 27333:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case 27334:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 27335:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case 27336:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 27337:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case 27338:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case 27339:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case 27340:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case 27341:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case 27342:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case 27343:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 27344:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 27345:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 27346:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 27347:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 27349:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 27351:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case 27352:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case 27353:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case 27354:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case 27355:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case 27356:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 27357:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 27358:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 27359:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case 27360:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case 27361:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case 27362:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case 27363:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case 27364:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case 27365:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case 27366:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 27367:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 27368:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 27369:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case 27370:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case 27371:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case 27372:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case 27373:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case 27374:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case 27375:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 27376:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 27377:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 27378:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 27379:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 27381:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 27382:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 27383:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 27384:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 27385:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27386:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 27387:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 27388:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 27389:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 27390:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 27391:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27392:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 27393:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 27394:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 27396:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 27398:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 27401:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 27404:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 27405:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case 27406:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case 27407:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case 27408:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case 27409:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case 27410:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 27411:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case 27412:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case 27413:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case 27414:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case 27415:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case 27416:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 27417:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 27418:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 27419:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case 27420:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case 27421:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case 27422:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case 27423:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case 27425:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case 27426:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case 27427:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case 27428:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case 27429:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 27430:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 27431:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 27432:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case 27433:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case 27434:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case 27435:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 27439:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments, true
	case 27442:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 27445:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 27448:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 27451:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments, true
	case 27453:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 27454:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case 27455:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case 27456:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case 27457:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case 27458:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case 27460:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case 27461:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case 27462:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case 27463:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case 27464:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case 27465:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case 27466:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case 27467:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case 27468:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case 27469:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case 27470:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case 27471:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 27472:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 27473:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case 27474:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case 27475:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case 27476:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case 27477:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case 27478:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case 27479:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case 27480:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 27481:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 27482:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 27483:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 27484:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 27485:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case 27486:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 27487:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case 27488:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 27489:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case 27490:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 27491:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case 27495:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 27496:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case 27497:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case 27498:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case 27499:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case 27500:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 27501:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 27502:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 27503:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 27504:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 27505:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case 27506:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 27507:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 27508:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 27509:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 27510:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 27511:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 27512:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 27513:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 27515:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 27517:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 27518:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case 27519:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case 27520:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case 27521:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case 27522:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 27523:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 27524:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 27525:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 27526:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 27527:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case 27528:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case 27529:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 27530:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 27531:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 27532:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 27533:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 27534:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 27535:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 27536:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 27537:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case 27538:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 27539:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 27540:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 27541:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 27542:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 27543:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 27544:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 27545:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 27547:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 27548:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 27549:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 27550:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 27551:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27552:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 27553:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 27554:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 27555:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 27556:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 27557:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27558:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 27559:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 27560:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 27562:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 27564:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 27567:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 27570:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 27571:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 27572:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 27573:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case 27574:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case 27575:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 27576:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 27577:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 27578:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case 27579:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case 27580:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case 27581:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case 27582:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 27583:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 27584:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 27585:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 27586:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 27587:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case 27588:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case 27589:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 27591:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case 27592:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case 27593:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case 27594:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case 27595:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 27596:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 27597:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 27598:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 27599:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 27600:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case 27601:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 27605:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 27608:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 27611:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 27614:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 27617:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 27619:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 27620:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case 27621:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case 27622:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case 27623:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case 27626:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case 27627:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case 27628:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case 27629:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case 27630:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case 27631:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength, true
	case 27632:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime, true
	case 27634:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case 27635:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case 27637:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case 27639:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case 27640:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case 27642:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case 27644:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case 27645:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case 27647:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case 27648:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case 27649:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case 27650:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions, true
	case 27652:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case 27653:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case 27655:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case 27656:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case 27658:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case 27660:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case 27661:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case 27664:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments, true
	case 27666:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case 27667:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case 27668:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case 27669:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case 27670:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case 27671:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case 27672:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case 27673:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case 27674:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case 27675:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case 27676:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case 27677:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case 27678:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case 27679:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case 27680:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case 27681:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case 27682:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case 27683:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case 27684:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case 27685:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case 27686:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case 27687:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case 27688:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case 27689:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case 27690:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case 27691:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case 27692:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case 27693:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case 27694:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case 27695:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case 27696:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case 27697:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case 27701:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case 27702:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case 27703:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case 27704:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case 27705:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case 27706:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case 27707:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case 27708:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case 27709:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case 27710:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case 27711:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case 27712:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case 27713:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case 27714:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case 27715:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case 27716:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case 27717:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case 27718:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case 27719:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case 27721:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case 27723:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case 27724:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case 27725:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case 27726:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case 27727:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case 27728:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case 27729:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case 27730:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case 27731:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case 27732:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case 27733:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case 27734:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case 27735:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case 27736:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case 27737:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case 27738:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case 27739:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case 27740:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case 27741:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case 27742:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case 27743:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case 27744:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case 27745:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case 27746:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case 27747:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case 27748:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case 27749:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case 27750:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case 27751:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case 27753:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case 27754:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case 27755:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case 27756:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case 27757:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27758:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case 27759:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case 27760:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case 27761:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case 27762:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case 27763:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27764:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case 27765:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case 27766:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case 27768:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case 27770:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case 27773:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case 27776:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case 27777:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case 27778:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case 27779:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case 27780:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case 27781:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case 27782:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case 27783:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case 27784:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case 27785:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case 27786:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case 27787:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case 27788:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case 27789:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case 27790:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case 27791:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case 27792:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case 27793:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case 27794:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case 27795:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case 27797:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case 27798:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case 27799:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case 27800:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case 27801:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case 27802:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case 27803:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case 27804:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case 27805:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case 27806:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case 27807:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case 27811:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments, true
	case 27814:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case 27817:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case 27820:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case 27823:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments, true
	case 27825:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case 27826:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case 27827:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case 27828:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case 27829:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case 27830:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case 27832:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case 27833:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case 27834:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case 27835:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case 27836:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case 27837:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case 27838:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case 27839:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case 27840:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case 27841:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case 27842:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case 27843:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case 27844:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case 27845:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case 27846:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case 27847:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case 27848:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case 27849:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case 27850:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case 27851:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case 27852:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case 27853:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case 27854:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case 27855:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case 27856:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case 27857:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case 27858:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case 27859:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case 27860:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case 27861:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case 27862:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case 27863:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case 27867:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case 27868:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case 27869:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case 27870:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case 27871:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case 27872:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case 27873:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case 27874:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case 27875:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case 27876:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case 27877:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case 27878:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case 27879:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case 27880:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case 27881:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case 27882:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case 27883:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case 27884:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case 27885:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case 27887:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case 27889:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case 27890:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case 27891:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case 27892:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case 27893:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case 27894:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case 27895:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case 27896:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case 27897:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case 27898:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case 27899:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case 27900:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case 27901:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case 27902:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case 27903:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case 27904:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case 27905:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case 27906:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case 27907:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case 27908:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case 27909:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case 27910:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case 27911:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case 27912:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case 27913:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case 27914:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case 27915:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case 27916:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case 27917:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case 27919:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case 27920:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case 27921:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case 27922:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case 27923:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case 27924:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case 27925:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case 27926:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case 27927:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case 27928:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case 27929:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case 27930:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case 27931:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case 27932:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case 27934:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case 27936:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case 27939:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case 27942:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case 27943:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case 27944:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case 27945:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case 27946:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case 27947:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case 27948:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case 27949:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case 27950:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case 27951:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case 27952:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case 27953:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case 27954:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case 27955:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case 27956:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case 27957:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case 27958:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case 27959:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case 27960:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case 27961:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case 27963:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case 27964:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case 27965:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case 27966:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case 27967:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case 27968:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case 27969:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case 27970:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case 27971:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case 27972:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case 27973:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case 27977:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case 27980:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case 27983:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case 27986:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case 27989:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case 27991:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case 27992:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case 27993:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case 27994:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case 27995:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case 27996:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_Enabled, true
	case 27997:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri, true
	case 27998:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri, true
	case 27999:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType, true
	case 28000:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities, true
	case 28001:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats, true
	case 28002:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize, true
	case 28003:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled, true
	case 28004:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_HasSecureElement, true
	case 28006:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments, true
	case 28007:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments, true
	case 28011:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments, true
	case 28012:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments, true
	case 28014:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments, true
	case 29879:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_IsSingleton, true
	case 29881:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_RequestTickets_OutputArguments, true
	case 29883:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_SetRegistrarEndpoints_InputArguments, true
	case 32356:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout, true
	case 32357:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout, true
	case 32358:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout, true
	case 32360:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments, true
	case 32361:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments, true
	case 32363:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime, true
	case 32364:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime, true
	case 32365:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result, true
	case 32366:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists, true
	case 32367:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups, true
	case 32368:
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableProvisionableByName(value string) (enum OpcuaNodeIdServicesVariableProvisionable, ok bool) {
	switch value {
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments, true
	case "ProvisionableDeviceType_IsSingleton":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_IsSingleton, true
	case "ProvisionableDeviceType_RequestTickets_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_RequestTickets_OutputArguments, true
	case "ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationDate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ExpirationLimit, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_CertificateType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Certificate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_TrustListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Size, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Writable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UserWritable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MimeType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_MaxByteStringLength, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastModifiedTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_DefaultValidationOptions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateTypes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationDate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ExpirationLimit, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_CertificateType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Certificate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_TrustListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Size, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Writable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UserWritable, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MimeType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_MaxByteStringLength, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastModifiedTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_DefaultValidationOptions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateTypes, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationDate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ExpirationLimit, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_CertificateType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Certificate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EventType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SourceName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Time, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReceiveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LocalTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Message, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Severity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionSubClassName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConditionName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_BranchId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Retain, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_EnabledState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Quality_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastSeverity_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Comment_SourceTimestamp, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ClientUserId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AckedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ConfirmedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ActiveState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_InputNode, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OutOfServiceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_CurrentState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_LastTransition_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableStates, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_AvailableTransitions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_UnshelveTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SuppressedOrShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_MaxTimeShelved, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_ListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_AgencyId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AudibleSound_VersionId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_SilenceState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OnDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_OffDelay, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroupFlag, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Id, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Name, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_Number, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveDisplayName, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_EffectiveTransitionTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_TrueState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LatchedState_FalseState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ReAlarmRepeatCount, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_NormalState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_TrustListId, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_LastUpdateTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_UpdateFrequency, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_Enabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_Enabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationUri, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ProductUri, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationType, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ServerCapabilities, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportedPrivateKeyFormats, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MaxTrustListSize, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_MulticastDnsEnabled, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_HasSecureElement":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_HasSecureElement, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList_OutputArguments, true
	case "ProvisionableDevice_IsSingleton":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_IsSingleton, true
	case "ProvisionableDevice_RequestTickets_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_RequestTickets_OutputArguments, true
	case "ProvisionableDevice_SetRegistrarEndpoints_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDevice_SetRegistrarEndpoints_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_ActivityTimeout, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_ActivityTimeout, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_ActivityTimeout, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_InputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates_OutputArguments, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_StartTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_EndTime, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Result, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedTrustLists, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_AffectedCertificateGroups, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors":
		return OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics_Errors, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableProvisionableKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableProvisionableValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableProvisionable(structType any) OpcuaNodeIdServicesVariableProvisionable {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableProvisionable {
		if sOpcuaNodeIdServicesVariableProvisionable, ok := typ.(OpcuaNodeIdServicesVariableProvisionable); ok {
			return sOpcuaNodeIdServicesVariableProvisionable
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableProvisionable) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableProvisionable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableProvisionableParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableProvisionable, error) {
	return OpcuaNodeIdServicesVariableProvisionableParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableProvisionableParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableProvisionable, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableProvisionable", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableProvisionable")
	}
	if enum, ok := OpcuaNodeIdServicesVariableProvisionableByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableProvisionable")
		return OpcuaNodeIdServicesVariableProvisionable(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableProvisionable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableProvisionable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableProvisionable", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableProvisionable) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableProvisionable) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Size"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Writable"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserWritable"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_OpenCount"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MimeType"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastModifiedTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Close_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_Write_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_LastUpdateTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CurrentVersion"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ActivityTimeout"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SupportedDataType"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_ConfirmUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailableNetworks"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_AvailablePorts"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_SecurityPolicyUris"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_UserTokenTypes"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateTypes"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ApplicationNames"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_SupportsTransactions"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_InApplicationSetup"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CreateSelfSignedCertificate_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_DeleteCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_Purpose"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_Purpose"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_Purpose"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxEndpoints"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_MaxCertificateGroups"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile_CertificateGroupPurposes"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials_CreateCredential_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_IsSingleton:
		return "ProvisionableDeviceType_IsSingleton"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_RequestTickets_OutputArguments:
		return "ProvisionableDeviceType_RequestTickets_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments:
		return "ProvisionableDeviceType_SetRegistrarEndpoints_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Size"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Writable"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UserWritable"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenCount"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MimeType"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_MaxByteStringLength"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastModifiedTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_LastUpdateTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_UpdateFrequency"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_DefaultValidationOptions"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateTypes"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList_OutputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventId"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EventType"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceNode"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SourceName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Time"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ReceiveTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LocalTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Message"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Severity"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassId"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionClassName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassId"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionSubClassName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConditionName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_BranchId"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Retain"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_EnabledState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Quality_SourceTimestamp"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_LastSeverity_SourceTimestamp"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Comment_SourceTimestamp"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ClientUserId"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AckedState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ConfirmedState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ActiveState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_InputNode"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_TrueState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_OutOfServiceState_FalseState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_CurrentState_EffectiveDisplayName"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Id"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Name"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_Number"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_TransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_LastTransition_EffectiveTransitionTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableStates"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_AvailableTransitions"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_UnshelveTime"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2_InputArguments"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_SuppressedOrShelved"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_MaxTimeShelved"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleEnabled"
	case OpcuaNodeIdServicesVariableProvisionable_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AudibleSound:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_Def