/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableDatagram is an enum
type OpcuaNodeIdServicesVariableDatagram int32

type IOpcuaNodeIdServicesVariableDatagram interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface                       OpcuaNodeIdServicesVariableDatagram = 15154
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections            OpcuaNodeIdServicesVariableDatagram = 17579
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions OpcuaNodeIdServicesVariableDatagram = 17580
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList        OpcuaNodeIdServicesVariableDatagram = 17581
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatCount                                     OpcuaNodeIdServicesVariableDatagram = 21134
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatDelay                                     OpcuaNodeIdServicesVariableDatagram = 21135
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAnnounceRate                                   OpcuaNodeIdServicesVariableDatagram = 23839
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryMaxMessageSize                                 OpcuaNodeIdServicesVariableDatagram = 23840
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface                               OpcuaNodeIdServicesVariableDatagram = 23843
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections                    OpcuaNodeIdServicesVariableDatagram = 23844
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions         OpcuaNodeIdServicesVariableDatagram = 23845
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList                OpcuaNodeIdServicesVariableDatagram = 23846
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DatagramQos                                            OpcuaNodeIdServicesVariableDatagram = 23847
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DiscoveryAnnounceRate                                  OpcuaNodeIdServicesVariableDatagram = 23848
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Topic                                                  OpcuaNodeIdServicesVariableDatagram = 23849
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface                             OpcuaNodeIdServicesVariableDatagram = 24018
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections                  OpcuaNodeIdServicesVariableDatagram = 24019
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions       OpcuaNodeIdServicesVariableDatagram = 24020
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList              OpcuaNodeIdServicesVariableDatagram = 24021
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_DatagramQos                                          OpcuaNodeIdServicesVariableDatagram = 24022
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Topic                                                OpcuaNodeIdServicesVariableDatagram = 24023
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_QosCategory                                             OpcuaNodeIdServicesVariableDatagram = 25525
	OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DatagramQos                                             OpcuaNodeIdServicesVariableDatagram = 25526
	OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_QosCategory                                            OpcuaNodeIdServicesVariableDatagram = 25527
	OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_QosCategory                                          OpcuaNodeIdServicesVariableDatagram = 25528
)

var OpcuaNodeIdServicesVariableDatagramValues []OpcuaNodeIdServicesVariableDatagram

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableDatagramValues = []OpcuaNodeIdServicesVariableDatagram{
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatCount,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatDelay,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAnnounceRate,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryMaxMessageSize,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DatagramQos,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DiscoveryAnnounceRate,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Topic,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_DatagramQos,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Topic,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_QosCategory,
		OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DatagramQos,
		OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_QosCategory,
		OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_QosCategory,
	}
}

func OpcuaNodeIdServicesVariableDatagramByValue(value int32) (enum OpcuaNodeIdServicesVariableDatagram, ok bool) {
	switch value {
	case 15154:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface, true
	case 17579:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections, true
	case 17580:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions, true
	case 17581:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList, true
	case 21134:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatCount, true
	case 21135:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatDelay, true
	case 23839:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAnnounceRate, true
	case 23840:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryMaxMessageSize, true
	case 23843:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface, true
	case 23844:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections, true
	case 23845:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions, true
	case 23846:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList, true
	case 23847:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DatagramQos, true
	case 23848:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DiscoveryAnnounceRate, true
	case 23849:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Topic, true
	case 24018:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface, true
	case 24019:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections, true
	case 24020:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions, true
	case 24021:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList, true
	case 24022:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_DatagramQos, true
	case 24023:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Topic, true
	case 25525:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_QosCategory, true
	case 25526:
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DatagramQos, true
	case 25527:
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_QosCategory, true
	case 25528:
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_QosCategory, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDatagramByName(value string) (enum OpcuaNodeIdServicesVariableDatagram, ok bool) {
	switch value {
	case "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface, true
	case "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections, true
	case "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions, true
	case "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList, true
	case "DatagramWriterGroupTransportType_MessageRepeatCount":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatCount, true
	case "DatagramWriterGroupTransportType_MessageRepeatDelay":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatDelay, true
	case "DatagramConnectionTransportType_DiscoveryAnnounceRate":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAnnounceRate, true
	case "DatagramConnectionTransportType_DiscoveryMaxMessageSize":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryMaxMessageSize, true
	case "DatagramWriterGroupTransportType_Address_NetworkInterface":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface, true
	case "DatagramWriterGroupTransportType_Address_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections, true
	case "DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions, true
	case "DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList, true
	case "DatagramWriterGroupTransportType_DatagramQos":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DatagramQos, true
	case "DatagramWriterGroupTransportType_DiscoveryAnnounceRate":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DiscoveryAnnounceRate, true
	case "DatagramWriterGroupTransportType_Topic":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Topic, true
	case "DatagramDataSetReaderTransportType_Address_NetworkInterface":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface, true
	case "DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections, true
	case "DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions, true
	case "DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList, true
	case "DatagramDataSetReaderTransportType_DatagramQos":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_DatagramQos, true
	case "DatagramDataSetReaderTransportType_Topic":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Topic, true
	case "DatagramConnectionTransportType_QosCategory":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_QosCategory, true
	case "DatagramConnectionTransportType_DatagramQos":
		return OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DatagramQos, true
	case "DatagramWriterGroupTransportType_QosCategory":
		return OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_QosCategory, true
	case "DatagramDataSetReaderTransportType_QosCategory":
		return OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_QosCategory, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableDatagramKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableDatagramValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableDatagram(structType any) OpcuaNodeIdServicesVariableDatagram {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableDatagram {
		if sOpcuaNodeIdServicesVariableDatagram, ok := typ.(OpcuaNodeIdServicesVariableDatagram); ok {
			return sOpcuaNodeIdServicesVariableDatagram
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableDatagram) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableDatagram) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableDatagramParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableDatagram, error) {
	return OpcuaNodeIdServicesVariableDatagramParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableDatagramParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableDatagram, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableDatagram", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableDatagram")
	}
	if enum, ok := OpcuaNodeIdServicesVariableDatagramByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableDatagram")
		return OpcuaNodeIdServicesVariableDatagram(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableDatagram) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableDatagram) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableDatagram", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableDatagram) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableDatagram) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface:
		return "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections:
		return "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions:
		return "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList:
		return "DatagramConnectionTransportType_DiscoveryAddress_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatCount:
		return "DatagramWriterGroupTransportType_MessageRepeatCount"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_MessageRepeatDelay:
		return "DatagramWriterGroupTransportType_MessageRepeatDelay"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryAnnounceRate:
		return "DatagramConnectionTransportType_DiscoveryAnnounceRate"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DiscoveryMaxMessageSize:
		return "DatagramConnectionTransportType_DiscoveryMaxMessageSize"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface:
		return "DatagramWriterGroupTransportType_Address_NetworkInterface"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_Selections:
		return "DatagramWriterGroupTransportType_Address_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions:
		return "DatagramWriterGroupTransportType_Address_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList:
		return "DatagramWriterGroupTransportType_Address_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DatagramQos:
		return "DatagramWriterGroupTransportType_DatagramQos"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_DiscoveryAnnounceRate:
		return "DatagramWriterGroupTransportType_DiscoveryAnnounceRate"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_Topic:
		return "DatagramWriterGroupTransportType_Topic"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface:
		return "DatagramDataSetReaderTransportType_Address_NetworkInterface"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections:
		return "DatagramDataSetReaderTransportType_Address_NetworkInterface_Selections"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions:
		return "DatagramDataSetReaderTransportType_Address_NetworkInterface_SelectionDescriptions"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList:
		return "DatagramDataSetReaderTransportType_Address_NetworkInterface_RestrictToList"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_DatagramQos:
		return "DatagramDataSetReaderTransportType_DatagramQos"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_Topic:
		return "DatagramDataSetReaderTransportType_Topic"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_QosCategory:
		return "DatagramConnectionTransportType_QosCategory"
	case OpcuaNodeIdServicesVariableDatagram_DatagramConnectionTransportType_DatagramQos:
		return "DatagramConnectionTransportType_DatagramQos"
	case OpcuaNodeIdServicesVariableDatagram_DatagramWriterGroupTransportType_QosCategory:
		return "DatagramWriterGroupTransportType_QosCategory"
	case OpcuaNodeIdServicesVariableDatagram_DatagramDataSetReaderTransportType_QosCategory:
		return "DatagramDataSetReaderTransportType_QosCategory"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableDatagram) String() string {
	return e.PLC4XEnumName()
}
