/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ActionMethodDataType is the corresponding interface of ActionMethodDataType
type ActionMethodDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetObjectId returns ObjectId (property field)
	GetObjectId() NodeId
	// GetMethodId returns MethodId (property field)
	GetMethodId() NodeId
	// IsActionMethodDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsActionMethodDataType()
	// CreateBuilder creates a ActionMethodDataTypeBuilder
	CreateActionMethodDataTypeBuilder() ActionMethodDataTypeBuilder
}

// _ActionMethodDataType is the data-structure of this message
type _ActionMethodDataType struct {
	ExtensionObjectDefinitionContract
	ObjectId NodeId
	MethodId NodeId
}

var _ ActionMethodDataType = (*_ActionMethodDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ActionMethodDataType)(nil)

// NewActionMethodDataType factory function for _ActionMethodDataType
func NewActionMethodDataType(objectId NodeId, methodId NodeId) *_ActionMethodDataType {
	if objectId == nil {
		panic("objectId of type NodeId for ActionMethodDataType must not be nil")
	}
	if methodId == nil {
		panic("methodId of type NodeId for ActionMethodDataType must not be nil")
	}
	_result := &_ActionMethodDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ObjectId:                          objectId,
		MethodId:                          methodId,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ActionMethodDataTypeBuilder is a builder for ActionMethodDataType
type ActionMethodDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectId NodeId, methodId NodeId) ActionMethodDataTypeBuilder
	// WithObjectId adds ObjectId (property field)
	WithObjectId(NodeId) ActionMethodDataTypeBuilder
	// WithObjectIdBuilder adds ObjectId (property field) which is build by the builder
	WithObjectIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ActionMethodDataTypeBuilder
	// WithMethodId adds MethodId (property field)
	WithMethodId(NodeId) ActionMethodDataTypeBuilder
	// WithMethodIdBuilder adds MethodId (property field) which is build by the builder
	WithMethodIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ActionMethodDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ActionMethodDataType or returns an error if something is wrong
	Build() (ActionMethodDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ActionMethodDataType
}

// NewActionMethodDataTypeBuilder() creates a ActionMethodDataTypeBuilder
func NewActionMethodDataTypeBuilder() ActionMethodDataTypeBuilder {
	return &_ActionMethodDataTypeBuilder{_ActionMethodDataType: new(_ActionMethodDataType)}
}

type _ActionMethodDataTypeBuilder struct {
	*_ActionMethodDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ActionMethodDataTypeBuilder) = (*_ActionMethodDataTypeBuilder)(nil)

func (b *_ActionMethodDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ActionMethodDataType
}

func (b *_ActionMethodDataTypeBuilder) WithMandatoryFields(objectId NodeId, methodId NodeId) ActionMethodDataTypeBuilder {
	return b.WithObjectId(objectId).WithMethodId(methodId)
}

func (b *_ActionMethodDataTypeBuilder) WithObjectId(objectId NodeId) ActionMethodDataTypeBuilder {
	b.ObjectId = objectId
	return b
}

func (b *_ActionMethodDataTypeBuilder) WithObjectIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ActionMethodDataTypeBuilder {
	builder := builderSupplier(b.ObjectId.CreateNodeIdBuilder())
	var err error
	b.ObjectId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ActionMethodDataTypeBuilder) WithMethodId(methodId NodeId) ActionMethodDataTypeBuilder {
	b.MethodId = methodId
	return b
}

func (b *_ActionMethodDataTypeBuilder) WithMethodIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ActionMethodDataTypeBuilder {
	builder := builderSupplier(b.MethodId.CreateNodeIdBuilder())
	var err error
	b.MethodId, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ActionMethodDataTypeBuilder) Build() (ActionMethodDataType, error) {
	if b.ObjectId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectId' not set"))
	}
	if b.MethodId == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'methodId' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ActionMethodDataType.deepCopy(), nil
}

func (b *_ActionMethodDataTypeBuilder) MustBuild() ActionMethodDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ActionMethodDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ActionMethodDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ActionMethodDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateActionMethodDataTypeBuilder().(*_ActionMethodDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateActionMethodDataTypeBuilder creates a ActionMethodDataTypeBuilder
func (b *_ActionMethodDataType) CreateActionMethodDataTypeBuilder() ActionMethodDataTypeBuilder {
	if b == nil {
		return NewActionMethodDataTypeBuilder()
	}
	return &_ActionMethodDataTypeBuilder{_ActionMethodDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ActionMethodDataType) GetExtensionId() int32 {
	return int32(18599)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ActionMethodDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ActionMethodDataType) GetObjectId() NodeId {
	return m.ObjectId
}

func (m *_ActionMethodDataType) GetMethodId() NodeId {
	return m.MethodId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastActionMethodDataType(structType any) ActionMethodDataType {
	if casted, ok := structType.(ActionMethodDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ActionMethodDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ActionMethodDataType) GetTypeName() string {
	return "ActionMethodDataType"
}

func (m *_ActionMethodDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (objectId)
	lengthInBits += m.ObjectId.GetLengthInBits(ctx)

	// Simple field (methodId)
	lengthInBits += m.MethodId.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ActionMethodDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ActionMethodDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__actionMethodDataType ActionMethodDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ActionMethodDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ActionMethodDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectId, err := ReadSimpleField[NodeId](ctx, "objectId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectId' field"))
	}
	m.ObjectId = objectId

	methodId, err := ReadSimpleField[NodeId](ctx, "methodId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'methodId' field"))
	}
	m.MethodId = methodId

	if closeErr := readBuffer.CloseContext("ActionMethodDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ActionMethodDataType")
	}

	return m, nil
}

func (m *_ActionMethodDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ActionMethodDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ActionMethodDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ActionMethodDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "objectId", m.GetObjectId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectId' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "methodId", m.GetMethodId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'methodId' field")
		}

		if popErr := writeBuffer.PopContext("ActionMethodDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ActionMethodDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ActionMethodDataType) IsActionMethodDataType() {}

func (m *_ActionMethodDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ActionMethodDataType) deepCopy() *_ActionMethodDataType {
	if m == nil {
		return nil
	}
	_ActionMethodDataTypeCopy := &_ActionMethodDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.ObjectId),
		utils.DeepCopy[NodeId](m.MethodId),
	}
	_ActionMethodDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ActionMethodDataTypeCopy
}

func (m *_ActionMethodDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
