/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TemperatureBroadcastData is the corresponding interface of TemperatureBroadcastData
type TemperatureBroadcastData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetCommandTypeContainer returns CommandTypeContainer (property field)
	GetCommandTypeContainer() TemperatureBroadcastCommandTypeContainer
	// GetTemperatureGroup returns TemperatureGroup (property field)
	GetTemperatureGroup() byte
	// GetTemperatureByte returns TemperatureByte (property field)
	GetTemperatureByte() byte
	// GetCommandType returns CommandType (virtual field)
	GetCommandType() TemperatureBroadcastCommandType
	// GetTemperatureInCelsius returns TemperatureInCelsius (virtual field)
	GetTemperatureInCelsius() float32
	// IsTemperatureBroadcastData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTemperatureBroadcastData()
	// CreateBuilder creates a TemperatureBroadcastDataBuilder
	CreateTemperatureBroadcastDataBuilder() TemperatureBroadcastDataBuilder
}

// _TemperatureBroadcastData is the data-structure of this message
type _TemperatureBroadcastData struct {
	CommandTypeContainer TemperatureBroadcastCommandTypeContainer
	TemperatureGroup     byte
	TemperatureByte      byte
}

var _ TemperatureBroadcastData = (*_TemperatureBroadcastData)(nil)

// NewTemperatureBroadcastData factory function for _TemperatureBroadcastData
func NewTemperatureBroadcastData(commandTypeContainer TemperatureBroadcastCommandTypeContainer, temperatureGroup byte, temperatureByte byte) *_TemperatureBroadcastData {
	return &_TemperatureBroadcastData{CommandTypeContainer: commandTypeContainer, TemperatureGroup: temperatureGroup, TemperatureByte: temperatureByte}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TemperatureBroadcastDataBuilder is a builder for TemperatureBroadcastData
type TemperatureBroadcastDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(commandTypeContainer TemperatureBroadcastCommandTypeContainer, temperatureGroup byte, temperatureByte byte) TemperatureBroadcastDataBuilder
	// WithCommandTypeContainer adds CommandTypeContainer (property field)
	WithCommandTypeContainer(TemperatureBroadcastCommandTypeContainer) TemperatureBroadcastDataBuilder
	// WithTemperatureGroup adds TemperatureGroup (property field)
	WithTemperatureGroup(byte) TemperatureBroadcastDataBuilder
	// WithTemperatureByte adds TemperatureByte (property field)
	WithTemperatureByte(byte) TemperatureBroadcastDataBuilder
	// Build builds the TemperatureBroadcastData or returns an error if something is wrong
	Build() (TemperatureBroadcastData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TemperatureBroadcastData
}

// NewTemperatureBroadcastDataBuilder() creates a TemperatureBroadcastDataBuilder
func NewTemperatureBroadcastDataBuilder() TemperatureBroadcastDataBuilder {
	return &_TemperatureBroadcastDataBuilder{_TemperatureBroadcastData: new(_TemperatureBroadcastData)}
}

type _TemperatureBroadcastDataBuilder struct {
	*_TemperatureBroadcastData

	collectedErr []error
}

var _ (TemperatureBroadcastDataBuilder) = (*_TemperatureBroadcastDataBuilder)(nil)

func (b *_TemperatureBroadcastDataBuilder) WithMandatoryFields(commandTypeContainer TemperatureBroadcastCommandTypeContainer, temperatureGroup byte, temperatureByte byte) TemperatureBroadcastDataBuilder {
	return b.WithCommandTypeContainer(commandTypeContainer).WithTemperatureGroup(temperatureGroup).WithTemperatureByte(temperatureByte)
}

func (b *_TemperatureBroadcastDataBuilder) WithCommandTypeContainer(commandTypeContainer TemperatureBroadcastCommandTypeContainer) TemperatureBroadcastDataBuilder {
	b.CommandTypeContainer = commandTypeContainer
	return b
}

func (b *_TemperatureBroadcastDataBuilder) WithTemperatureGroup(temperatureGroup byte) TemperatureBroadcastDataBuilder {
	b.TemperatureGroup = temperatureGroup
	return b
}

func (b *_TemperatureBroadcastDataBuilder) WithTemperatureByte(temperatureByte byte) TemperatureBroadcastDataBuilder {
	b.TemperatureByte = temperatureByte
	return b
}

func (b *_TemperatureBroadcastDataBuilder) Build() (TemperatureBroadcastData, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TemperatureBroadcastData.deepCopy(), nil
}

func (b *_TemperatureBroadcastDataBuilder) MustBuild() TemperatureBroadcastData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TemperatureBroadcastDataBuilder) DeepCopy() any {
	_copy := b.CreateTemperatureBroadcastDataBuilder().(*_TemperatureBroadcastDataBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTemperatureBroadcastDataBuilder creates a TemperatureBroadcastDataBuilder
func (b *_TemperatureBroadcastData) CreateTemperatureBroadcastDataBuilder() TemperatureBroadcastDataBuilder {
	if b == nil {
		return NewTemperatureBroadcastDataBuilder()
	}
	return &_TemperatureBroadcastDataBuilder{_TemperatureBroadcastData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TemperatureBroadcastData) GetCommandTypeContainer() TemperatureBroadcastCommandTypeContainer {
	return m.CommandTypeContainer
}

func (m *_TemperatureBroadcastData) GetTemperatureGroup() byte {
	return m.TemperatureGroup
}

func (m *_TemperatureBroadcastData) GetTemperatureByte() byte {
	return m.TemperatureByte
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_TemperatureBroadcastData) GetCommandType() TemperatureBroadcastCommandType {
	ctx := context.Background()
	_ = ctx
	return CastTemperatureBroadcastCommandType(m.GetCommandTypeContainer().CommandType())
}

func (m *_TemperatureBroadcastData) GetTemperatureInCelsius() float32 {
	ctx := context.Background()
	_ = ctx
	return float32(float32(m.GetTemperatureByte()) / float32(float32(4)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTemperatureBroadcastData(structType any) TemperatureBroadcastData {
	if casted, ok := structType.(TemperatureBroadcastData); ok {
		return casted
	}
	if casted, ok := structType.(*TemperatureBroadcastData); ok {
		return *casted
	}
	return nil
}

func (m *_TemperatureBroadcastData) GetTypeName() string {
	return "TemperatureBroadcastData"
}

func (m *_TemperatureBroadcastData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (commandTypeContainer)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// Simple field (temperatureGroup)
	lengthInBits += 8

	// Simple field (temperatureByte)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_TemperatureBroadcastData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func TemperatureBroadcastDataParse(ctx context.Context, theBytes []byte) (TemperatureBroadcastData, error) {
	return TemperatureBroadcastDataParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func TemperatureBroadcastDataParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (TemperatureBroadcastData, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (TemperatureBroadcastData, error) {
		return TemperatureBroadcastDataParseWithBuffer(ctx, readBuffer)
	}
}

func TemperatureBroadcastDataParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (TemperatureBroadcastData, error) {
	v, err := (&_TemperatureBroadcastData{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_TemperatureBroadcastData) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__temperatureBroadcastData TemperatureBroadcastData, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TemperatureBroadcastData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TemperatureBroadcastData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(KnowsTemperatureBroadcastCommandTypeContainer(ctx, readBuffer)) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "no command type could be found"})
	}

	commandTypeContainer, err := ReadEnumField[TemperatureBroadcastCommandTypeContainer](ctx, "commandTypeContainer", "TemperatureBroadcastCommandTypeContainer", ReadEnum(TemperatureBroadcastCommandTypeContainerByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandTypeContainer' field"))
	}
	m.CommandTypeContainer = commandTypeContainer

	commandType, err := ReadVirtualField[TemperatureBroadcastCommandType](ctx, "commandType", (*TemperatureBroadcastCommandType)(nil), commandTypeContainer.CommandType())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'commandType' field"))
	}
	_ = commandType

	temperatureGroup, err := ReadSimpleField(ctx, "temperatureGroup", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'temperatureGroup' field"))
	}
	m.TemperatureGroup = temperatureGroup

	temperatureByte, err := ReadSimpleField(ctx, "temperatureByte", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'temperatureByte' field"))
	}
	m.TemperatureByte = temperatureByte

	temperatureInCelsius, err := ReadVirtualField[float32](ctx, "temperatureInCelsius", (*float32)(nil), float32(temperatureByte)/float32(float32(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'temperatureInCelsius' field"))
	}
	_ = temperatureInCelsius

	if closeErr := readBuffer.CloseContext("TemperatureBroadcastData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TemperatureBroadcastData")
	}

	return m, nil
}

func (m *_TemperatureBroadcastData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TemperatureBroadcastData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("TemperatureBroadcastData"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for TemperatureBroadcastData")
	}

	if err := WriteSimpleEnumField[TemperatureBroadcastCommandTypeContainer](ctx, "commandTypeContainer", "TemperatureBroadcastCommandTypeContainer", m.GetCommandTypeContainer(), WriteEnum[TemperatureBroadcastCommandTypeContainer, uint8](TemperatureBroadcastCommandTypeContainer.GetValue, TemperatureBroadcastCommandTypeContainer.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'commandTypeContainer' field")
	}
	// Virtual field
	commandType := m.GetCommandType()
	_ = commandType
	if _commandTypeErr := writeBuffer.WriteVirtual(ctx, "commandType", m.GetCommandType()); _commandTypeErr != nil {
		return errors.Wrap(_commandTypeErr, "Error serializing 'commandType' field")
	}

	if err := WriteSimpleField[byte](ctx, "temperatureGroup", m.GetTemperatureGroup(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'temperatureGroup' field")
	}

	if err := WriteSimpleField[byte](ctx, "temperatureByte", m.GetTemperatureByte(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'temperatureByte' field")
	}
	// Virtual field
	temperatureInCelsius := m.GetTemperatureInCelsius()
	_ = temperatureInCelsius
	if _temperatureInCelsiusErr := writeBuffer.WriteVirtual(ctx, "temperatureInCelsius", m.GetTemperatureInCelsius()); _temperatureInCelsiusErr != nil {
		return errors.Wrap(_temperatureInCelsiusErr, "Error serializing 'temperatureInCelsius' field")
	}

	if popErr := writeBuffer.PopContext("TemperatureBroadcastData"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for TemperatureBroadcastData")
	}
	return nil
}

func (m *_TemperatureBroadcastData) IsTemperatureBroadcastData() {}

func (m *_TemperatureBroadcastData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TemperatureBroadcastData) deepCopy() *_TemperatureBroadcastData {
	if m == nil {
		return nil
	}
	_TemperatureBroadcastDataCopy := &_TemperatureBroadcastData{
		m.CommandTypeContainer,
		m.TemperatureGroup,
		m.TemperatureByte,
	}
	return _TemperatureBroadcastDataCopy
}

func (m *_TemperatureBroadcastData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
