/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MeteringDataGasConsumption is the corresponding interface of MeteringDataGasConsumption
type MeteringDataGasConsumption interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MeteringData
	// GetMJ returns MJ (property field)
	GetMJ() uint32
	// IsMeteringDataGasConsumption is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeteringDataGasConsumption()
	// CreateBuilder creates a MeteringDataGasConsumptionBuilder
	CreateMeteringDataGasConsumptionBuilder() MeteringDataGasConsumptionBuilder
}

// _MeteringDataGasConsumption is the data-structure of this message
type _MeteringDataGasConsumption struct {
	MeteringDataContract
	MJ uint32
}

var _ MeteringDataGasConsumption = (*_MeteringDataGasConsumption)(nil)
var _ MeteringDataRequirements = (*_MeteringDataGasConsumption)(nil)

// NewMeteringDataGasConsumption factory function for _MeteringDataGasConsumption
func NewMeteringDataGasConsumption(commandTypeContainer MeteringCommandTypeContainer, argument byte, mJ uint32) *_MeteringDataGasConsumption {
	_result := &_MeteringDataGasConsumption{
		MeteringDataContract: NewMeteringData(commandTypeContainer, argument),
		MJ:                   mJ,
	}
	_result.MeteringDataContract.(*_MeteringData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MeteringDataGasConsumptionBuilder is a builder for MeteringDataGasConsumption
type MeteringDataGasConsumptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(mJ uint32) MeteringDataGasConsumptionBuilder
	// WithMJ adds MJ (property field)
	WithMJ(uint32) MeteringDataGasConsumptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MeteringDataBuilder
	// Build builds the MeteringDataGasConsumption or returns an error if something is wrong
	Build() (MeteringDataGasConsumption, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MeteringDataGasConsumption
}

// NewMeteringDataGasConsumptionBuilder() creates a MeteringDataGasConsumptionBuilder
func NewMeteringDataGasConsumptionBuilder() MeteringDataGasConsumptionBuilder {
	return &_MeteringDataGasConsumptionBuilder{_MeteringDataGasConsumption: new(_MeteringDataGasConsumption)}
}

type _MeteringDataGasConsumptionBuilder struct {
	*_MeteringDataGasConsumption

	parentBuilder *_MeteringDataBuilder

	collectedErr []error
}

var _ (MeteringDataGasConsumptionBuilder) = (*_MeteringDataGasConsumptionBuilder)(nil)

func (b *_MeteringDataGasConsumptionBuilder) setParent(contract MeteringDataContract) {
	b.MeteringDataContract = contract
	contract.(*_MeteringData)._SubType = b._MeteringDataGasConsumption
}

func (b *_MeteringDataGasConsumptionBuilder) WithMandatoryFields(mJ uint32) MeteringDataGasConsumptionBuilder {
	return b.WithMJ(mJ)
}

func (b *_MeteringDataGasConsumptionBuilder) WithMJ(mJ uint32) MeteringDataGasConsumptionBuilder {
	b.MJ = mJ
	return b
}

func (b *_MeteringDataGasConsumptionBuilder) Build() (MeteringDataGasConsumption, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MeteringDataGasConsumption.deepCopy(), nil
}

func (b *_MeteringDataGasConsumptionBuilder) MustBuild() MeteringDataGasConsumption {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeteringDataGasConsumptionBuilder) Done() MeteringDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMeteringDataBuilder().(*_MeteringDataBuilder)
	}
	return b.parentBuilder
}

func (b *_MeteringDataGasConsumptionBuilder) buildForMeteringData() (MeteringData, error) {
	return b.Build()
}

func (b *_MeteringDataGasConsumptionBuilder) DeepCopy() any {
	_copy := b.CreateMeteringDataGasConsumptionBuilder().(*_MeteringDataGasConsumptionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMeteringDataGasConsumptionBuilder creates a MeteringDataGasConsumptionBuilder
func (b *_MeteringDataGasConsumption) CreateMeteringDataGasConsumptionBuilder() MeteringDataGasConsumptionBuilder {
	if b == nil {
		return NewMeteringDataGasConsumptionBuilder()
	}
	return &_MeteringDataGasConsumptionBuilder{_MeteringDataGasConsumption: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MeteringDataGasConsumption) GetParent() MeteringDataContract {
	return m.MeteringDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MeteringDataGasConsumption) GetMJ() uint32 {
	return m.MJ
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMeteringDataGasConsumption(structType any) MeteringDataGasConsumption {
	if casted, ok := structType.(MeteringDataGasConsumption); ok {
		return casted
	}
	if casted, ok := structType.(*MeteringDataGasConsumption); ok {
		return *casted
	}
	return nil
}

func (m *_MeteringDataGasConsumption) GetTypeName() string {
	return "MeteringDataGasConsumption"
}

func (m *_MeteringDataGasConsumption) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MeteringDataContract.(*_MeteringData).getLengthInBits(ctx))

	// Simple field (mJ)
	lengthInBits += 32

	return lengthInBits
}

func (m *_MeteringDataGasConsumption) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MeteringDataGasConsumption) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MeteringData) (__meteringDataGasConsumption MeteringDataGasConsumption, err error) {
	m.MeteringDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MeteringDataGasConsumption"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MeteringDataGasConsumption")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	mJ, err := ReadSimpleField(ctx, "mJ", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'mJ' field"))
	}
	m.MJ = mJ

	if closeErr := readBuffer.CloseContext("MeteringDataGasConsumption"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MeteringDataGasConsumption")
	}

	return m, nil
}

func (m *_MeteringDataGasConsumption) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MeteringDataGasConsumption) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MeteringDataGasConsumption"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MeteringDataGasConsumption")
		}

		if err := WriteSimpleField[uint32](ctx, "mJ", m.GetMJ(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'mJ' field")
		}

		if popErr := writeBuffer.PopContext("MeteringDataGasConsumption"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MeteringDataGasConsumption")
		}
		return nil
	}
	return m.MeteringDataContract.(*_MeteringData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MeteringDataGasConsumption) IsMeteringDataGasConsumption() {}

func (m *_MeteringDataGasConsumption) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MeteringDataGasConsumption) deepCopy() *_MeteringDataGasConsumption {
	if m == nil {
		return nil
	}
	_MeteringDataGasConsumptionCopy := &_MeteringDataGasConsumption{
		m.MeteringDataContract.(*_MeteringData).deepCopy(),
		m.MJ,
	}
	_MeteringDataGasConsumptionCopy.MeteringDataContract.(*_MeteringData)._SubType = m
	return _MeteringDataGasConsumptionCopy
}

func (m *_MeteringDataGasConsumption) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
