/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetDeviceObjectReference is the corresponding interface of BACnetDeviceObjectReference
type BACnetDeviceObjectReference interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDeviceIdentifier returns DeviceIdentifier (property field)
	GetDeviceIdentifier() BACnetContextTagObjectIdentifier
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetContextTagObjectIdentifier
	// IsBACnetDeviceObjectReference is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetDeviceObjectReference()
	// CreateBuilder creates a BACnetDeviceObjectReferenceBuilder
	CreateBACnetDeviceObjectReferenceBuilder() BACnetDeviceObjectReferenceBuilder
}

// _BACnetDeviceObjectReference is the data-structure of this message
type _BACnetDeviceObjectReference struct {
	DeviceIdentifier BACnetContextTagObjectIdentifier
	ObjectIdentifier BACnetContextTagObjectIdentifier
}

var _ BACnetDeviceObjectReference = (*_BACnetDeviceObjectReference)(nil)

// NewBACnetDeviceObjectReference factory function for _BACnetDeviceObjectReference
func NewBACnetDeviceObjectReference(deviceIdentifier BACnetContextTagObjectIdentifier, objectIdentifier BACnetContextTagObjectIdentifier) *_BACnetDeviceObjectReference {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetContextTagObjectIdentifier for BACnetDeviceObjectReference must not be nil")
	}
	return &_BACnetDeviceObjectReference{DeviceIdentifier: deviceIdentifier, ObjectIdentifier: objectIdentifier}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetDeviceObjectReferenceBuilder is a builder for BACnetDeviceObjectReference
type BACnetDeviceObjectReferenceBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder
	// WithDeviceIdentifier adds DeviceIdentifier (property field)
	WithOptionalDeviceIdentifier(BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder
	// WithOptionalDeviceIdentifierBuilder adds DeviceIdentifier (property field) which is build by the builder
	WithOptionalDeviceIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetDeviceObjectReferenceBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetDeviceObjectReferenceBuilder
	// Build builds the BACnetDeviceObjectReference or returns an error if something is wrong
	Build() (BACnetDeviceObjectReference, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetDeviceObjectReference
}

// NewBACnetDeviceObjectReferenceBuilder() creates a BACnetDeviceObjectReferenceBuilder
func NewBACnetDeviceObjectReferenceBuilder() BACnetDeviceObjectReferenceBuilder {
	return &_BACnetDeviceObjectReferenceBuilder{_BACnetDeviceObjectReference: new(_BACnetDeviceObjectReference)}
}

type _BACnetDeviceObjectReferenceBuilder struct {
	*_BACnetDeviceObjectReference

	collectedErr []error
}

var _ (BACnetDeviceObjectReferenceBuilder) = (*_BACnetDeviceObjectReferenceBuilder)(nil)

func (b *_BACnetDeviceObjectReferenceBuilder) WithMandatoryFields(objectIdentifier BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder {
	return b.WithObjectIdentifier(objectIdentifier)
}

func (b *_BACnetDeviceObjectReferenceBuilder) WithOptionalDeviceIdentifier(deviceIdentifier BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder {
	b.DeviceIdentifier = deviceIdentifier
	return b
}

func (b *_BACnetDeviceObjectReferenceBuilder) WithOptionalDeviceIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetDeviceObjectReferenceBuilder {
	builder := builderSupplier(b.DeviceIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.DeviceIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectReferenceBuilder) WithObjectIdentifier(objectIdentifier BACnetContextTagObjectIdentifier) BACnetDeviceObjectReferenceBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetDeviceObjectReferenceBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetDeviceObjectReferenceBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetDeviceObjectReferenceBuilder) Build() (BACnetDeviceObjectReference, error) {
	if b.ObjectIdentifier == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetDeviceObjectReference.deepCopy(), nil
}

func (b *_BACnetDeviceObjectReferenceBuilder) MustBuild() BACnetDeviceObjectReference {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetDeviceObjectReferenceBuilder) DeepCopy() any {
	_copy := b.CreateBACnetDeviceObjectReferenceBuilder().(*_BACnetDeviceObjectReferenceBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetDeviceObjectReferenceBuilder creates a BACnetDeviceObjectReferenceBuilder
func (b *_BACnetDeviceObjectReference) CreateBACnetDeviceObjectReferenceBuilder() BACnetDeviceObjectReferenceBuilder {
	if b == nil {
		return NewBACnetDeviceObjectReferenceBuilder()
	}
	return &_BACnetDeviceObjectReferenceBuilder{_BACnetDeviceObjectReference: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetDeviceObjectReference) GetDeviceIdentifier() BACnetContextTagObjectIdentifier {
	return m.DeviceIdentifier
}

func (m *_BACnetDeviceObjectReference) GetObjectIdentifier() BACnetContextTagObjectIdentifier {
	return m.ObjectIdentifier
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetDeviceObjectReference(structType any) BACnetDeviceObjectReference {
	if casted, ok := structType.(BACnetDeviceObjectReference); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetDeviceObjectReference); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetDeviceObjectReference) GetTypeName() string {
	return "BACnetDeviceObjectReference"
}

func (m *_BACnetDeviceObjectReference) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Optional Field (deviceIdentifier)
	if m.DeviceIdentifier != nil {
		lengthInBits += m.DeviceIdentifier.GetLengthInBits(ctx)
	}

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetDeviceObjectReference) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetDeviceObjectReferenceParse(ctx context.Context, theBytes []byte) (BACnetDeviceObjectReference, error) {
	return BACnetDeviceObjectReferenceParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetDeviceObjectReferenceParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectReference, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectReference, error) {
		return BACnetDeviceObjectReferenceParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetDeviceObjectReferenceParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetDeviceObjectReference, error) {
	v, err := (&_BACnetDeviceObjectReference{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetDeviceObjectReference) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetDeviceObjectReference BACnetDeviceObjectReference, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetDeviceObjectReference"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetDeviceObjectReference")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var deviceIdentifier BACnetContextTagObjectIdentifier
	_deviceIdentifier, err := ReadOptionalField[BACnetContextTagObjectIdentifier](ctx, "deviceIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deviceIdentifier' field"))
	}
	if _deviceIdentifier != nil {
		deviceIdentifier = *_deviceIdentifier
		m.DeviceIdentifier = deviceIdentifier
	}

	objectIdentifier, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	if closeErr := readBuffer.CloseContext("BACnetDeviceObjectReference"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetDeviceObjectReference")
	}

	return m, nil
}

func (m *_BACnetDeviceObjectReference) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetDeviceObjectReference) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetDeviceObjectReference"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetDeviceObjectReference")
	}

	if err := WriteOptionalField[BACnetContextTagObjectIdentifier](ctx, "deviceIdentifier", GetRef(m.GetDeviceIdentifier()), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'deviceIdentifier' field")
	}

	if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
	}

	if popErr := writeBuffer.PopContext("BACnetDeviceObjectReference"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetDeviceObjectReference")
	}
	return nil
}

func (m *_BACnetDeviceObjectReference) IsBACnetDeviceObjectReference() {}

func (m *_BACnetDeviceObjectReference) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetDeviceObjectReference) deepCopy() *_BACnetDeviceObjectReference {
	if m == nil {
		return nil
	}
	_BACnetDeviceObjectReferenceCopy := &_BACnetDeviceObjectReference{
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.DeviceIdentifier),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.ObjectIdentifier),
	}
	return _BACnetDeviceObjectReferenceCopy
}

func (m *_BACnetDeviceObjectReference) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
