/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.IllegalProductException;
import jakarta.enterprise.inject.TransientReference;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Producer;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class AbstractInjectable<T> {
    protected Producer<?> owner;
    protected final CreationalContextImpl<?> creationalContext;
    protected CreationalContextImpl<?> transientCreationalContext;

    protected AbstractInjectable(Producer<?> owner, CreationalContextImpl<?> creationalContext) {
        this.owner = owner;
        this.creationalContext = creationalContext;
        this.transientCreationalContext = creationalContext.getWebBeansContext().getBeanManagerImpl().createCreationalContext((Contextual)creationalContext.getContextual());
    }

    public T inject(InjectionPoint injectionPoint) {
        CreationalContextImpl<?> injectionPointContext;
        Object injected;
        BeanManagerImpl beanManager = this.creationalContext.getWebBeansContext().getBeanManagerImpl();
        Bean<?> injectedBean = beanManager.getInjectionResolver().getInjectionPointBean(injectionPoint);
        boolean dependentProducer = false;
        if (WebBeansUtil.isDependent(injectedBean) && !injectionPoint.isTransient() && injectedBean instanceof AbstractProducerBean && this.creationalContext.getBean() != null && beanManager.isPassivatingScope(this.creationalContext.getBean().getScope())) {
            dependentProducer = true;
        }
        if ((injected = beanManager.getInjectableReference(injectionPoint, injectionPointContext = injectionPoint.getAnnotated().isAnnotationPresent(TransientReference.class) ? this.transientCreationalContext : this.creationalContext)) == null) {
            if (beanManager.isNormalScope(injectedBean.getScope())) {
                throw new IllegalStateException("InjectableReference is 'null' for " + injectionPoint.toString());
            }
            Class<?> type = ClassUtil.getClass(injectionPoint.getType());
            if (type.isPrimitive()) {
                injected = ClassUtil.getDefaultValue(type);
            }
        }
        if (dependentProducer && injected != null && !Serializable.class.isAssignableFrom(injected.getClass())) {
            throw new IllegalProductException("A producer method or field of scope @Dependent returns an unserializable object for injection into an injection point " + injectionPoint + " that requires a passivation capable dependency");
        }
        return (T)injected;
    }

    protected Contextual<?> getBean() {
        return this.creationalContext.getBean();
    }

    protected WebBeansContext getWebBeansContext() {
        return this.creationalContext.getWebBeansContext();
    }

    protected List<InjectionPoint> getInjectionPoints(Member member) {
        return AbstractInjectable.createInjectionPoints(this.owner, member);
    }

    protected static List<InjectionPoint> createInjectionPoints(Producer<?> owner, Member member) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (InjectionPoint injectionPoint : owner.getInjectionPoints()) {
            if (!injectionPoint.getMember().equals(member)) continue;
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

