/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.ComposedGeospatial;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class Polygon
extends Geospatial {
    final ComposedGeospatial<LineString> interiorRings;
    final ComposedGeospatial<Point> exterior;

    public Polygon(Geospatial.Dimension dimension, SRID srid, List<Point> interior, List<Point> exterior) {
        super(dimension, Geospatial.Type.POLYGON, srid);
        if (interior != null) {
            LineString lineString = new LineString(dimension, srid, interior);
            this.interiorRings = new MultiLineString(dimension, srid, Arrays.asList(lineString));
        } else {
            this.interiorRings = null;
        }
        this.exterior = new LineString(dimension, srid, exterior);
    }

    public Polygon(Geospatial.Dimension dimension, SRID srid, List<LineString> interiors, LineString exterior) {
        super(dimension, Geospatial.Type.POLYGON, srid);
        this.interiorRings = interiors != null ? new MultiLineString(dimension, srid, interiors) : null;
        this.exterior = exterior;
    }

    public ComposedGeospatial<Point> getInterior() {
        if (this.interiorRings == null || this.interiorRings.geospatials.isEmpty()) {
            return null;
        }
        return this.getInterior(0);
    }

    public int getNumberOfInteriorRings() {
        if (this.interiorRings == null) {
            return 0;
        }
        return this.interiorRings.geospatials.size();
    }

    public ComposedGeospatial<Point> getInterior(int n) {
        return (ComposedGeospatial)this.interiorRings.geospatials.get(n);
    }

    public ComposedGeospatial<Point> getExterior() {
        return this.exterior;
    }

    @Override
    public EdmPrimitiveTypeKind getEdmPrimitiveTypeKind() {
        return this.dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPolygon : EdmPrimitiveTypeKind.GeometryPolygon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.dimension == polygon.dimension && (this.srid == null ? polygon.srid == null : this.srid.equals(polygon.srid)) && (this.interiorRings == null ? polygon.interiorRings == null : this.interiorRings.equals(polygon.interiorRings)) && (this.exterior == null ? polygon.exterior == null : this.exterior.equals(polygon.exterior));
    }

    public int hashCode() {
        int result = this.dimension == null ? 0 : this.dimension.hashCode();
        result = 31 * result + (this.srid == null ? 0 : this.srid.hashCode());
        result = 31 * result + (this.interiorRings == null ? 0 : this.interiorRings.hashCode());
        result = 31 * result + (this.exterior == null ? 0 : this.exterior.hashCode());
        return result;
    }
}

